/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.impl.database.AbstractPagingSortingFilteringRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.SearchTermTemplates;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.list.filtering.FilterCriteria;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.FilterLogicalOperator;
import de.digitalcollections.model.list.filtering.FilterOperation;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.text.LocalizedText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.JdbiException;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.StatementException;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class JdbiRepositoryImpl<U extends UniqueObject>
extends AbstractPagingSortingFilteringRepositoryImpl {
    private static final String KEY_PREFIX_FILTERVALUE = "filtervalue_";
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbiRepositoryImpl.class);
    protected final Jdbi dbi;
    protected final String mappingPrefix;
    protected final String tableAlias;
    protected final String tableName;

    private static String getArrayTypeAndFillArgumentMappings(Map<String, Object> argumentMappings, String criterionKey, Collection<?> valueCollection) {
        String arrayType = "varchar[]";
        Object valueSample = valueCollection.stream().findFirst().get();
        if (valueSample instanceof UUID) {
            argumentMappings.put(criterionKey, valueCollection.stream().toArray(UUID[]::new));
            arrayType = "UUID[]";
        } else if (valueSample instanceof String) {
            argumentMappings.put(criterionKey, valueCollection.stream().toArray(String[]::new));
            arrayType = "varchar[]";
        } else if (valueSample instanceof Integer) {
            argumentMappings.put(criterionKey, valueCollection.stream().toArray(Integer[]::new));
            arrayType = "int[]";
        } else if (valueSample instanceof Long) {
            argumentMappings.put(criterionKey, valueCollection.stream().toArray(Long[]::new));
            arrayType = "long[]";
        }
        return arrayType;
    }

    protected JdbiRepositoryImpl() {
        this.dbi = null;
        this.mappingPrefix = "";
        this.tableAlias = "";
        this.tableName = "";
    }

    public JdbiRepositoryImpl(Jdbi dbi, String tableName, String tableAlias, String mappingPrefix, int offsetForAlternativePaging) {
        this.dbi = dbi;
        this.mappingPrefix = mappingPrefix;
        this.tableName = tableName;
        this.tableAlias = tableAlias;
        this.offsetForAlternativePaging = offsetForAlternativePaging;
    }

    public void addFiltering(Filtering filtering, StringBuilder sqlQuery, Map<String, Object> argumentMappings) {
        String whereClauses;
        if (filtering != null && !(whereClauses = this.getWhereClauses(filtering, argumentMappings)).isEmpty()) {
            String sqlQueryStr = sqlQuery.toString();
            if (sqlQueryStr.toUpperCase().contains(" WHERE ")) {
                sqlQuery.append(" AND ");
            } else {
                sqlQuery.append(" WHERE ");
            }
            sqlQuery.append(whereClauses);
        }
    }

    public void addFiltering(PageRequest pageRequest, StringBuilder sqlQuery, Map<String, Object> argumentMappings) {
        if (pageRequest != null) {
            this.addFiltering(pageRequest.getFiltering(), sqlQuery, argumentMappings);
        }
    }

    public long count() throws RepositoryException {
        String sql = "SELECT count(*) FROM " + this.tableName;
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    public long count(String commonSql, Map<String, Object> argumentMappings) throws RepositoryException {
        String sql = "SELECT count(*) " + commonSql;
        return (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sql).bindMap(argumentMappings)).mapTo(Long.class).findOne().get());
    }

    protected final String escapeTermForJsonpath(String term) {
        if (term == null) {
            return null;
        }
        if (term.startsWith("\"") && term.endsWith("\"")) {
            term = term.replaceAll("^\"(.+)\"$", "$1");
        }
        if (term.contains("\"")) {
            term = term.replaceAll("\"", "\\\\\"");
        }
        return term;
    }

    protected int execUpdateWithList(String sql, String key, List values) throws RepositoryException {
        try {
            return (Integer)this.dbi.withHandle(h -> ((Update)h.createUpdate(sql).bindList(key, (Iterable)values)).execute());
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected int execUpdateWithMap(String sql, Map<String, Object> bindings) throws RepositoryException {
        try {
            return (Integer)this.dbi.withHandle(h -> ((Update)h.createUpdate(sql).bindMap(bindings)).execute());
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void filterByLocalizedTextFields(PageRequest pageRequest, PageResponse<U> pageResponse, LinkedHashMap<String, Function<U, Optional<Object>>> jsonbFields) {
        if (!pageRequest.hasFiltering()) {
            return;
        }
        for (Map.Entry<String, Function<U, Optional<Object>>> entry : jsonbFields.entrySet()) {
            String fieldName = entry.getKey();
            Function<U, Optional<Object>> retrieveFieldFunction = entry.getValue();
            FilterCriterion filterCriterion = pageRequest.getFiltering().getFilterCriteriaList().stream().filter(fca -> fca.hasFilterCriterionFor(fieldName)).map(fca -> fca.getFilterCriterionFor(fieldName)).findAny().orElse(null);
            if (filterCriterion == null) continue;
            this.filterBySplitField(pageResponse, (FilterCriterion<String>)filterCriterion, retrieveFieldFunction);
            return;
        }
    }

    protected void filterBySplitField(PageResponse<U> pageResponse, FilterCriterion<String> filter, Function<U, Optional<Object>> retrieveField) {
        if (!pageResponse.hasContent()) {
            return;
        }
        if (filter.getOperation() == FilterOperation.EQUALS) {
            return;
        }
        Matcher matchLanguage = Pattern.compile("\\.([\\w_-]+)$").matcher(filter.getExpression());
        if (matchLanguage.find()) {
            Locale language = Locale.forLanguageTag(matchLanguage.group(1));
            List<String> searchTerms = Arrays.asList(this.splitToArray((String)filter.getValue()));
            List filteredContent = pageResponse.getContent().parallelStream().filter(uniqueObject -> {
                Object obj;
                Optional objOpt = (Optional)retrieveField.apply(uniqueObject);
                if (objOpt.isPresent() && (obj = objOpt.get()) instanceof LocalizedText) {
                    String text = (String)((LocalizedText)obj).get((Object)language);
                    if (text == null) {
                        return false;
                    }
                    List<String> splitText = Arrays.asList(this.splitToArray(text));
                    return splitText.containsAll(searchTerms);
                }
                return false;
            }).collect(Collectors.toList());
            pageResponse.setTotalElements(pageResponse.getTotalElements() - (long)(pageResponse.getContent().size() - filteredContent.size()));
            pageResponse.setContent(filteredContent);
        }
    }

    protected String getTargetExpression(FilterCriterion<?> fc) throws IllegalArgumentException {
        String givenExpression = fc.getExpression();
        if (fc.isNativeExpression()) {
            return givenExpression;
        }
        String columnName = this.getColumnName(givenExpression);
        if (columnName == null && givenExpression.contains(".")) {
            columnName = this.getColumnName(this.extractPropertyFromFilterExpression(givenExpression));
        }
        if (columnName == null) {
            throw new IllegalArgumentException(String.format("Given expression '%s' is invalid / can not be mapped to column name.", givenExpression));
        }
        return columnName;
    }

    protected LinkedHashMap<String, Function<U, Optional<Object>>> getJsonbFields() {
        return new LinkedHashMap<String, Function<U, Optional<Object>>>();
    }

    public String getMappingPrefix() {
        return this.mappingPrefix;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getTableName() {
        return this.tableName;
    }

    private String extractPropertyFromFilterExpression(String expression) {
        return StringUtils.hasText((String)expression) ? expression.split("\\.", 2)[0] : null;
    }

    private String makeConditionForJsonbColumn(FilterCriterion<?> fc, Map<String, Object> argumentMappings, int criterionCount) {
        Object object = fc.getValue();
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("Value of JSONB field expression must be a string!");
        }
        String value = (String)object;
        FilterOperation operation = fc.getOperation();
        if (value.matches("\".+\"") && operation == FilterOperation.CONTAINS) {
            operation = FilterOperation.EQUALS;
        }
        String filterProperty = this.extractPropertyFromFilterExpression(fc.getExpression());
        switch (operation) {
            case CONTAINS: {
                if (this.hasSplitColumn(filterProperty)) {
                    argumentMappings.put("%s_%d".formatted(SearchTermTemplates.ARRAY_CONTAINS.placeholder, criterionCount), this.splitToArray(value));
                    return SearchTermTemplates.ARRAY_CONTAINS.renderTemplate(String.valueOf(criterionCount), this.tableAlias, "split_" + filterProperty);
                }
            }
            case EQUALS: {
                Matcher matchLanguage = Pattern.compile("\\.([\\w_-]+)$").matcher(fc.getExpression());
                String language = matchLanguage.find() ? "\"%s\"".formatted(matchLanguage.group(1)) : "**";
                String colName = this.getTargetExpression(fc);
                argumentMappings.put("%s_%d".formatted(SearchTermTemplates.JSONB_PATH.placeholder, criterionCount), this.escapeTermForJsonpath(value));
                return SearchTermTemplates.JSONB_PATH.renderTemplate(String.valueOf(criterionCount), colName, language);
            }
        }
        throw new UnsupportedOperationException("Filtering by JSONB field only supports CONTAINS (to be preferred) or EQUALS operator!");
    }

    protected String getWhereClause(FilterCriterion<?> fc, Map<String, Object> argumentMappings, int criterionCount) throws IllegalArgumentException, UnsupportedOperationException {
        if (fc == null || !StringUtils.hasText((String)fc.getExpression())) {
            return "";
        }
        Set<String> jsonbFields = this.getJsonbFields().keySet();
        String filterProperty = this.extractPropertyFromFilterExpression(fc.getExpression());
        if (filterProperty != null && jsonbFields.contains(filterProperty)) {
            return this.makeConditionForJsonbColumn(fc, argumentMappings, criterionCount);
        }
        String expression = this.getTargetExpression(fc);
        StringBuilder query = new StringBuilder();
        FilterOperation filterOperation = fc.getOperation();
        String criterionKey = KEY_PREFIX_FILTERVALUE + criterionCount;
        switch (filterOperation) {
            case BETWEEN: {
                if (fc.getMinValue() == null || fc.getMaxValue() == null) {
                    throw new IllegalArgumentException("For 'BETWEEN' operation two values are expected");
                }
                String keyMin = criterionKey + "_min";
                String keyMax = criterionKey + "_max";
                query.append("(").append(expression).append(" BETWEEN ").append(":").append(keyMin).append(" AND ").append(":").append(keyMax).append(")");
                argumentMappings.put(keyMin, fc.getMinValue());
                argumentMappings.put(keyMax, fc.getMaxValue());
                break;
            }
            case IN: 
            case NOT_IN: {
                if (fc.getValues() == null || fc.getValues().isEmpty()) {
                    throw new IllegalArgumentException("For 'IN/NOT_IN' operation at least one value is expected");
                }
                query.append("(").append(expression);
                if (filterOperation == FilterOperation.NOT_IN) {
                    query.append(" NOT");
                }
                query.append(" IN (");
                ArrayList values = new ArrayList();
                AtomicInteger valueCounter = new AtomicInteger(0);
                fc.getValues().forEach(v -> {
                    String key = criterionKey + "_" + valueCounter.incrementAndGet();
                    values.add(":" + key);
                    argumentMappings.put(key, v);
                });
                query.append(values.stream().collect(Collectors.joining(",")));
                query.append("))");
                break;
            }
            case CONTAINS: {
                Collection valueCollection;
                Object object = fc.getValue();
                if (object instanceof Collection && !(valueCollection = (Collection)object).isEmpty()) {
                    String arrayType = JdbiRepositoryImpl.getArrayTypeAndFillArgumentMappings(argumentMappings, criterionKey, valueCollection);
                    query.append("(").append(expression).append(" @> ").append(":").append(criterionKey).append("::").append(arrayType).append(")");
                    break;
                }
                query.append("(").append(expression).append(" ILIKE '%' || ").append(":").append(criterionKey).append(" || '%')");
                argumentMappings.put(criterionKey, fc.getValue());
                break;
            }
            case STARTS_WITH: {
                query.append("(").append(expression).append(" ILIKE ").append(":").append(criterionKey).append(" || '%')");
                argumentMappings.put(criterionKey, fc.getValue());
                break;
            }
            case EQUALS: {
                Collection valueCollection;
                Object arrayType = fc.getValue();
                if (arrayType instanceof Collection && !(valueCollection = (Collection)arrayType).isEmpty()) {
                    arrayType = JdbiRepositoryImpl.getArrayTypeAndFillArgumentMappings(argumentMappings, criterionKey, valueCollection);
                    query.append("(").append(expression).append(" = ").append(":").append(criterionKey).append("::").append((String)arrayType).append(")");
                    break;
                }
                query.append("(").append(expression).append(" = ").append(":").append(criterionKey).append(")");
                argumentMappings.put(criterionKey, fc.getValue());
                break;
            }
            case NOT_EQUALS: {
                query.append("(").append(expression).append(" != ").append(":").append(criterionKey).append(")");
                argumentMappings.put(criterionKey, fc.getValue());
                break;
            }
            case GREATER_THAN: {
                query.append("(").append(expression).append(" > ").append(":").append(criterionKey).append(")");
                argumentMappings.put(criterionKey, fc.getValue());
                break;
            }
            case GREATER_THAN_OR_NOT_SET: {
                query.append("(").append(expression).append(" > ").append(":").append(criterionKey).append(" OR ").append(expression).append(" IS NULL").append(")");
                argumentMappings.put(criterionKey, fc.getValue());
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                query.append("(").append(expression).append(" >= ").append(":").append(criterionKey).append(")");
                argumentMappings.put(criterionKey, fc.getValue());
                break;
            }
            case LESS_THAN: {
                query.append("(").append(expression).append(" < ").append(":").append(criterionKey).append(")");
                argumentMappings.put(criterionKey, fc.getValue());
                break;
            }
            case LESS_THAN_AND_SET: {
                query.append("(").append(expression).append(" < ").append(":").append(criterionKey).append(" AND ").append(expression).append(" IS NOT NULL").append(")");
                argumentMappings.put(criterionKey, fc.getValue());
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                query.append("(").append(expression).append(" <= ").append(":").append(criterionKey).append(")");
                argumentMappings.put(criterionKey, fc.getValue());
                break;
            }
            case LESS_THAN_OR_EQUAL_TO_AND_SET: {
                query.append("(").append(expression).append(" <= ").append(":").append(criterionKey).append(" AND ").append(expression).append(" IS NOT NULL").append(")");
                argumentMappings.put(criterionKey, fc.getValue());
                break;
            }
            case LESS_THAN_OR_EQUAL_TO_OR_NOT_SET: {
                query.append("(").append(expression).append(" <= ").append(":").append(criterionKey).append(" OR ").append(expression).append(" IS NULL").append(")");
                argumentMappings.put(criterionKey, fc.getValue());
                break;
            }
            case SET: {
                query.append("(").append(expression).append(" IS NOT NULL").append(")");
                break;
            }
            case NOT_SET: {
                query.append("(").append(expression).append(" IS NULL").append(")");
                break;
            }
            default: {
                throw new UnsupportedOperationException(filterOperation + " not supported yet");
            }
        }
        return query.toString();
    }

    protected String getWhereClauses(Filtering filtering, Map<String, Object> argumentMappings) {
        if (filtering == null || filtering.isEmpty()) {
            return "";
        }
        ArrayList<String> criteriaClauses = new ArrayList<String>();
        AtomicInteger criterionCount = new AtomicInteger(argumentMappings.size() + 1);
        for (FilterCriteria filterCriteria : filtering.getFilterCriteriaList()) {
            if (filterCriteria.isEmpty()) continue;
            String logicalSqlOp = switch (filterCriteria.getCriterionLink()) {
                case FilterLogicalOperator.AND -> " AND ";
                case FilterLogicalOperator.OR -> " OR ";
                default -> " AND ";
            };
            String criterions = filterCriteria.stream().map(filterCriterion -> this.getWhereClause((FilterCriterion<?>)filterCriterion, argumentMappings, criterionCount.getAndIncrement())).filter(s -> StringUtils.hasText((String)s)).collect(Collectors.joining(logicalSqlOp, "(", ")"));
            criteriaClauses.add(criterions);
        }
        return criteriaClauses.stream().collect(Collectors.joining(" AND "));
    }

    protected boolean hasSplitColumn(String propertName) {
        return false;
    }

    protected void mapFilterExpressionsToOtherTableColumnNames(Filtering filtering, AbstractPagingSortingFilteringRepositoryImpl otherRepository) {
        if (filtering == null) {
            return;
        }
        filtering.getFilterCriteriaList().stream().flatMap(Collection::stream).forEach(fc -> {
            fc.setExpression(otherRepository.getColumnName(fc.getExpression()));
            fc.setNativeExpression(true);
        });
    }

    protected long retrieveCount(StringBuilder sqlCount, Map<String, Object> argumentMappings) throws RepositoryException {
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sqlCount.toString()).bindMap(argumentMappings)).mapTo(Long.class).findOne().get());
        return total;
    }

    protected Integer retrieveNextSortIndexForParentChildren(Jdbi dbi, String tableName, String columNameParentUuid, UUID parentUuid) throws RepositoryException {
        Integer sortIndex = (Integer)dbi.withHandle(h -> ((Query)h.createQuery("SELECT COALESCE(MAX(sortIndex), -1) + 1 FROM " + tableName + " WHERE " + columNameParentUuid + " = :parent_uuid").bind("parent_uuid", parentUuid)).mapTo(Integer.class).findOne().orElse(null));
        return sortIndex;
    }

    public String[] splitToArray(LocalizedText localizedText) {
        if (localizedText == null) {
            return new String[0];
        }
        List<String> splitLabels = localizedText.values().stream().map(text -> this.splitToArray((String)text)).flatMap(Arrays::stream).collect(Collectors.toList());
        return splitLabels.toArray(new String[splitLabels.size()]);
    }

    public String[] splitToArray(String term) {
        term = term.toLowerCase();
        term = term.replaceAll("(?iU)[^\\s\\w_-]|(?<=\\s)-(?=\\s)", "");
        Matcher hyphenWords = Pattern.compile("(?iU)\\b\\w+(-\\w+)+\\b").matcher(term);
        List result = hyphenWords.results().collect(ArrayList::new, (list, match) -> list.addAll(Arrays.asList(match.group().split("-+"))), ArrayList::addAll);
        for (String word : term.trim().split("\\s+")) {
            result.add(word);
        }
        return result.toArray(new String[result.size()]);
    }
}

