/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.ArticleRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Article;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.identifiable.entity.agent.Family;
import de.digitalcollections.model.identifiable.entity.agent.Person;
import de.digitalcollections.model.list.filtering.Filtering;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class ArticleRepositoryImpl
extends EntityRepositoryImpl<Article>
implements ArticleRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArticleRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "ar";
    public static final String TABLE_ALIAS = "a";
    public static final String TABLE_NAME = "articles";
    private final EntityRepositoryImpl<Entity> entityRepositoryImpl;

    public ArticleRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, @Qualifier(value="entityRepositoryImpl") EntityRepositoryImpl<Entity> entityRepositoryImpl, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, (Class<? extends Entity>)Article.class, cudamiConfig.getOffsetForAlternativePaging(), identifierRepository, urlAliasRepository);
        this.entityRepositoryImpl = entityRepositoryImpl;
    }

    public boolean addCreators(UUID articleUuid, List<Agent> agents) throws RepositoryException {
        if (articleUuid == null || agents == null) {
            return false;
        }
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "article_creators", "article_uuid", articleUuid);
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO article_creators(article_uuid, agent_uuid, sortIndex) VALUES (:uuid, :agentUuid, :sortIndex) ON CONFLICT (article_uuid, agent_uuid) DO NOTHING");
            agents.forEach(agent -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", articleUuid)).bind("agentUuid", agent.getUuid())).bind("sortIndex", nextSortIndex + this.getIndex(agents, (UniqueObject)agent))).add());
            preparedBatch.execute();
        });
        return true;
    }

    @Override
    public Article create() throws RepositoryException {
        return new Article();
    }

    public Article getByIdentifier(Identifier identifier) throws RepositoryException {
        Article article = (Article)super.getByIdentifier(identifier);
        if (article != null) {
            article.setCreators(this.getCreators(article.getUuid()));
        }
        return article;
    }

    @Override
    public Article getByRefId(long refId) throws RepositoryException {
        Article article = (Article)super.getByRefId(refId);
        if (article != null) {
            article.setCreators(this.getCreators(article.getUuid()));
        }
        return article;
    }

    @Override
    public Article getByUuidAndFiltering(UUID uuid, Filtering filtering) throws RepositoryException {
        Article article = (Article)super.getByUuidAndFiltering(uuid, filtering);
        if (article != null) {
            List<Agent> creators = this.getCreators(uuid);
            article.setCreators(creators);
        }
        return article;
    }

    public List<Agent> getCreators(UUID articleUuid) throws RepositoryException {
        StringBuilder innerQuery = new StringBuilder("SELECT ac.sortindex AS idx, * FROM entities AS e LEFT JOIN article_creators AS ac ON e.uuid = ac.agent_uuid WHERE ac.article_uuid = :uuid ORDER BY ac.sortindex ASC");
        String fieldsSql = this.entityRepositoryImpl.getSqlSelectReducedFields();
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", articleUuid);
        List entityList = this.entityRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC");
        List agents = null;
        if (entityList != null) {
            agents = entityList.stream().map(entity -> {
                IdentifiableObjectType type = entity.getIdentifiableObjectType();
                switch (type) {
                    case CORPORATE_BODY: {
                        CorporateBody corporateBody = new CorporateBody();
                        corporateBody.setLabel(entity.getLabel());
                        corporateBody.setRefId(entity.getRefId());
                        corporateBody.setUuid(entity.getUuid());
                        return corporateBody;
                    }
                    case FAMILY: {
                        Family family = new Family();
                        family.setLabel(entity.getLabel());
                        family.setRefId(entity.getRefId());
                        family.setUuid(entity.getUuid());
                        return family;
                    }
                    case PERSON: {
                        Person person = new Person();
                        person.setLabel(entity.getLabel());
                        person.setRefId(entity.getRefId());
                        person.setUuid(entity.getUuid());
                        return person;
                    }
                }
                return null;
            }).collect(Collectors.toList());
        }
        return agents;
    }

    @Override
    public String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", date_published, text, timevalue_published";
    }

    @Override
    public String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :datePublished, :text::JSONB, :timeValuePublished::JSONB";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectAllFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".text " + mappingPrefix + "_text";
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".date_published " + mappingPrefix + "_datePublished, " + tableAlias + ".timevalue_published " + mappingPrefix + "_timeValuePublished";
    }

    @Override
    public String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", date_published=:datePublished, text=:text::JSONB, timevalue_published=:timeValuePublished::JSONB";
    }

    public boolean removeCreator(UUID articleUuid, UUID agentUuid) throws RepositoryException {
        if (articleUuid != null && agentUuid != null) {
            String sql = "DELETE FROM article_creators WHERE article_uuid=:articleUuid AND agent_uuid=:agentUuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM article_creators WHERE article_uuid=:articleUuid AND agent_uuid=:agentUuid").bind("articleUuid", articleUuid)).bind("agentUuid", agentUuid)).execute());
            return true;
        }
        return false;
    }

    public void save(Article article) throws RepositoryException {
        super.save((UniqueObject)article);
        List creators = article.getCreators();
        this.setCreatorsList(article, creators);
    }

    private void setCreatorsList(Article article, List<Agent> creators) {
        UUID articleUuid = article.getUuid();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM article_creators WHERE article_uuid = :uuid").bind("uuid", articleUuid)).execute());
        if (creators != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO article_creators(article_uuid, agent_uuid, sortIndex) VALUES(:uuid, :agentUuid, :sortIndex)");
                for (Agent agent : creators) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", articleUuid)).bind("agentUuid", agent.getUuid())).bind("sortIndex", this.getIndex(creators, (UniqueObject)agent))).add();
                }
                preparedBatch.execute();
            });
        }
    }

    public void update(Article article) throws RepositoryException {
        super.update((UniqueObject)article);
        List creators = article.getCreators();
        this.setCreatorsList(article, creators);
    }
}

