/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.web;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.web.WebpageRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import de.digitalcollections.model.view.BreadcrumbNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

@Repository
public class WebpageRepositoryImpl
extends IdentifiableRepositoryImpl<Webpage>
implements WebpageRepository {
    public static final String MAPPING_PREFIX = "webp";
    public static final String TABLE_ALIAS = "webp";
    public static final String TABLE_NAME = "webpages";

    public WebpageRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository) {
        super(dbi, TABLE_NAME, "webp", "webp", Webpage.class, cudamiConfig.getOffsetForAlternativePaging(), identifierRepository, urlAliasRepository);
    }

    public boolean addChildren(UUID parentUuid, List<UUID> childrenUuids) throws RepositoryException {
        if (parentUuid == null || childrenUuids == null) {
            return false;
        }
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "webpage_webpages", "parent_webpage_uuid", parentUuid);
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO webpage_webpages(parent_webpage_uuid, child_webpage_uuid, sortIndex) VALUES (:parentWebpageUuid, :childWebpageUuid, :sortIndex) ON CONFLICT (parent_webpage_uuid, child_webpage_uuid) DO NOTHING");
            childrenUuids.forEach(childUuid -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("parentWebpageUuid", parentUuid)).bind("childWebpageUuid", childUuid)).bind("sortIndex", nextSortIndex + this.getIndex(childrenUuids, (UUID)childUuid))).add());
            preparedBatch.execute();
        });
        return true;
    }

    @Override
    public Webpage create() throws RepositoryException {
        return new Webpage();
    }

    public PageResponse<Webpage> findChildren(UUID uuid, PageRequest pageRequest) throws RepositoryException {
        String crossTableAlias = "xtable";
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN webpage_webpages AS xtable ON " + this.tableAlias + ".uuid = xtable.child_webpage_uuid WHERE xtable.parent_webpage_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", uuid);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.addCrossTablePagingAndSorting(pageRequest, innerQuery, "xtable");
        List result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(" + this.tableAlias + ".uuid)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    public PageResponse<Webpage> findRootNodes(PageRequest pageRequest) throws RepositoryException {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE NOT EXISTS (SELECT FROM webpage_webpages WHERE child_webpage_uuid = " + this.tableAlias + ".uuid)";
        return this.find(pageRequest, commonSql);
    }

    public PageResponse<Webpage> findRootWebpagesForWebsite(UUID uuid, PageRequest pageRequest) throws RepositoryException {
        String crossTableAlias = "xtable";
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias + " LEFT JOIN website_webpages AS xtable ON " + this.tableAlias + ".uuid = xtable.webpage_uuid WHERE xtable.website_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", uuid);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.addCrossTablePagingAndSorting(pageRequest, innerQuery, "xtable");
        List result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("publicationEnd", "publicationStart"));
        return allowedOrderByFields;
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID uuid) {
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("WITH RECURSIVE breadcrumb (targetId, label, parentId, depth) AS (        SELECT w.uuid AS targetId, w.label AS label, ww.parent_webpage_uuid AS parentId, 99 AS depth        FROM webpages w, webpage_webpages ww        WHERE uuid=:uuid and ww.child_webpage_uuid = w.uuid        UNION ALL        SELECT w.uuid AS targetId, w.label AS label, ww.parent_webpage_uuid AS parentId, depth-1 AS depth        FROM webpages w, webpage_webpages ww, breadcrumb b        WHERE b.targetId = ww.child_webpage_uuid AND ww.parent_webpage_uuid = w.uuid AND ww.parent_webpage_uuid IS NOT NULL    ) SELECT cast(targetId AS VARCHAR) AS targetId, label, parentId, depth FROM breadcrumb UNION SELECT NULL AS targetId, ws.label AS label, NULL AS parentId, 0 AS depth FROM websites ws, website_webpages ww, breadcrumb b WHERE ww.webpage_uuid = b.parentId AND ws.uuid = ww.website_uuid ORDER BY depth ASC").bind("uuid", uuid)).mapTo(BreadcrumbNode.class).list());
        if (result.isEmpty()) {
            result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT cast(w.uuid AS VARCHAR) as targetId, w.label as label        FROM webpages w        WHERE uuid= :uuid").bind("uuid", uuid)).mapTo(BreadcrumbNode.class).list());
        }
        return new BreadcrumbNavigation(result);
    }

    public Webpage getByIdentifier(Identifier identifier) throws RepositoryException {
        Webpage webpage = (Webpage)super.getByIdentifier(identifier);
        if (webpage != null) {
            webpage.setChildren(this.getChildren((Identifiable)webpage));
        }
        return webpage;
    }

    @Override
    public Webpage getByUuidAndFiltering(UUID uuid, Filtering filtering) throws RepositoryException {
        Webpage webpage = (Webpage)super.getByUuidAndFiltering(uuid, filtering);
        if (webpage != null) {
            webpage.setChildren(this.getChildren((Identifiable)webpage));
        }
        return webpage;
    }

    public List<Webpage> getChildren(UUID uuid) throws RepositoryException {
        StringBuilder innerQuery = new StringBuilder("SELECT ww.sortindex AS idx, * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN webpage_webpages ww ON " + this.tableAlias + ".uuid = ww.child_webpage_uuid WHERE ww.parent_webpage_uuid = :uuid ORDER BY idx ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", uuid);
        List<Webpage> result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, "ORDER BY idx ASC");
        return result;
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "publicationEnd": {
                return this.tableAlias + ".publication_end";
            }
            case "publicationStart": {
                return this.tableAlias + ".publication_start";
            }
        }
        return super.getColumnName(modelProperty);
    }

    public Webpage getParent(UUID uuid) throws RepositoryException {
        String sqlAdditionalJoins = " INNER JOIN webpage_webpages ww ON " + this.tableAlias + ".uuid = ww.parent_webpage_uuid";
        Filtering filtering = Filtering.builder().add(FilterCriterion.nativeBuilder().withExpression("ww.child_webpage_uuid").isEquals((Object)uuid).build()).build();
        Webpage result = (Webpage)this.retrieveOne(this.getSqlSelectReducedFields(), filtering, sqlAdditionalJoins);
        return result;
    }

    public List<Webpage> getParents(UUID uuid) throws RepositoryException {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN webpage_webpages ww ON " + this.tableAlias + ".uuid = ww.parent_webpage_uuid WHERE ww.child_webpage_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        List<Webpage> result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, null);
        return result;
    }

    public List<Locale> getRootNodesLanguages() {
        String query = "SELECT DISTINCT jsonb_object_keys(" + this.tableAlias + ".label) AS languages FROM " + this.tableName + " AS " + this.tableAlias + " WHERE NOT EXISTS (SELECT FROM webpage_webpages WHERE child_webpage_uuid = " + this.tableAlias + ".uuid)";
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", publication_end, publication_start, rendering_hints, text";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :publicationEnd, :publicationStart, :renderingHints::JSONB, :text::JSONB";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectAllFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".text " + mappingPrefix + "_text";
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".publication_end " + mappingPrefix + "_publicationEnd, " + tableAlias + ".publication_start " + mappingPrefix + "_publicationStart, " + tableAlias + ".rendering_hints " + mappingPrefix + "_renderingHints";
    }

    @Override
    protected String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", publication_end=:publicationEnd, publication_start=:publicationStart, rendering_hints=:renderingHints::JSONB, text=:text::JSONB";
    }

    public Website getWebsite(UUID rootWebpageUuid) {
        String query = "SELECT uuid, refid, label, url FROM websites INNER JOIN website_webpages ww ON uuid = ww.website_uuid WHERE ww.webpage_uuid = :uuid";
        Website result = (Website)this.dbi.withHandle(h -> (Website)((Query)h.createQuery(query).bind("uuid", rootWebpageUuid)).mapToBean(Website.class).one());
        return result;
    }

    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        if (parentUuid == null || childUuid == null) {
            return false;
        }
        String sql = "DELETE FROM webpage_webpages WHERE parent_webpage_uuid=:parentWebpageUuid AND child_webpage_uuid=:childWebpageUuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM webpage_webpages WHERE parent_webpage_uuid=:parentWebpageUuid AND child_webpage_uuid=:childWebpageUuid").bind("parentWebpageUuid", parentUuid)).bind("childWebpageUuid", childUuid)).execute());
        return true;
    }

    public Webpage saveParentRelation(UUID childWebpageUuid, UUID parentWebpageUuid) throws RepositoryException {
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "webpage_webpages", "parent_webpage_uuid", parentWebpageUuid);
        String query = "INSERT INTO webpage_webpages(parent_webpage_uuid, child_webpage_uuid, sortIndex) VALUES (:parent_webpage_uuid, :child_webpage_uuid, :sortIndex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("parent_webpage_uuid", parentWebpageUuid)).bind("child_webpage_uuid", childWebpageUuid)).bind("sortIndex", nextSortIndex)).execute());
        return (Webpage)this.getByUuid(childWebpageUuid);
    }

    public Webpage saveWithParentWebsite(UUID webpageUuid, UUID parentWebsiteUuid) throws RepositoryException {
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "website_webpages", "website_uuid", parentWebsiteUuid);
        String query = "INSERT INTO website_webpages(website_uuid, webpage_uuid, sortIndex) VALUES (:parent_website_uuid, :webpage_uuid, :sortIndex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("parent_website_uuid", parentWebsiteUuid)).bind("webpage_uuid", webpageUuid)).bind("sortIndex", nextSortIndex)).execute());
        return (Webpage)this.getByUuid(webpageUuid);
    }

    public boolean updateChildrenOrder(UUID parentUuid, List<UUID> children) {
        if (parentUuid == null || children == null) {
            throw new IllegalArgumentException("update failed: given objects must not be null");
        }
        String query = "UPDATE webpage_webpages SET sortindex = :idx WHERE child_webpage_uuid = :childUuid AND parent_webpage_uuid = :parentUuid;";
        this.dbi.withHandle(h -> {
            PreparedBatch batch = h.prepareBatch(query);
            int idx = 0;
            for (UUID uuidChild : children) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("idx", idx++)).bind("childUuid", uuidChild)).bind("parentUuid", parentUuid)).add();
            }
            return batch.execute();
        });
        return true;
    }
}

