/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.work.WorkRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.AgentRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.PersonRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.geo.location.HumanSettlementRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.relation.EntityToEntityRelationRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.ItemRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.ManifestationRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.TitleSqlHelper;
import de.digitalcollections.cudami.server.backend.impl.jdbi.type.LocalDateRangeMapper;
import de.digitalcollections.cudami.server.backend.impl.jdbi.type.TitleMapper;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.relation.EntityRelation;
import de.digitalcollections.model.identifiable.entity.work.Work;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import de.digitalcollections.model.text.LocalizedText;
import de.digitalcollections.model.text.Title;
import de.digitalcollections.model.time.LocalDateRange;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="workRepository")
public class WorkRepositoryImpl
extends EntityRepositoryImpl<Work>
implements WorkRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "wo";
    public static final String TABLE_ALIAS = "w";
    public static final String TABLE_NAME = "works";
    private AgentRepositoryImpl<Agent> agentRepository;
    private EntityToEntityRelationRepositoryImpl entityRelationRepository;
    private EntityRepositoryImpl<Entity> entityRepository;
    private HumanSettlementRepositoryImpl humanSettlementRepository;
    private ItemRepositoryImpl itemRepository;
    private ManifestationRepositoryImpl manifestationRepository;
    private PersonRepositoryImpl personRepository;

    public WorkRepositoryImpl(Jdbi jdbi, CudamiConfig cudamiConfig, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository, LocalDateRangeMapper dateRangeMapper, TitleMapper titleMapper, EntityRepositoryImpl<Entity> entityRepository, AgentRepositoryImpl<Agent> agentRepository, HumanSettlementRepositoryImpl humanSettlementRepository, ManifestationRepositoryImpl manifestationRepository, ItemRepositoryImpl itemRepository, PersonRepositoryImpl personRepository, EntityToEntityRelationRepositoryImpl entityRelationRepository) {
        super(jdbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, (Class<? extends Entity>)Work.class, cudamiConfig.getOffsetForAlternativePaging(), identifierRepository, urlAliasRepository);
        this.dbi.registerArgument((ArgumentFactory)dateRangeMapper);
        this.dbi.registerColumnMapper(LocalDateRange.class, (ColumnMapper)dateRangeMapper);
        this.dbi.registerColumnMapper(Title.class, (ColumnMapper)titleMapper);
        this.entityRepository = entityRepository;
        this.agentRepository = agentRepository;
        this.humanSettlementRepository = humanSettlementRepository;
        this.manifestationRepository = manifestationRepository;
        this.itemRepository = itemRepository;
        this.personRepository = personRepository;
        this.entityRelationRepository = entityRelationRepository;
    }

    @Override
    public Work create() throws RepositoryException {
        return new Work();
    }

    @Override
    protected void basicReduceRowsBiConsumer(Map<UUID, Work> map, RowView rowView) {
        UUID entityUuid;
        super.basicReduceRowsBiConsumer(map, rowView);
        Work work = map.get(rowView.getColumn(this.mappingPrefix + "_uuid", UUID.class));
        UUID parentUuid = (UUID)rowView.getColumn("parent_uuid", UUID.class);
        if (parentUuid != null) {
            if (work.getParents() == null) {
                work.setParents(new ArrayList(1));
            }
            if (!work.getParents().stream().anyMatch(relSpec -> Objects.equals(relSpec.getUuid(), parentUuid))) {
                Work parent = ((Work.WorkBuilder)((Work.WorkBuilder)((Work.WorkBuilder)((Work.WorkBuilder)((Work.WorkBuilder)((Work.WorkBuilder)((Work.WorkBuilder)((Work.WorkBuilder)Work.builder().uuid(parentUuid)).label((LocalizedText)rowView.getColumn("parent_label", LocalizedText.class))).titles((List)rowView.getColumn("parent_titles", (GenericType)new GenericType<List<Title>>(){})).refId((long)((Integer)rowView.getColumn("parent_refId", Integer.class)).intValue())).notes((List)rowView.getColumn("parent_notes", (GenericType)new GenericType<List<LocalizedStructuredContent>>(){}))).created((LocalDateTime)rowView.getColumn("parent_created", LocalDateTime.class))).lastModified((LocalDateTime)rowView.getColumn("parent_lastModified", LocalDateTime.class))).identifiableObjectType((IdentifiableObjectType)rowView.getColumn("parent_identifiableObjectType", IdentifiableObjectType.class))).identifiers((Set)rowView.getColumn("parent_identifiers", (GenericType)new GenericType<Set<Identifier>>(){}))).build();
                work.getParents().add(parent);
            }
        }
        if ((entityUuid = (UUID)rowView.getColumn(this.entityRepository.getMappingPrefix() + "_uuid", UUID.class)) != null) {
            if (work.getRelations() == null || work.getRelations().isEmpty()) {
                int maxIndex = (Integer)rowView.getColumn("relation_max_sortindex", Integer.class);
                Vector relations = new Vector(++maxIndex);
                relations.setSize(maxIndex);
                work.setRelations(relations);
            }
            String relationPredicate = (String)rowView.getColumn("rel_predicate", String.class);
            if (!work.getRelations().stream().anyMatch(relation -> relation != null && Objects.equals(entityUuid, relation.getSubject().getUuid()) && Objects.equals(relationPredicate, relation.getPredicate()))) {
                Entity relatedEntity = (Entity)rowView.getRow(Entity.class);
                work.getRelations().set((Integer)rowView.getColumn("rel_sortindex", Integer.class), EntityRelation.builder().subject(relatedEntity).predicate(relationPredicate).additionalPredicates((List)rowView.getColumn("rel_additionalPredicates", (GenericType)new GenericType<List<String>>(){})).build());
            }
        }
    }

    public PageResponse<Work> findByPerson(UUID personUuid) {
        throw new UnsupportedOperationException();
    }

    public PageResponse<Work> findEmbeddedWorks(UUID uuid, PageRequest pageRequest) throws RepositoryException {
        String workWorksTableName = "work_works";
        String workWorksTableAlias = "wws";
        StringBuilder commonSql = new StringBuilder(" FROM work_works AS wws INNER JOIN " + this.tableName + " " + this.tableAlias + " ON wws.object_uuid = " + this.tableAlias + ".uuid WHERE wws.subject_uuid = :subject_uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("subject_uuid", uuid);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT " + this.tableAlias + ".* " + commonSql);
        this.addPagingAndSorting(pageRequest, innerQuery);
        List result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, this.getOrderBy(pageRequest.getSorting()));
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> orderByFields = super.getAllowedOrderByFields();
        return orderByFields;
    }

    public Work getByItem(UUID itemUuid) throws RepositoryException {
        String innerSelect = " (SELECT w.* FROM " + this.getTableName() + " " + this.getTableAlias() + ", " + this.manifestationRepository.getTableName() + " " + this.manifestationRepository.getTableAlias() + ", " + this.itemRepository.getTableName() + " " + this.itemRepository.getTableAlias() + " WHERE " + this.itemRepository.getTableAlias() + ".uuid = :item_uuid AND " + this.itemRepository.getTableAlias() + ".manifestation=" + this.manifestationRepository.getTableAlias() + ".uuid AND " + this.manifestationRepository.getTableAlias() + ".work=" + this.getTableAlias() + ".uuid)";
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("item_uuid", itemUuid);
        return (Work)this.retrieveOne(this.getSqlSelectAllFields(), null, null, argumentMappings, innerSelect);
    }

    public Set<Work> getByPerson(UUID personUuid) throws RepositoryException {
        StringBuilder innerSelect = new StringBuilder(" SELECT " + this.getTableAlias() + ".* FROM " + this.getTableName() + " " + this.getTableAlias() + ", " + this.personRepository.getTableName() + " " + this.personRepository.getTableAlias() + ", " + this.entityRelationRepository.getTableName() + " " + this.entityRelationRepository.getTableAlias() + " WHERE " + this.personRepository.getTableAlias() + ".uuid = :person_uuid AND " + this.entityRelationRepository.getTableAlias() + ".subject_uuid=" + this.personRepository.getTableAlias() + ".uuid AND " + this.entityRelationRepository.getTableAlias() + ".object_uuid=" + this.getTableAlias() + ".uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("person_uuid", personUuid);
        return new HashSet<Work>(this.retrieveList(this.getSqlSelectReducedFields(), innerSelect, argumentMappings, null));
    }

    @Override
    public String getColumnName(String modelProperty) {
        switch (modelProperty) {
            case "titles": {
                return modelProperty;
            }
        }
        return super.getColumnName(modelProperty);
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", creation_daterange, creation_timevalue, first_appeared_date, first_appeared_presentation, first_appeared_timevalue, titles";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :creationDateRange::daterange, :creationTimeValue::JSONB, :firstAppearedDate, :firstAppearedDatePresentation, :firstAppearedTimeValue::JSONB, {{titles}}";
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", %1$s.creation_daterange %2$s_creationDateRange\n, %1$s.creation_timevalue %2$s_creationTimeValue\n, %1$s.first_appeared_date %2$s_firstAppearedDate\n, %1$s.first_appeared_presentation %2$s_firstAppearedDatePresentation\n, %1$s.first_appeared_timevalue %2$s_firstAppearedTimeValue\n, %1$s.titles %2$s_titles,\n".formatted(tableAlias, mappingPrefix) + "parent.uuid parent_uuid, parent.label parent_label, parent.titles parent_titles,\nparent.refid parent_refId, parent.notes parent_notes, parent.created parent_created, parent.last_modified parent_lastModified,\nparent.identifiable_objecttype parent_identifiableObjectType, get_identifiers(parent.uuid) parent_identifiers,\n" + "{{entityRelationAlias}}.predicate {{entityRelationMap}}_predicate, {{entityRelationAlias}}.sortindex {{entityRelationMap}}_sortindex,\n{{entityRelationAlias}}.additional_predicates {{entityRelationMap}}_additionalPredicates,\nmax({{entityRelationAlias}}.sortindex) OVER (PARTITION BY {{tableAlias}}.uuid) relation_max_sortindex,\nget_identifiers({{entityAlias}}.uuid) {{entityMapping}}_identifiers,\n".replace("{{tableAlias}}", tableAlias).replace("{{entityRelationAlias}}", "rel").replace("{{entityRelationMap}}", "rel").replace("{{entityAlias}}", this.entityRepository.getTableAlias()).replace("{{entityMapping}}", this.entityRepository.getMappingPrefix()) + this.entityRepository.getSqlSelectReducedFields();
    }

    @Override
    protected String getSqlSelectReducedFieldsJoins() {
        return super.getSqlSelectReducedFieldsJoins() + "LEFT JOIN (\n  work_works wws INNER JOIN works parent\n  ON parent.uuid = wws.subject_uuid\n) ON wws.object_uuid = %1$s.uuid\nLEFT JOIN (\n  %2$s %3$s INNER JOIN %4$s %5$s ON %3$s.subject_uuid = %5$s.uuid\n) ON %3$s.object_uuid = %1$s.uuid\n".formatted(this.tableAlias, "rel_entity_entities", "rel", "entities", "e");
    }

    @Override
    protected String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", creation_daterange=:creationDateRange::daterange, creation_timevalue=:creationTimeValue::JSONB, first_appeared_date=:firstAppearedDate, first_appeared_presentation=:firstAppearedDatePresentation, first_appeared_timevalue=:firstAppearedTimeValue::JSONB, titles={{titles}}";
    }

    @Override
    public void save(Work work, Map<String, Object> bindings) throws RepositoryException {
        if (bindings == null) {
            bindings = new HashMap<String, Object>(3);
        }
        super.save(work, bindings, TitleSqlHelper.buildTitleSql(work.getTitles()));
        this.saveParents(work);
    }

    private void saveParents(Work work) {
        if (work == null) {
            return;
        }
        this.dbi.useHandle(h -> ((Update)h.createUpdate("DELETE FROM work_works WHERE object_uuid = :uuid").bind("uuid", work.getUuid())).execute());
        if (work.getParents() == null || work.getParents().isEmpty()) {
            return;
        }
        this.dbi.useHandle(h -> {
            PreparedBatch batch = h.prepareBatch("INSERT INTO work_works (\n  subject_uuid, object_uuid\n) VALUES (\n  :subject, :object\n)");
            for (Work parent : work.getParents()) {
                if (parent.getUuid() == null) continue;
                ((PreparedBatch)((PreparedBatch)batch.bind("object", work.getUuid())).bind("subject", parent.getUuid())).add();
            }
            batch.execute();
        });
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        switch (modelProperty) {
            case "firstAppearedDatePresentation": {
                return true;
            }
        }
        return super.supportsCaseSensitivityForProperty(modelProperty);
    }

    @Override
    public void update(Work work, Map<String, Object> bindings) throws RepositoryException {
        if (bindings == null) {
            bindings = new HashMap<String, Object>(3);
        }
        super.update(work, bindings, TitleSqlHelper.buildTitleSql(work.getTitles()));
        this.saveParents(work);
    }
}

