/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.DigitalObjectRenderingFileResourceRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.FileResourceMetadataRepositoryImpl;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.FileResourceType;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

@Repository
public class DigitalObjectRenderingFileResourceRepositoryImpl
extends JdbiRepositoryImpl
implements DigitalObjectRenderingFileResourceRepository {
    public static final String MAPPING_PREFIX = "dorr";
    public static final String TABLE_ALIAS = "do_rr";
    public static final String TABLE_NAME = "digitalobject_renderingresources";
    private final FileResourceMetadataRepositoryImpl<FileResource> fileResourceMetadataRepositoryImpl;

    public DigitalObjectRenderingFileResourceRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, FileResourceMetadataRepositoryImpl<FileResource> fileResourceMetadataRepositoryImpl) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, cudamiConfig.getOffsetForAlternativePaging());
        this.fileResourceMetadataRepositoryImpl = fileResourceMetadataRepositoryImpl;
    }

    public int countDigitalObjectsForResource(UUID uuid) {
        return (Integer)this.dbi.withHandle(h -> (Integer)((Query)h.createQuery("SELECT count(*) FROM " + this.tableName + " WHERE fileresource_uuid = :uuid").bind("uuid", uuid)).mapTo(Integer.class).findOne().get());
    }

    public int delete(List<UUID> uuids) {
        return (Integer)this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE fileresource_uuid in (<uuids>)").bindList("uuids", (Iterable)uuids)).execute());
    }

    public static FileResource fillResourceType(FileResource untypedFileResource) {
        switch (untypedFileResource.getMimeType().getPrimaryType()) {
            case "application": {
                untypedFileResource.setFileResourceType(FileResourceType.APPLICATION);
                break;
            }
            case "audio": {
                untypedFileResource.setFileResourceType(FileResourceType.AUDIO);
                break;
            }
            case "image": {
                untypedFileResource.setFileResourceType(FileResourceType.IMAGE);
                break;
            }
            case "text": {
                untypedFileResource.setFileResourceType(FileResourceType.TEXT);
                break;
            }
            case "video": {
                untypedFileResource.setFileResourceType(FileResourceType.VIDEO);
                break;
            }
        }
        return untypedFileResource;
    }

    public PageResponse<FileResource> findRenderingFileResources(UUID digitalObjectUuid, PageRequest pageRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("digitalobject_uuid", "fileresource_uuid", "sortIndex"));
    }

    @Override
    public String getColumnName(String modelProperty) {
        return null;
    }

    public List<FileResource> getRenderingFileResources(UUID digitalObjectUuid) throws RepositoryException {
        String fieldsSql = this.fileResourceMetadataRepositoryImpl.getSqlSelectAllFields();
        StringBuilder innerQuery = new StringBuilder("SELECT " + this.getTableAlias() + ".sortindex as idx, * FROM fileresources AS f INNER JOIN " + this.getTableName() + " AS " + this.getTableAlias() + " ON f.uuid = " + this.getTableAlias() + ".fileresource_uuid WHERE " + this.getTableAlias() + ".digitalobject_uuid = :uuid ORDER by " + this.getTableAlias() + ".sortindex ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", digitalObjectUuid);
        return this.fileResourceMetadataRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC").stream().map(DigitalObjectRenderingFileResourceRepositoryImpl::fillResourceType).collect(Collectors.toList());
    }

    @Override
    protected String getUniqueField() {
        return null;
    }

    public int removeByDigitalObject(UUID digitalObjectUuid) {
        return (Integer)this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.getTableName() + " WHERE digitalobject_uuid = :uuid").bind("uuid", digitalObjectUuid)).execute());
    }

    public void setRenderingFileResources(UUID digitalObjectUuid, List<FileResource> renderingResources) throws RepositoryException {
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO " + this.getTableName() + "(digitalobject_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
            for (FileResource renderingResource : renderingResources) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", digitalObjectUuid)).bind("fileResourceUuid", renderingResource.getUuid())).bind("sortIndex", this.fileResourceMetadataRepositoryImpl.getIndex(renderingResources, (UniqueObject)renderingResource))).add();
            }
            preparedBatch.execute();
        });
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        return false;
    }
}

