/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.type;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.server.backend.impl.jdbi.type.MainSubTypeMapper;
import de.digitalcollections.model.text.LocalizedText;
import de.digitalcollections.model.text.Title;
import de.digitalcollections.model.text.TitleType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.springframework.util.StringUtils;

public class TitleMapper
implements ColumnMapper<Title> {
    private ObjectMapper objectMapper;
    private MainSubTypeMapper.TitleTypeMapper titleTypeMapper;

    public TitleMapper(ObjectMapper objectMapper, MainSubTypeMapper.TitleTypeMapper titleTypeMapper) {
        this.objectMapper = objectMapper;
        this.titleTypeMapper = titleTypeMapper;
    }

    public Title map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        String value = r.getString(columnNumber);
        if (value == null) {
            return null;
        }
        Matcher valueParts = Pattern.compile("^[(]\\p{Punct}*?(?<titletype>[(].+?[)])\\p{Punct}*?,\\p{Punct}*?(?<text>[{].+?[}])\\p{Punct}*?,(\\p{Punct}*?(?<orig>[{][\\w,_-]*[}])\\p{Punct}*?)?[)]$", 256).matcher(value);
        if (!valueParts.find()) {
            return null;
        }
        TitleType titleType = (TitleType)this.titleTypeMapper.createTypeFromString(valueParts.group("titletype"));
        LocalizedText titleText = null;
        try {
            titleText = (LocalizedText)this.objectMapper.readValue(valueParts.group("text").replaceAll("([\\\\\"]){2}", "$1"), LocalizedText.class);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        Set<Object> localesOfOriginalScripts = null;
        if (valueParts.group("orig") != null) {
            String origs = valueParts.group("orig").replaceFirst("^\\{", "").replaceFirst("\\}$", "");
            localesOfOriginalScripts = StringUtils.hasText((String)origs) ? Stream.of(origs.split(",")).map(s -> Locale.forLanguageTag(s)).collect(Collectors.toSet()) : new HashSet();
        }
        return new Title(titleText, localesOfOriginalScripts, titleType);
    }
}

