/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.DigitalObjectRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.CollectionRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.ProjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.AgentRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.CorporateBodyRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.PersonRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.geo.location.GeoLocationRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.geo.location.HumanSettlementRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.DigitalObjectRenderingFileResourceRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.FileResourceMetadataRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.ImageFileResourceRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.LinkedDataFileResourceRepositoryImpl;
import de.digitalcollections.cudami.server.config.BackendIiifServerConfig;
import de.digitalcollections.iiif.model.ImageContent;
import de.digitalcollections.iiif.model.MimeType;
import de.digitalcollections.iiif.model.Service;
import de.digitalcollections.iiif.model.jackson.IiifObjectMapper;
import de.digitalcollections.iiif.model.openannotation.Annotation;
import de.digitalcollections.iiif.model.sharedcanvas.Canvas;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.CustomAttributes;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.identifiable.entity.agent.Person;
import de.digitalcollections.model.identifiable.entity.digitalobject.CreationInfo;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.identifiable.entity.geo.location.GeoLocation;
import de.digitalcollections.model.identifiable.entity.geo.location.HumanSettlement;
import de.digitalcollections.model.identifiable.entity.item.Item;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.identifiable.resource.LinkedDataFileResource;
import de.digitalcollections.model.legal.License;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import de.digitalcollections.model.text.LocalizedText;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.function.BiConsumer;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class DigitalObjectRepositoryImpl
extends EntityRepositoryImpl<DigitalObject>
implements DigitalObjectRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalObjectRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "do";
    public static final String TABLE_ALIAS = "d";
    public static final String TABLE_NAME = "digitalobjects";
    @Lazy
    @Autowired
    private AgentRepositoryImpl<Agent> agentRepositoryImpl;
    @Lazy
    @Autowired
    private CollectionRepositoryImpl collectionRepositoryImpl;
    @Lazy
    @Autowired
    private CorporateBodyRepositoryImpl corporateBodyRepositoryImpl;
    @Lazy
    @Autowired
    private FileResourceMetadataRepositoryImpl<FileResource> fileResourceMetadataRepositoryImpl;
    @Lazy
    @Autowired
    private GeoLocationRepositoryImpl<GeoLocation> geoLocationRepositoryImpl;
    @Lazy
    @Autowired
    private HumanSettlementRepositoryImpl humanSettlementRepositoryImpl;
    @Lazy
    @Autowired
    private ImageFileResourceRepositoryImpl imageFileResourceRepositoryImpl;
    @Lazy
    @Autowired
    private LinkedDataFileResourceRepositoryImpl linkedDataFileResourceRepositoryImpl;
    @Lazy
    @Autowired
    private PersonRepositoryImpl personRepositoryImpl;
    @Lazy
    @Autowired
    private ProjectRepositoryImpl projectRepositoryImpl;
    private final IiifObjectMapper iiifObjectMapper;
    private final BackendIiifServerConfig iiifServerConfig;

    public DigitalObjectRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, BackendIiifServerConfig iiifServerConfig, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository, IiifObjectMapper iiifObjectMapper) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, (Class<? extends Entity>)DigitalObject.class, cudamiConfig.getOffsetForAlternativePaging(), identifierRepository, urlAliasRepository);
        this.iiifObjectMapper = iiifObjectMapper;
        this.iiifServerConfig = iiifServerConfig;
    }

    private ImageFileResource convertToImageFileResource(Canvas canvas) throws MalformedURLException {
        if (canvas.getImages() == null) {
            return null;
        }
        ImageContent imageContent = (ImageContent)((Annotation)canvas.getImages().get(0)).getResource();
        MimeType mimeType = imageContent.getFormat();
        URL httpBaseUrl = ((Service)imageContent.getServices().get(0)).getIdentifier().toURL();
        ImageFileResource ifr = new ImageFileResource();
        ifr.setHttpBaseUrl(httpBaseUrl);
        ifr.setMimeType(de.digitalcollections.model.file.MimeType.fromTypename((String)mimeType.getTypeName()));
        return ifr;
    }

    @Override
    public DigitalObject create() throws RepositoryException {
        return new DigitalObject();
    }

    @Override
    protected void fullReduceRowsBiConsumer(Map<UUID, DigitalObject> map, RowView rowView) {
        UUID renderingResourceUuid;
        UUID linkedDataFileResUuid;
        UUID parentUuid;
        Integer numberOfBinaryResources;
        super.fullReduceRowsBiConsumer(map, rowView);
        DigitalObject digitalObject = map.get(rowView.getColumn("do_uuid", UUID.class));
        BiConsumer<Identifiable, String> setIdentifiers = (identifiable, colName) -> {
            Set ids = (Set)rowView.getColumn(colName, (GenericType)new GenericType<Set<Identifier>>(){});
            if (ids != null) {
                identifiable.setIdentifiers(ids);
            }
        };
        License license = (License)rowView.getRow(License.class);
        if (license.getUuid() != null) {
            digitalObject.setLicense(license);
        }
        if (digitalObject.getCreationInfo() == null) {
            UUID creationCreatorUuid = (UUID)rowView.getColumn("do_creation_creator_uuid", UUID.class);
            IdentifiableObjectType creatorType = (IdentifiableObjectType)rowView.getColumn("creator_objecttype", IdentifiableObjectType.class);
            LocalDate creationDate = (LocalDate)rowView.getColumn("do_creation_date", LocalDate.class);
            UUID creationGeolocationUuid = (UUID)rowView.getColumn(this.geoLocationRepositoryImpl.getMappingPrefix() + "_uuid", UUID.class);
            IdentifiableObjectType geoLocationType = (IdentifiableObjectType)rowView.getColumn(this.geoLocationRepositoryImpl.getMappingPrefix() + "_identifiableObjectType", IdentifiableObjectType.class);
            if (creationCreatorUuid != null || creationDate != null || creationGeolocationUuid != null) {
                CreationInfo creationInfo = new CreationInfo();
                if (creationCreatorUuid != null) {
                    Person creator = switch (creatorType) {
                        case IdentifiableObjectType.PERSON -> (Person)rowView.getRow(Person.class);
                        case IdentifiableObjectType.CORPORATE_BODY -> (CorporateBody)rowView.getRow(CorporateBody.class);
                        default -> ((Agent.AgentBuilder)Agent.builder().uuid(creationCreatorUuid)).build();
                    };
                    setIdentifiers.accept((Identifiable)creator, "creator_identifiers");
                    creationInfo.setCreator((Agent)creator);
                }
                if (creationDate != null) {
                    creationInfo.setDate(creationDate);
                }
                if (creationGeolocationUuid != null) {
                    HumanSettlement creationGeoLocation = switch (geoLocationType) {
                        case IdentifiableObjectType.HUMAN_SETTLEMENT -> (HumanSettlement)rowView.getRow(HumanSettlement.class);
                        default -> (GeoLocation)rowView.getRow(GeoLocation.class);
                    };
                    setIdentifiers.accept((Identifiable)creationGeoLocation, "creation_geolocation_identifiers");
                    creationInfo.setGeoLocation((GeoLocation)creationGeoLocation);
                }
                digitalObject.setCreationInfo(creationInfo);
            }
        }
        if ((numberOfBinaryResources = (Integer)rowView.getColumn("do_number_binaryresources", Integer.class)) != null) {
            digitalObject.setNumberOfBinaryResources(numberOfBinaryResources);
        }
        if ((parentUuid = (UUID)rowView.getColumn("parent_uuid", UUID.class)) != null && (digitalObject.getParent() == null || digitalObject.getParent().getCreated() == null)) {
            UUID parentItemUuid;
            DigitalObject parent = ((DigitalObject.DigitalObjectBuilder)((DigitalObject.DigitalObjectBuilder)((DigitalObject.DigitalObjectBuilder)((DigitalObject.DigitalObjectBuilder)((DigitalObject.DigitalObjectBuilder)((DigitalObject.DigitalObjectBuilder)((DigitalObject.DigitalObjectBuilder)((DigitalObject.DigitalObjectBuilder)DigitalObject.builder().uuid(parentUuid)).label((LocalizedText)rowView.getColumn("parent_label", LocalizedText.class))).description((LocalizedStructuredContent)rowView.getColumn("parent_description", LocalizedStructuredContent.class))).customAttributes((CustomAttributes)rowView.getColumn("parent_customAttributes", CustomAttributes.class))).refId((long)((Integer)rowView.getColumn("parent_refId", Integer.class)).intValue())).notes((List)rowView.getColumn("parent_notes", (GenericType)new GenericType<List<LocalizedStructuredContent>>(){}))).created((LocalDateTime)rowView.getColumn("parent_created", LocalDateTime.class))).lastModified((LocalDateTime)rowView.getColumn("parent_lastModified", LocalDateTime.class))).build();
            setIdentifiers.accept((Identifiable)parent, "parent_identifiers");
            UUID parentsParentUuid = (UUID)rowView.getColumn("parent_parentUuid", UUID.class);
            if (parentsParentUuid != null) {
                DigitalObject parentsParent = ((DigitalObject.DigitalObjectBuilder)DigitalObject.builder().uuid(parentsParentUuid)).build();
                setIdentifiers.accept((Identifiable)parentsParent, "parent_parentIdentifiers");
                parent.setParent(parentsParent);
            }
            if ((parentItemUuid = (UUID)rowView.getColumn("parent_itemUuid", UUID.class)) != null) {
                Item parentsItem = ((Item.ItemBuilder)Item.builder().uuid(parentItemUuid)).build();
                setIdentifiers.accept((Identifiable)parentsItem, "parent_itemIdentifiers");
                parent.setItem(parentsItem);
            }
            digitalObject.setParent(parent);
        }
        if ((linkedDataFileResUuid = (UUID)rowView.getColumn(this.linkedDataFileResourceRepositoryImpl.getMappingPrefix() + "_uuid", UUID.class)) != null) {
            if (digitalObject.getLinkedDataResources() == null || digitalObject.getLinkedDataResources().isEmpty()) {
                int maxIndex = (Integer)rowView.getColumn("max_dold_sortindex", Integer.class);
                Vector resources = new Vector(++maxIndex);
                resources.setSize(maxIndex);
                digitalObject.setLinkedDataResources(resources);
            }
            LinkedDataFileResource ldFileResource = (LinkedDataFileResource)rowView.getRow(LinkedDataFileResource.class);
            if (!digitalObject.getLinkedDataResources().parallelStream().anyMatch(res -> Objects.equals(res, ldFileResource))) {
                int idx = (Integer)rowView.getColumn("dold_sortindex", Integer.class);
                digitalObject.getLinkedDataResources().set(idx, ldFileResource);
            }
        }
        if ((renderingResourceUuid = (UUID)rowView.getColumn(this.fileResourceMetadataRepositoryImpl.getMappingPrefix() + "_uuid", UUID.class)) != null) {
            if (digitalObject.getRenderingResources() == null || digitalObject.getRenderingResources().isEmpty()) {
                int maxIndex = (Integer)rowView.getColumn("max_dorr_sortindex", Integer.class);
                Vector resources = new Vector(++maxIndex);
                resources.setSize(maxIndex);
                digitalObject.setRenderingResources(resources);
            }
            FileResource renderingResource = (FileResource)rowView.getRow(FileResource.class);
            DigitalObjectRenderingFileResourceRepositoryImpl.fillResourceType(renderingResource);
            if (!digitalObject.getRenderingResources().parallelStream().anyMatch(res -> Objects.equals(res, renderingResource))) {
                int idx = (Integer)rowView.getColumn("dorr_sortindex", Integer.class);
                digitalObject.getRenderingResources().set(idx, renderingResource);
            }
        }
    }

    public void deleteFileResources(UUID digitalObjectUuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM digitalobject_fileresources WHERE digitalobject_uuid = :uuid").bind("uuid", digitalObjectUuid)).execute());
    }

    @Override
    protected void basicReduceRowsBiConsumer(Map<UUID, DigitalObject> map, RowView rowView) {
        super.basicReduceRowsBiConsumer(map, rowView);
        DigitalObject identifiable = map.get(rowView.getColumn(this.mappingPrefix + "_uuid", UUID.class));
        UUID parentUuid = (UUID)rowView.getColumn("do_parent_uuid", UUID.class);
        if (parentUuid != null) {
            identifiable.setParent(((DigitalObject.DigitalObjectBuilder)DigitalObject.builder().uuid(parentUuid)).build());
        }
        UUID itemUuid = (UUID)rowView.getColumn("do_item_uuid", UUID.class);
        LocalizedText itemLabel = (LocalizedText)rowView.getColumn("item_label", LocalizedText.class);
        Set itemIdentifiers = (Set)rowView.getColumn("item_identifiers", (GenericType)new GenericType<Set<Identifier>>(){});
        if (itemUuid != null) {
            identifiable.setItem(((Item.ItemBuilder)((Item.ItemBuilder)((Item.ItemBuilder)Item.builder().uuid(itemUuid)).label(itemLabel)).identifiers(itemIdentifiers)).build());
        }
    }

    public PageResponse<Collection> findCollections(UUID digitalObjectUuid, PageRequest pageRequest) throws RepositoryException {
        String crossTableAlias = "xtable";
        String collectionTableAlias = this.collectionRepositoryImpl.getTableAlias();
        String collectionTableName = this.collectionRepositoryImpl.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + collectionTableName + " AS " + collectionTableAlias + " INNER JOIN collection_digitalobjects AS xtable ON " + collectionTableAlias + ".uuid = xtable.collection_uuid WHERE xtable.digitalobject_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", digitalObjectUuid);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this.collectionRepositoryImpl);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.collectionRepositoryImpl.addCrossTablePagingAndSorting(pageRequest, innerQuery, "xtable");
        List result = this.collectionRepositoryImpl.retrieveList(this.collectionRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    public PageResponse<FileResource> findFileResources(UUID digitalObjectUuid, PageRequest pageRequest) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PageResponse<ImageFileResource> findImageFileResources(UUID digitalObjectUuid, PageRequest pageRequest) throws RepositoryException {
        return null;
    }

    public PageResponse<Project> findProjects(UUID digitalObjectUuid, PageRequest pageRequest) throws RepositoryException {
        String crossTableAlias = "xtable";
        String prTableAlias = this.projectRepositoryImpl.getTableAlias();
        String prTableName = this.projectRepositoryImpl.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + prTableName + " AS " + prTableAlias + " INNER JOIN project_digitalobjects AS xtable ON " + prTableAlias + ".uuid = xtable.project_uuid WHERE xtable.digitalobject_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", digitalObjectUuid);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this.projectRepositoryImpl);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.projectRepositoryImpl.addCrossTablePagingAndSorting(pageRequest, innerQuery, "xtable");
        List result = this.projectRepositoryImpl.retrieveList(this.projectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    public PageResponse<DigitalObject> findDigitalObjectsByItem(UUID itemUuid, PageRequest pageRequest) throws RepositoryException {
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " " + this.tableAlias + " WHERE " + this.tableAlias + ".item_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", itemUuid);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT * " + commonSql);
        this.addPagingAndSorting(pageRequest, innerQuery);
        List result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, this.getOrderBy(pageRequest.getSorting()));
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        if (super.getColumnName(modelProperty) != null) {
            return super.getColumnName(modelProperty);
        }
        switch (modelProperty) {
            case "parent.uuid": {
                return this.tableAlias + ".parent_uuid";
            }
        }
        return null;
    }

    public List<FileResource> getFileResources(UUID digitalObjectUuid) throws RepositoryException {
        String frTableAlias = this.fileResourceMetadataRepositoryImpl.getTableAlias();
        String frTableName = this.fileResourceMetadataRepositoryImpl.getTableName();
        String fieldsSql = this.fileResourceMetadataRepositoryImpl.getSqlSelectReducedFields();
        StringBuilder innerQuery = new StringBuilder("SELECT df.sortindex AS idx, * FROM " + frTableName + " AS " + frTableAlias + " INNER JOIN digitalobject_fileresources AS df ON " + frTableAlias + ".uuid = df.fileresource_uuid WHERE df.digitalobject_uuid = :uuid ORDER BY idx ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", digitalObjectUuid);
        List<FileResource> fileResources = this.fileResourceMetadataRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC");
        return fileResources;
    }

    public List<ImageFileResource> getIiifImageFileResources(UUID digitalObjectUuid) throws RepositoryException {
        DigitalObject digitalObject = (DigitalObject)this.getByUuid(digitalObjectUuid);
        URI iiifPresentationBaseUrl = this.iiifServerConfig.getPresentation().getBaseUrl();
        String iiifIdentifier = digitalObjectUuid.toString();
        List identifierNamespaces = this.iiifServerConfig.getIdentifier().getNamespaces();
        for (String identifierNamespace : identifierNamespaces) {
            Identifier identifier = digitalObject.getIdentifierByNamespace(identifierNamespace);
            if (identifier == null) continue;
            iiifIdentifier = identifier.getId();
            break;
        }
        try {
            URL iiifManifestUrl = iiifPresentationBaseUrl.resolve(iiifIdentifier + "/manifest").toURL();
            Manifest manifest = (Manifest)this.iiifObjectMapper.readValue(iiifManifestUrl, Manifest.class);
            ArrayList<ImageFileResource> result = new ArrayList<ImageFileResource>();
            List canvases = manifest.getDefaultSequence().getCanvases();
            for (Canvas canvas : canvases) {
                ImageFileResource ifr = this.convertToImageFileResource(canvas);
                if (ifr == null) continue;
                result.add(ifr);
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new RepositoryException("can not create IIIF presentation URL for digital object", (Throwable)e);
        }
        catch (Exception e) {
            throw new RepositoryException("can not read IIIF presentation URL for digital object", (Throwable)e);
        }
    }

    public List<ImageFileResource> getImageFileResources(UUID digitalObjectUuid) throws RepositoryException {
        String frTableAlias = this.imageFileResourceRepositoryImpl.getTableAlias();
        String frTableName = this.imageFileResourceRepositoryImpl.getTableName();
        String fieldsSql = this.imageFileResourceRepositoryImpl.getSqlSelectAllFields();
        StringBuilder innerQuery = new StringBuilder("SELECT df.sortindex AS idx, * FROM " + frTableName + " AS " + frTableAlias + " INNER JOIN digitalobject_fileresources AS df ON " + frTableAlias + ".uuid = df.fileresource_uuid WHERE df.digitalobject_uuid = :uuid ORDER BY idx ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", digitalObjectUuid);
        List<ImageFileResource> fileResources = this.imageFileResourceRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC");
        return fileResources;
    }

    public List<Locale> getLanguagesOfCollections(UUID uuid) {
        String collectionTable = this.collectionRepositoryImpl.getTableName();
        String collectionAlias = this.collectionRepositoryImpl.getTableAlias();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + collectionAlias + ".label) as languages FROM " + collectionTable + " AS " + collectionAlias + " INNER JOIN collection_digitalobjects AS cd ON " + collectionAlias + ".uuid = cd.collection_uuid WHERE cd.digitalobject_uuid = :uuid";
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", uuid)).mapTo(Locale.class).list());
    }

    public List<Locale> getLanguagesOfContainedDigitalObjects(UUID uuid) {
        String sql = "SELECT DISTINCT jsonb_object_keys(" + this.tableAlias + ".label) FROM " + this.tableName + " AS " + this.tableAlias + String.format(" WHERE %s.parent_uuid = :uuid;", this.tableAlias);
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", uuid)).mapTo(Locale.class).list());
    }

    public List<Locale> getLanguagesOfProjects(UUID uuid) {
        String projectTable = this.projectRepositoryImpl.getTableName();
        String projectAlias = this.projectRepositoryImpl.getTableAlias();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + projectAlias + ".label) as languages FROM " + projectTable + " AS " + projectAlias + " INNER JOIN project_digitalobjects AS pd ON " + projectAlias + ".uuid = pd.project_uuid WHERE pd.digitalobject_uuid = :uuid";
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", uuid)).mapTo(Locale.class).list());
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", creation_geolocation_uuid, creation_date, creation_creator_uuid, item_uuid, license_uuid, number_binaryresources, parent_uuid";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :creationInfo?.geoLocation?.uuid, :creationInfo?.date, :creationInfo?.creator?.uuid, :item?.uuid, :license?.uuid, :numberOfBinaryResources, :parent?.uuid";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectAllFields(tableAlias, mappingPrefix) + ", {{licenseTable}}.uuid {{licenseMapping}}_uuid,\n{{licenseTable}}.label {{licenseMapping}}_label,\n{{licenseTable}}.url {{licenseMapping}}_url,\n{{licenseTable}}.acronym {{licenseMapping}}_acronym,\n-- creators\n{{tableAlias}}.creation_creator_uuid {{mappingPrefix}}_creation_creator_uuid,\nget_identifiers({{tableAlias}}.creation_creator_uuid) creator_identifiers,\n{{agentAlias}}.identifiable_objecttype creator_objecttype,\n{{personFields}},\n{{corporationFields}},\n{{tableAlias}}.creation_date {{mappingPrefix}}_creation_date,\n{{tableAlias}}.creation_geolocation_uuid {{mappingPrefix}}_creation_geolocation_uuid,\nget_identifiers({{tableAlias}}.creation_geolocation_uuid) creation_geolocation_identifiers,\n{{geolocFields}},\n{{humanSettleFields}},\n-- binary resources\n{{tableAlias}}.number_binaryresources {{mappingPrefix}}_number_binaryresources,\n-- parent\nparent.uuid parent_uuid, get_identifiers(parent.uuid) parent_identifiers, parent.label parent_label,\nparent.refid parent_refId, parent.notes parent_notes, parent.created parent_created,\nparent.last_modified parent_lastModified, parent.parent_uuid parent_parentUuid, get_identifiers(parent.parent_uuid) parent_parentIdentifiers,\nparent.item_uuid parent_itemUuid, get_identifiers(parent.item_uuid) parent_itemIdentifiers,\nparent.custom_attrs parent_customAttributes, parent.description parent_description,\n-- linked data file resources\n{{digitalObjLinkedDataResAlias}}.sortindex dold_sortindex,\nmax({{digitalObjLinkedDataResAlias}}.sortindex) over (partition by {{tableAlias}}.uuid) max_dold_sortindex,\n{{linkedDataFileResFields}},\n-- rendering resources\n{{digitalObjRenderingResAlias}}.sortindex dorr_sortindex,\nmax({{digitalObjRenderingResAlias}}.sortindex) over (partition by {{tableAlias}}.uuid) max_dorr_sortindex,\n{{renderingResFields}}\n".replace("{{tableAlias}}", tableAlias).replace("{{mappingPrefix}}", mappingPrefix).replace("{{licenseTable}}", "li").replace("{{licenseMapping}}", "l").replace("{{agentAlias}}", this.agentRepositoryImpl.getTableAlias()).replace("{{personFields}}", this.personRepositoryImpl.getSqlSelectReducedFields()).replace("{{corporationFields}}", this.corporateBodyRepositoryImpl.getSqlSelectAllFields()).replace("{{geolocFields}}", this.geoLocationRepositoryImpl.getSqlSelectAllFields()).replace("{{humanSettleFields}}", this.humanSettlementRepositoryImpl.getSqlSelectAllFields()).replace("{{digitalObjLinkedDataResAlias}}", "do_ld").replace("{{linkedDataFileResFields}}", this.linkedDataFileResourceRepositoryImpl.getSqlSelectAllFields()).replace("{{digitalObjRenderingResAlias}}", "do_rr").replace("{{renderingResFields}}", this.fileResourceMetadataRepositoryImpl.getSqlSelectReducedFields());
    }

    @Override
    protected String getSqlSelectAllFieldsJoins() {
        return super.getSqlSelectAllFieldsJoins() + "LEFT JOIN {{licenseTable}} {{licenseAlias}}\n  ON {{tableAlias}}.license_uuid = {{licenseAlias}}.uuid\n-- creation info creator\nLEFT JOIN {{agentTable}} {{agentAlias}}\n  ON {{tableAlias}}.creation_creator_uuid = {{agentAlias}}.uuid\nLEFT JOIN {{corporationTable}} {{corporationAlias}}\n  ON {{agentAlias}}.uuid = {{corporationAlias}}.uuid\nLEFT JOIN {{personTable}} {{personAlias}}\n  ON {{agentAlias}}.uuid = {{personAlias}}.uuid\n-- creation info geolocation\nLEFT JOIN {{geolocTable}} {{geolocAlias}}\n  ON {{tableAlias}}.creation_geolocation_uuid = {{geolocAlias}}.uuid\nLEFT JOIN {{humanSettleTable}} {{humanSettleAlias}}\n  ON {{geolocAlias}}.uuid = {{humanSettleAlias}}.uuid\n-- parent\nLEFT JOIN {{tableName}} parent\n  ON {{tableAlias}}.parent_uuid = parent.uuid\nLEFT JOIN (\n  {{digitalObjLinkedDataResTable}} {{digitalObjLinkedDataResAlias}} INNER JOIN {{linkedDataFileResTable}} {{linkedDataFileResAlias}}\n  ON {{digitalObjLinkedDataResAlias}}.linkeddata_fileresource_uuid = {{linkedDataFileResAlias}}.uuid\n) ON {{digitalObjLinkedDataResAlias}}.digitalobject_uuid = {{tableAlias}}.uuid\nLEFT JOIN (\n  {{digitalObjRenderingResTable}} {{digitalObjRenderingResAlias}} INNER JOIN {{renderingResourcesTable}} {{renderingResourcesAlias}}\n  ON {{digitalObjRenderingResAlias}}.fileresource_uuid = {{renderingResourcesAlias}}.uuid\n) ON {{digitalObjRenderingResAlias}}.digitalobject_uuid = {{tableAlias}}.uuid\n".replace("{{tableName}}", this.tableName).replace("{{tableAlias}}", this.tableAlias).replace("{{licenseTable}}", "licenses").replace("{{licenseAlias}}", "li").replace("{{agentTable}}", this.agentRepositoryImpl.getTableName()).replace("{{agentAlias}}", this.agentRepositoryImpl.getTableAlias()).replace("{{corporationTable}}", this.corporateBodyRepositoryImpl.getTableName()).replace("{{corporationAlias}}", this.corporateBodyRepositoryImpl.getTableAlias()).replace("{{personTable}}", this.personRepositoryImpl.getTableName()).replace("{{personAlias}}", this.personRepositoryImpl.getTableAlias()).replace("{{geolocTable}}", this.geoLocationRepositoryImpl.getTableName()).replace("{{geolocAlias}}", this.geoLocationRepositoryImpl.getTableAlias()).replace("{{humanSettleTable}}", "humansettlements").replace("{{humanSettleAlias}}", "h").replace("{{digitalObjLinkedDataResTable}}", "digitalobject_linkeddataresources").replace("{{digitalObjLinkedDataResAlias}}", "do_ld").replace("{{linkedDataFileResTable}}", this.linkedDataFileResourceRepositoryImpl.getTableName()).replace("{{linkedDataFileResAlias}}", this.linkedDataFileResourceRepositoryImpl.getTableAlias()).replace("{{digitalObjRenderingResTable}}", "digitalobject_renderingresources").replace("{{digitalObjRenderingResAlias}}", "do_rr").replace("{{renderingResourcesTable}}", this.fileResourceMetadataRepositoryImpl.getTableName()).replace("{{renderingResourcesAlias}}", this.fileResourceMetadataRepositoryImpl.getTableAlias());
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", %1$s.parent_uuid %2$s_parent_uuid,\n%1$s.item_uuid %2$s_item_uuid, get_identifiers(%1$s.item_uuid) item_identifiers,\n%3$s.label item_label".formatted(tableAlias, mappingPrefix, "i");
    }

    @Override
    protected String getSqlSelectReducedFieldsJoins() {
        return super.getSqlSelectReducedFieldsJoins() + " LEFT JOIN %1$s %2$s ON %2$s.uuid = %3$s.item_uuid".formatted("items", "i", TABLE_ALIAS);
    }

    @Override
    protected String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", creation_geolocation_uuid=:creationInfo?.geoLocation?.uuid, creation_date=:creationInfo?.date, creation_creator_uuid=:creationInfo?.creator?.uuid, item_uuid=:item?.uuid, license_uuid=:license?.uuid, number_binaryresources=:numberOfBinaryResources, parent_uuid=:parent?.uuid";
    }

    public void save(DigitalObject digitalObject) throws RepositoryException {
        super.save((UniqueObject)digitalObject);
    }

    public List<FileResource> setFileResources(UUID digitalObjectUuid, List<FileResource> fileResources) throws RepositoryException {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM digitalobject_fileresources WHERE digitalobject_uuid = :uuid").bind("uuid", digitalObjectUuid)).execute());
        if (fileResources != null) {
            for (FileResource fileResource : fileResources) {
                if (fileResource.getUuid() != null) continue;
                try {
                    this.fileResourceMetadataRepositoryImpl.save((UniqueObject)fileResource);
                }
                catch (RepositoryException e) {
                    throw new RepositoryException("File resource cannot be saved properly!", (Throwable)e);
                }
            }
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO digitalobject_fileresources(digitalobject_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
                for (FileResource fileResource : fileResources) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", digitalObjectUuid)).bind("fileResourceUuid", fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (UniqueObject)fileResource))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getFileResources(digitalObjectUuid);
    }

    public void setAgentRepository(AgentRepositoryImpl<Agent> agentRepositoryImpl) {
        this.agentRepositoryImpl = agentRepositoryImpl;
    }

    public void setCollectionRepository(CollectionRepositoryImpl collectionRepositoryImpl) {
        this.collectionRepositoryImpl = collectionRepositoryImpl;
    }

    public void setCorporateBodyRepository(CorporateBodyRepositoryImpl corporateBodyRepositoryImpl) {
        this.corporateBodyRepositoryImpl = corporateBodyRepositoryImpl;
    }

    public void setFileResourceMetadataRepository(FileResourceMetadataRepositoryImpl<FileResource> fileResourceMetadataRepositoryImpl) {
        this.fileResourceMetadataRepositoryImpl = fileResourceMetadataRepositoryImpl;
    }

    public void setGeoLocationRepositoryImpl(GeoLocationRepositoryImpl<GeoLocation> geoLocationRepositoryImpl) {
        this.geoLocationRepositoryImpl = geoLocationRepositoryImpl;
    }

    public void setHumanSettlementRepository(HumanSettlementRepositoryImpl repositoryImpl) {
        this.humanSettlementRepositoryImpl = repositoryImpl;
    }

    public void setLinkedDataFileResourceRepository(LinkedDataFileResourceRepositoryImpl linkedDataFileResourceRepositoryImpl) {
        this.linkedDataFileResourceRepositoryImpl = linkedDataFileResourceRepositoryImpl;
    }

    public void setPersonRepository(PersonRepositoryImpl personRepositoryImpl) {
        this.personRepositoryImpl = personRepositoryImpl;
    }
}

