/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.TopicRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.FileResourceMetadataRepositoryImpl;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.Topic;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import de.digitalcollections.model.view.BreadcrumbNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TopicRepositoryImpl
extends EntityRepositoryImpl<Topic>
implements TopicRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopicRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "to";
    public static final String TABLE_ALIAS = "t";
    public static final String TABLE_NAME = "topics";
    private final EntityRepositoryImpl<Entity> entityRepositoryImpl;
    private final FileResourceMetadataRepositoryImpl fileResourceMetadataRepositoryImpl;

    public TopicRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository, EntityRepositoryImpl entityRepositoryImpl, FileResourceMetadataRepositoryImpl fileResourceMetadataRepositoryImpl) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, (Class<? extends Entity>)Topic.class, cudamiConfig.getOffsetForAlternativePaging(), identifierRepository, urlAliasRepository);
        this.entityRepositoryImpl = entityRepositoryImpl;
        this.fileResourceMetadataRepositoryImpl = fileResourceMetadataRepositoryImpl;
    }

    public boolean addChildren(UUID parentUuid, List<UUID> childrenUuids) throws RepositoryException {
        if (parentUuid == null || childrenUuids == null) {
            return false;
        }
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "topic_topics", "parent_topic_uuid", parentUuid);
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO topic_topics(parent_topic_uuid, child_topic_uuid, sortIndex) VALUES (:parentTopicUuid, :childTopicUuid, :sortIndex) ON CONFLICT (parent_topic_uuid, child_topic_uuid) DO NOTHING");
            childrenUuids.forEach(childUuid -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("parentTopicUuid", parentUuid)).bind("childTopicUuid", childUuid)).bind("sortIndex", nextSortIndex + childrenUuids.indexOf(childUuid))).add());
            preparedBatch.execute();
        });
        return true;
    }

    public boolean addEntities(UUID topicUuid, List<Entity> entities) throws RepositoryException {
        if (topicUuid != null && entities != null) {
            Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "topic_entities", "topic_uuid", topicUuid);
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO topic_entities(topic_uuid, entity_uuid, sortIndex) VALUES (:uuid, :entityUuid, :sortIndex) ON CONFLICT (topic_uuid, entity_uuid) DO NOTHING");
                entities.forEach(entity -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", topicUuid)).bind("entityUuid", entity.getUuid())).bind("sortIndex", nextSortIndex + this.getIndex(entities, (UniqueObject)entity))).add());
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    public boolean addFileResources(UUID topicUuid, List<FileResource> fileResources) throws RepositoryException {
        if (topicUuid != null && fileResources != null) {
            Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "topic_fileresources", "topic_uuid", topicUuid);
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO topic_fileresources(topic_uuid, fileresource_uuid, sortIndex) VALUES (:uuid, :fileresourceUuid, :sortIndex) ON CONFLICT (topic_uuid, fileresource_uuid) DO NOTHING");
                fileResources.forEach(fileResource -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", topicUuid)).bind("fileresourceUuid", fileResource.getUuid())).bind("sortIndex", nextSortIndex + this.getIndex(fileResources, (UniqueObject)fileResource))).add());
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    @Override
    public Topic create() throws RepositoryException {
        return new Topic();
    }

    public PageResponse<Topic> findChildren(UUID uuid, PageRequest pageRequest) throws RepositoryException {
        String crossTableAlias = "xtable";
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN topic_topics AS xtable ON " + this.tableAlias + ".uuid = xtable.child_topic_uuid WHERE xtable.parent_topic_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", uuid);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.addCrossTablePagingAndSorting(pageRequest, innerQuery, "xtable");
        List result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(" + this.tableAlias + ".uuid)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    public PageResponse<Entity> findEntities(UUID topicUuid, PageRequest pageRequest) throws RepositoryException {
        String crossTableAlias = "xtable";
        String entityTableAlias = this.entityRepositoryImpl.getTableAlias();
        String entityTableName = this.entityRepositoryImpl.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + entityTableName + " AS " + entityTableAlias + " INNER JOIN topic_entities AS xtable ON " + entityTableAlias + ".uuid = xtable.entity_uuid WHERE xtable.topic_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", topicUuid);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this.entityRepositoryImpl);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.entityRepositoryImpl.addCrossTablePagingAndSorting(pageRequest, innerQuery, "xtable");
        List result = this.entityRepositoryImpl.retrieveList(this.entityRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    public PageResponse<FileResource> findFileResources(UUID topicUuid, PageRequest pageRequest) throws RepositoryException {
        String crossTableAlias = "xtable";
        String frTableAlias = this.fileResourceMetadataRepositoryImpl.getTableAlias();
        String frTableName = this.fileResourceMetadataRepositoryImpl.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + frTableName + " AS " + frTableAlias + " INNER JOIN topic_fileresources AS xtable ON " + frTableAlias + ".uuid = xtable.fileresource_uuid WHERE xtable.topic_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", topicUuid);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this.fileResourceMetadataRepositoryImpl);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.fileResourceMetadataRepositoryImpl.addCrossTablePagingAndSorting(pageRequest, innerQuery, "xtable");
        List result = this.fileResourceMetadataRepositoryImpl.retrieveList(this.fileResourceMetadataRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    public PageResponse<Topic> findRootNodes(PageRequest pageRequest) throws RepositoryException {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE NOT EXISTS (SELECT FROM topic_topics WHERE child_topic_uuid = " + this.tableAlias + ".uuid)";
        return this.find(pageRequest, commonSql);
    }

    public PageResponse<Topic> findTopicsOfEntity(UUID entityUuid, PageRequest pageRequest) {
        throw new UnsupportedOperationException();
    }

    public PageResponse<Topic> findTopicsOfFileResource(UUID fileResourceUuid, PageRequest pageRequest) {
        throw new UnsupportedOperationException();
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID nodeUuid) {
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("WITH recursive breadcrumb (uuid,label,refId,parentId,depth) AS (        SELECT t.uuid AS uuid, t.label AS label, t.refid AS refId, tt.parent_topic_uuid AS parentId, 99 AS depth        FROM topics t, topic_topics tt        WHERE uuid= :uuid and tt.child_topic_uuid = t.uuid        UNION ALL        SELECT t.uuid AS uuid, t.label AS label, t.refid AS refID, tt.parent_topic_uuid AS parentId, depth-1 AS depth        FROM topics t, topic_topics tt, breadcrumb b        WHERE b.uuid = tt.child_topic_uuid AND tt.parent_topic_uuid = t.uuid AND tt.parent_topic_uuid IS NOT null    ) SELECT cast(refId AS VARCHAR) as targetId, label, depth FROM breadcrumb ORDER BY depth ASC").bind("uuid", nodeUuid)).mapTo(BreadcrumbNode.class).list());
        if (result.isEmpty()) {
            result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT cast(refId AS VARCHAR) as targetId, label AS label FROM topics WHERE uuid= :uuid").bind("uuid", nodeUuid)).mapTo(BreadcrumbNode.class).list());
        }
        return new BreadcrumbNavigation(result);
    }

    public Topic getByIdentifier(Identifier identifier) throws RepositoryException {
        Topic topic = (Topic)super.getByIdentifier(identifier);
        if (topic != null) {
            topic.setChildren(this.getChildren((Identifiable)topic));
        }
        return topic;
    }

    @Override
    public List<Topic> getByUuidsAndFiltering(List<UUID> uuids, Filtering filtering) throws RepositoryException {
        List<Topic> topics = super.getByUuidsAndFiltering(uuids, filtering);
        Optional.ofNullable(topics).map(Collection::parallelStream).ifPresent(stream -> stream.forEach(topic -> {
            try {
                topic.setChildren(this.getChildren(topic.getUuid()));
            }
            catch (RepositoryException e) {
                LOGGER.error("Cannot get children of topic with UUID %s: %s".formatted(new Object[]{topic.getUuid(), e}), (Throwable)e);
            }
        }));
        return topics;
    }

    public List<Topic> getChildren(UUID uuid) throws RepositoryException {
        StringBuilder innerQuery = new StringBuilder("SELECT tt.sortindex AS idx, * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN topic_topics tt ON " + this.tableAlias + ".uuid = tt.child_topic_uuid WHERE tt.parent_topic_uuid = :uuid ORDER BY idx ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        List<Topic> result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, "ORDER BY idx ASC");
        return result;
    }

    public List<FileResource> getFileResources(UUID topicUuid) throws RepositoryException {
        PageResponse<FileResource> response;
        PageRequest request = new PageRequest(0, 100);
        HashSet fileResources = new HashSet();
        while ((response = this.findFileResources(topicUuid, request)) != null && response.hasContent()) {
            fileResources.addAll(response.getContent());
            request = response.nextPageRequest();
            if (request != null) continue;
        }
        return new ArrayList<FileResource>(fileResources);
    }

    public List<Locale> getLanguagesOfEntities(UUID topicUuid) {
        String entityTableName = this.entityRepositoryImpl.getTableName();
        String entityTableAlias = this.entityRepositoryImpl.getTableAlias();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + entityTableAlias + ".label) AS languages FROM " + entityTableName + " AS " + entityTableAlias + " INNER JOIN topic_entities te ON " + entityTableAlias + ".uuid = te.entity_uuid WHERE te.topic_uuid = :uuid";
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", topicUuid)).mapTo(Locale.class).list());
    }

    public List<Locale> getLanguagesOfFileResources(UUID topicUuid) {
        String fileResourceTableName = this.fileResourceMetadataRepositoryImpl.getTableName();
        String fileResourceTableAlias = this.fileResourceMetadataRepositoryImpl.getTableAlias();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + fileResourceTableAlias + ".label) AS languages FROM " + fileResourceTableName + " AS " + fileResourceTableAlias + " INNER JOIN topic_fileresources tf ON " + fileResourceTableAlias + ".uuid = tf.fileresource_uuid WHERE tf.topic_uuid = :uuid";
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", topicUuid)).mapTo(Locale.class).list());
    }

    public Topic getParent(UUID nodeUuid) throws RepositoryException {
        String sqlAdditionalJoins = " INNER JOIN topic_topics tt ON " + this.tableAlias + ".uuid = tt.parent_topic_uuid";
        Filtering filtering = Filtering.builder().add(FilterCriterion.nativeBuilder().withExpression("tt.child_topic_uuid").isEquals((Object)nodeUuid).build()).build();
        Topic result = (Topic)this.retrieveOne(this.getSqlSelectReducedFields(), filtering, sqlAdditionalJoins);
        return result;
    }

    public List<Topic> getParents(UUID uuid) throws RepositoryException {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN topic_topics tt ON " + this.tableAlias + ".uuid = tt.parent_topic_uuid WHERE tt.child_topic_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        List<Topic> result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, null);
        return result;
    }

    public List<Locale> getRootNodesLanguages() {
        String query = "SELECT DISTINCT jsonb_object_keys(" + this.tableAlias + ".label) AS languages FROM " + this.tableName + " AS " + this.tableAlias + " WHERE NOT EXISTS (SELECT FROM topic_topics WHERE child_topic_uuid = " + this.tableAlias + ".uuid)";
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public List<Topic> getTopicsOfEntity(UUID entityUuid) throws RepositoryException {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN topic_entities te ON " + this.tableAlias + ".uuid = te.topic_uuid WHERE te.entity_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", entityUuid);
        List<Topic> result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, null);
        return result;
    }

    public List<Topic> getTopicsOfFileResource(UUID fileResourceUuid) throws RepositoryException {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN topic_fileresources tf ON " + this.tableAlias + ".uuid = tf.topic_uuid WHERE tf.fileresource_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", fileResourceUuid);
        List<Topic> result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, null);
        return result;
    }

    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        if (parentUuid == null || childUuid == null) {
            return false;
        }
        String sql = "DELETE FROM topic_topics WHERE parent_topic_uuid=:parentTopicUuid AND child_topic_uuid=:childTopicUuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM topic_topics WHERE parent_topic_uuid=:parentTopicUuid AND child_topic_uuid=:childTopicUuid").bind("parentTopicUuid", parentUuid)).bind("childTopicUuid", childUuid)).execute());
        return true;
    }

    public boolean removeEntity(UUID topicUuid, UUID entityUuid) throws RepositoryException {
        if (topicUuid != null && entityUuid != null) {
            String sql = "DELETE FROM topic_entities WHERE topic_uuid=:topicUuid AND entity_uuid=:entityUuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM topic_entities WHERE topic_uuid=:topicUuid AND entity_uuid=:entityUuid").bind("topicUuid", topicUuid)).bind("entityUuid", entityUuid)).execute());
            return true;
        }
        return false;
    }

    public boolean removeFileResource(UUID topicUuid, UUID fileResourceUuid) throws RepositoryException {
        if (topicUuid != null && fileResourceUuid != null) {
            String sql = "DELETE FROM topic_fileresources WHERE topic_uuid=:topicUuid AND fileresource_uuid=:fileResourceUuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM topic_fileresources WHERE topic_uuid=:topicUuid AND fileresource_uuid=:fileResourceUuid").bind("topicUuid", topicUuid)).bind("fileResourceUuid", fileResourceUuid)).execute());
            return true;
        }
        return false;
    }

    public Topic saveParentRelation(UUID childUuid, UUID parentUuid) throws RepositoryException {
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "topic_topics", "parent_topic_uuid", parentUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO topic_topics(parent_topic_uuid, child_topic_uuid, sortindex) VALUES (:parentTopicUuid, :childTopicUuid, :sortIndex)").bind("parentTopicUuid", parentUuid)).bind("childTopicUuid", childUuid)).bind("sortIndex", nextSortIndex)).execute());
        return (Topic)this.getByUuid(childUuid);
    }

    public boolean setEntities(UUID topicUuid, List<Entity> entities) throws RepositoryException {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM topic_entities WHERE topic_uuid = :uuid").bind("uuid", topicUuid)).execute());
        if (entities != null) {
            if (entities.size() > 0) {
                this.dbi.useHandle(handle -> {
                    PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO topic_entities(topic_uuid, entity_uuid, sortIndex) VALUES(:uuid, :entityUuid, :sortIndex)");
                    for (Entity entity : entities) {
                        ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", topicUuid)).bind("entityUuid", entity.getUuid())).bind("sortIndex", this.getIndex(entities, (UniqueObject)entity))).add();
                    }
                    preparedBatch.execute();
                });
            }
            return true;
        }
        return false;
    }

    public boolean setFileResources(UUID topicUuid, List<FileResource> fileResources) throws RepositoryException {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM topic_fileresources WHERE topic_uuid = :uuid").bind("uuid", topicUuid)).execute());
        if (fileResources != null) {
            if (fileResources.size() > 0) {
                this.dbi.useHandle(handle -> {
                    PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO topic_fileresources(topic_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
                    for (FileResource fileResource : fileResources) {
                        ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", topicUuid)).bind("fileResourceUuid", fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (UniqueObject)fileResource))).add();
                    }
                    preparedBatch.execute();
                });
            }
            return true;
        }
        return false;
    }

    public boolean updateChildrenOrder(UUID parentUuid, List<UUID> children) {
        if (parentUuid == null || children == null) {
            throw new IllegalArgumentException("update failed: given objects must not be null");
        }
        String query = "UPDATE topic_topics SET sortindex = :idx WHERE child_topic_uuid = :childUuid AND parent_topic_uuid = :parentUuid;";
        this.dbi.withHandle(h -> {
            PreparedBatch batch = h.prepareBatch(query);
            int idx = 0;
            for (UUID uuidChild : children) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("idx", idx++)).bind("childUuid", uuidChild)).bind("parentUuid", parentUuid)).add();
            }
            return batch.execute();
        });
        return true;
    }
}

