/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierTypeRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.UniqueObjectRepositoryImpl;
import de.digitalcollections.model.identifiable.IdentifierType;
import java.util.Arrays;
import java.util.List;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.springframework.stereotype.Repository;

@Repository
public class IdentifierTypeRepositoryImpl
extends UniqueObjectRepositoryImpl<IdentifierType>
implements IdentifierTypeRepository {
    public static final String MAPPING_PREFIX = "idt";
    public static final String TABLE_ALIAS = "idt";
    public static final String TABLE_NAME = "identifiertypes";

    public IdentifierTypeRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, "idt", "idt", IdentifierType.class, cudamiConfig.getOffsetForAlternativePaging());
    }

    public IdentifierType create() throws RepositoryException {
        return new IdentifierType();
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("label", "namespace", "pattern"));
        return allowedOrderByFields;
    }

    public IdentifierType getByNamespace(String namespace) throws RepositoryException {
        String sql = "SELECT * FROM " + this.tableName + " WHERE namespace = :namespace";
        IdentifierType identifierType = (IdentifierType)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("namespace", namespace)).mapToBean(IdentifierType.class).findOne().orElse(null));
        return identifierType;
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "label": {
                return this.tableAlias + ".label";
            }
            case "namespace": {
                return this.tableAlias + ".namespace";
            }
            case "pattern": {
                return this.tableAlias + ".pattern";
            }
        }
        return super.getColumnName(modelProperty);
    }

    public List<IdentifierType> getRandom(int count) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", label, namespace, pattern";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :label, :namespace, :pattern";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return this.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".label " + mappingPrefix + "_label, " + tableAlias + ".namespace " + mappingPrefix + "_namespace, " + tableAlias + ".pattern " + mappingPrefix + "_pattern";
    }

    @Override
    protected String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", label=:label, namespace=:namespace, pattern=:pattern";
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        switch (modelProperty) {
            case "label": {
                return true;
            }
        }
        return false;
    }
}

