/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work;

import de.digitalcollections.model.identifiable.entity.agent.Agent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DerivedAgentBuildHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerivedAgentBuildHelper.class);

    private DerivedAgentBuildHelper() {
    }

    public static <A extends Agent> A build(Agent agent, Class<A> derivedClazz) {
        if (agent == null || derivedClazz == null) {
            return null;
        }
        try {
            Agent derivedInst = (Agent)derivedClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            List derivedInstSetters = Stream.of(derivedInst.getClass().getMethods()).filter(m -> m.getName().startsWith("set")).collect(Collectors.toList());
            for (Method agentGetter : agent.getClass().getMethods()) {
                if (!agentGetter.getName().startsWith("get")) continue;
                Type returnType = agentGetter.getGenericReturnType();
                Method[] setters = (Method[])derivedInstSetters.stream().filter(derivSetter -> derivSetter.getName().equals(agentGetter.getName().replaceFirst("^get", "set")) && derivSetter.getParameterCount() == 1 && derivSetter.getParameters()[0].getParameterizedType().equals(returnType)).toArray(Method[]::new);
                if (setters.length != 1) continue;
                setters[0].invoke((Object)derivedInst, agentGetter.invoke((Object)agent, new Object[0]));
            }
            return (A)derivedInst;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error("Error while building the derived agent instance, reflection threw an exception", (Throwable)e);
            return null;
        }
    }
}

