/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.DigitalObjectLinkedDataFileResourceRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.LinkedDataFileResourceRepositoryImpl;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.resource.LinkedDataFileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

@Repository
public class DigitalObjectLinkedDataFileResourceRepositoryImpl
extends JdbiRepositoryImpl
implements DigitalObjectLinkedDataFileResourceRepository {
    public static final String MAPPING_PREFIX = "dold";
    public static final String TABLE_ALIAS = "do_ld";
    public static final String TABLE_NAME = "digitalobject_linkeddataresources";
    private final LinkedDataFileResourceRepositoryImpl linkedDataFileResourceRepositoryImpl;

    public DigitalObjectLinkedDataFileResourceRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, LinkedDataFileResourceRepositoryImpl linkedDataFileResourceRepository) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, cudamiConfig.getOffsetForAlternativePaging());
        this.linkedDataFileResourceRepositoryImpl = linkedDataFileResourceRepository;
    }

    public int countDigitalObjectsForResource(UUID uuid) {
        return (Integer)this.dbi.withHandle(h -> (Integer)((Query)h.createQuery("SELECT count(*) FROM " + this.tableName + " WHERE linkeddata_fileresource_uuid = :uuid").bind("uuid", uuid)).mapTo(Integer.class).findOne().get());
    }

    public int delete(List<UUID> uuids) {
        return (Integer)this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE linkeddata_fileresource_uuid in (<uuids>)").bindList("uuids", (Iterable)uuids)).execute());
    }

    public PageResponse<LinkedDataFileResource> findLinkedDataFileResources(UUID digitalObjectUuid, PageRequest pageRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("digitalobject_uuid", "linkeddata_fileresource_uuid", "sortIndex"));
    }

    @Override
    public String getColumnName(String modelProperty) {
        return null;
    }

    public List<LinkedDataFileResource> getLinkedDataFileResources(UUID digitalObjectUuid) throws RepositoryException {
        String fieldsSql = this.linkedDataFileResourceRepositoryImpl.getSqlSelectAllFields();
        StringBuilder innerQuery = new StringBuilder("SELECT " + this.getTableAlias() + ".sortindex as idx, * FROM fileresources_linkeddata AS f INNER JOIN " + this.getTableName() + " AS " + this.getTableAlias() + " ON f.uuid = " + this.getTableAlias() + ".linkeddata_fileresource_uuid WHERE " + this.getTableAlias() + ".digitalobject_uuid = :uuid ORDER by " + this.getTableAlias() + ".sortindex ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", digitalObjectUuid);
        return this.linkedDataFileResourceRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC");
    }

    @Override
    protected String getUniqueField() {
        return null;
    }

    public void setLinkedDataFileResources(UUID digitalObjectUuid, List<LinkedDataFileResource> linkedDataFileResources) throws RepositoryException {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM digitalobject_linkeddataresources WHERE digitalobject_uuid = :uuid").bind("uuid", digitalObjectUuid)).execute());
        if (linkedDataFileResources != null) {
            for (LinkedDataFileResource linkedDataFileResource : linkedDataFileResources) {
                if (linkedDataFileResource.getUuid() != null) continue;
                this.linkedDataFileResourceRepositoryImpl.save((UniqueObject)linkedDataFileResource);
            }
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO digitalobject_linkeddataresources(digitalobject_uuid, linkeddata_fileresource_uuid, sortIndex) VALUES(:uuid, :linkedDataFileResourceUuid, :sortIndex)");
                for (LinkedDataFileResource linkedDataFileResource : linkedDataFileResources) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", digitalObjectUuid)).bind("linkedDataFileResourceUuid", linkedDataFileResource.getUuid())).bind("sortIndex", this.linkedDataFileResourceRepositoryImpl.getIndex(linkedDataFileResources, (UniqueObject)linkedDataFileResource))).add();
                }
                preparedBatch.execute();
            });
        }
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        return false;
    }
}

