/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.security;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.security.UserRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.UniqueObjectRepositoryImpl;
import de.digitalcollections.model.security.Role;
import de.digitalcollections.model.security.User;
import java.util.Arrays;
import java.util.List;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.springframework.stereotype.Repository;

@Repository
public class UserRepositoryImpl
extends UniqueObjectRepositoryImpl<User>
implements UserRepository {
    public static final String MAPPING_PREFIX = "us";
    public static final String TABLE_ALIAS = "u";
    public static final String TABLE_NAME = "users";

    public UserRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, User.class, cudamiConfig.getOffsetForAlternativePaging());
        this.dbi.registerArrayType(Role.class, "varchar");
    }

    public User create() {
        return new User();
    }

    public List<User> getActiveAdminUsers() {
        return (List)this.dbi.withHandle(h -> {
            String sql = "SELECT " + this.getSqlSelectReducedFields() + " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE ? = any(roles)";
            return ((Query)h.createQuery(sql).bind(0, Role.ADMIN.name())).mapTo(User.class).list();
        });
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("email", "firstname", "lastname"));
        return allowedOrderByFields;
    }

    public User getByEmail(String email) {
        return (User)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT " + this.getSqlSelectAllFields() + " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE email = :email").bind("email", email)).mapTo(User.class).findFirst().orElse(null));
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "email": {
                return this.tableAlias + ".email";
            }
            case "lastname": {
                return this.tableAlias + ".lastname";
            }
            case "firstname": {
                return this.tableAlias + ".firstname";
            }
        }
        return super.getColumnName(modelProperty);
    }

    public List<User> getRandom(int count) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", email, enabled, firstname, lastname, passwordhash, roles";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :email, :enabled, :firstname, :lastname, :passwordHash, :roles";
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", {{tableAlias}}.email {{mappingPrefix}}_email,\n{{tableAlias}}.enabled {{mappingPrefix}}_enabled,\n{{tableAlias}}.firstname {{mappingPrefix}}_firstname,\n{{tableAlias}}.lastname {{mappingPrefix}}_lastname,\n{{tableAlias}}.passwordhash {{mappingPrefix}}_passwordhash,\n{{tableAlias}}.roles {{mappingPrefix}}_roles".replace("{{tableAlias}}", tableAlias).replace("{{mappingPrefix}}", mappingPrefix);
    }

    @Override
    protected String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", email=:email, enabled=:enabled, firstname=:firstname, lastname=:lastname, passwordhash=:passwordHash, roles=:roles";
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        switch (modelProperty) {
            case "firstname": 
            case "lastname": {
                return true;
            }
        }
        return false;
    }
}

