/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.UniqueObjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifierRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.alias.UrlAliasRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.semantic.SubjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.semantic.TagRepositoryImpl;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.identifiable.semantic.Subject;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import de.digitalcollections.model.semantic.Tag;
import de.digitalcollections.model.text.LocalizedText;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class IdentifiableRepositoryImpl<I extends Identifiable>
extends UniqueObjectRepositoryImpl<I>
implements IdentifiableRepository<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiableRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "idf";
    public static final String TABLE_ALIAS = "i";
    public static final String TABLE_NAME = "identifiables";
    private final IdentifierRepository identifierRepository;
    private final UrlAliasRepositoryImpl urlAliasRepository;

    @Autowired
    protected IdentifiableRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository) {
        this(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, Identifiable.class, cudamiConfig.getOffsetForAlternativePaging(), identifierRepository, urlAliasRepository);
    }

    protected IdentifiableRepositoryImpl(Jdbi dbi, String tableName, String tableAlias, String mappingPrefix, Class<? extends Identifiable> identifiableImplClass, int offsetForAlternativePaging, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository) {
        super(dbi, tableName, tableAlias, mappingPrefix, identifiableImplClass, offsetForAlternativePaging);
        this.identifierRepository = identifierRepository;
        this.urlAliasRepository = (UrlAliasRepositoryImpl)urlAliasRepository;
        dbi.registerRowMapper(BeanMapper.factory(UrlAlias.class, (String)"ua"));
    }

    public String addCrossTablePagingAndSorting(PageRequest pageRequest, StringBuilder innerQuery, String crossTableAlias) {
        String orderBy = this.getOrderBy(pageRequest.getSorting());
        if (!StringUtils.hasText((String)orderBy)) {
            orderBy = "ORDER BY idx ASC";
            innerQuery.append(" ORDER BY " + crossTableAlias + ".sortindex");
        }
        this.addPagingAndSorting(pageRequest, innerQuery);
        return orderBy;
    }

    public void addRelatedEntity(UUID identifiableUuid, UUID entityUuid) throws RepositoryException {
        Integer sortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "rel_identifiable_entities", "identifiable_uuid", identifiableUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO rel_identifiable_entities(identifiable_uuid, entity_uuid, sortindex) VALUES (:identifiableUuid, :entityUuid, :sortindex)").bind("identifiableUuid", identifiableUuid)).bind("entityUuid", entityUuid)).bind("sortindex", sortIndex)).execute());
    }

    public void addRelatedFileresource(UUID identifiableUuid, UUID fileResourceUuid) throws RepositoryException {
        Integer sortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "rel_identifiable_fileresources", "identifiable_uuid", identifiableUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO rel_identifiable_fileresources(identifiable_uuid, fileresource_uuid, sortindex) VALUES (:identifiableUuid, :fileresourceUuid, :sortindex)").bind("identifiableUuid", identifiableUuid)).bind("fileresourceUuid", fileResourceUuid)).bind("sortindex", sortIndex)).execute());
    }

    public I create() throws RepositoryException {
        return (I)new Identifiable();
    }

    @Override
    protected void basicReduceRowsBiConsumer(Map<UUID, I> map, RowView rowView) {
        super.basicReduceRowsBiConsumer(map, rowView);
        Identifiable identifiable = (Identifiable)map.get(rowView.getColumn(this.mappingPrefix + "_uuid", UUID.class));
        this.setPreviewImageFromRowView(rowView, identifiable);
        this.setIdentifiersFromRowView(rowView, identifiable);
        this.setLocalizedUrlAliasesFromRowView(rowView, identifiable);
    }

    @Override
    protected void fullReduceRowsBiConsumer(Map<UUID, I> map, RowView rowView) {
        super.fullReduceRowsBiConsumer(map, rowView);
        Identifiable identifiable = (Identifiable)map.get(rowView.getColumn(this.mappingPrefix + "_uuid", UUID.class));
        this.setPreviewImageIdentifier(rowView, identifiable);
        this.setTagsFromRowView(rowView, identifiable);
        this.setSubjectsFromRowView(rowView, identifiable);
    }

    @Override
    public int deleteByUuids(List<UUID> identifiablesUuids) throws RepositoryException {
        for (UUID identifiableUuid : identifiablesUuids) {
            try {
                this.deleteIdentifiers(identifiableUuid);
            }
            catch (RepositoryException e) {
                throw new RepositoryException("Error while removing Identifiers. Rollback.", (Throwable)e);
            }
            try {
                this.urlAliasRepository.deleteByIdentifiable(identifiableUuid, true);
            }
            catch (RepositoryException e) {
                throw new RepositoryException("Error while removing UrlAliases. Rollback.", (Throwable)e);
            }
        }
        return super.deleteByUuids(identifiablesUuids);
    }

    private boolean deleteIdentifiers(UUID identifiableUuid) throws RepositoryException {
        Identifiable identifiable = this.getByUuids(List.of(identifiableUuid)).stream().findFirst().orElse(null);
        if (identifiable == null || identifiable.getIdentifiers() == null) {
            return false;
        }
        this.identifierRepository.delete(identifiable.getIdentifiers());
        return true;
    }

    @Override
    protected PageResponse<I> find(PageRequest pageRequest, String commonSql, Map<String, Object> argumentMappings) throws RepositoryException {
        if (pageRequest.getFiltering() != null && (pageRequest.getFiltering().getFilterCriterionFor("identifiers.id") != null || pageRequest.getFiltering().getFilterCriterionFor("identifiers.namespace") != null)) {
            commonSql = commonSql.replaceFirst("(?iu)(from .+\\b)(\\bwhere .+)?\\s*$", "$1 LEFT JOIN {{identifiers}} {{identifiersAlias}} ON {{identifiersAlias}}.identifiable = {{tableAlias}}.uuid $2".replace("{{tableAlias}}", this.tableAlias).replace("{{identifiers}}", "identifiers").replace("{{identifiersAlias}}", "id"));
        }
        PageResponse pageResponse = super.find(pageRequest, commonSql, argumentMappings);
        this.filterByLocalizedTextFields(pageRequest, pageResponse, this.getJsonbFields());
        return pageResponse;
    }

    @Deprecated
    public PageResponse<I> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) throws RepositoryException {
        Filtering filtering = pageRequest.getFiltering();
        if (filtering == null) {
            filtering = Filtering.builder().build();
            pageRequest.setFiltering(filtering);
        }
        Filtering initialFiltering = Filtering.builder().add(FilterCriterion.builder().withExpression(this.tableAlias + ".label ->> :language").startsWith((Object)":initial").build()).build();
        filtering.add(initialFiltering);
        Sorting sorting = pageRequest.getSorting();
        Sorting labelSorting = Sorting.builder().order(Order.builder().property("label").subProperty(language).direction(Direction.ASC).build()).build();
        if (sorting == null) {
            sorting = labelSorting;
        } else {
            sorting.and(labelSorting);
        }
        pageRequest.setSorting(sorting);
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(2);
        argumentMappings.put("language", language);
        argumentMappings.put("initial", initial);
        return this.find(pageRequest, argumentMappings);
    }

    public PageResponse<Entity> findRelatedEntities(UUID identifiableUuid, PageRequest pageRequest) throws RepositoryException {
        StringBuilder commonSql = new StringBuilder(" FROM entities e INNER JOIN rel_identifiable_entities rel ON e.uuid=rel.entity_uuid WHERE rel.identifiable_uuid = :identifiableUuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("identifiableUuid", identifiableUuid);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder query = new StringBuilder("SELECT rel.sortindex AS idx, *" + commonSql);
        pageRequest.setSorting(new Sorting(new Order[]{new Order(Direction.ASC, "idx")}));
        this.addPagingAndSorting(pageRequest, query);
        List list = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(Entity.class).list());
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        PageResponse pageResponse = new PageResponse(list, pageRequest, total);
        return pageResponse;
    }

    public PageResponse<FileResource> findRelatedFileResources(UUID identifiableUuid, PageRequest pageRequest) throws RepositoryException {
        StringBuilder commonSql = new StringBuilder(" FROM fileresources f INNER JOIN rel_identifiable_fileresources rel ON f.uuid=rel.fileresource_uuid WHERE rel.identifiable_uuid = :identifiableUuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("identifiableUuid", identifiableUuid);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder query = new StringBuilder("SELECT rel.sortindex AS idx, *" + commonSql);
        pageRequest.setSorting(new Sorting(new Order[]{new Order(Direction.ASC, "idx")}));
        this.addPagingAndSorting(pageRequest, query);
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query.toString()).bindMap(argumentMappings)).mapToBean(FileResource.class).list());
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        PageResponse pageResponse = new PageResponse(list, pageRequest, total);
        return pageResponse;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("identifiableObjectType", "label", "type"));
        return allowedOrderByFields;
    }

    public I getByIdentifier(String namespace, String identifierId) throws RepositoryException {
        UUID identifiableUuid = (UUID)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery("SELECT identifiable FROM identifiers\nWHERE namespace = :namespace\n  AND identifier = :id;\n").bind("namespace", namespace)).bind("id", identifierId)).mapTo(UUID.class).findOne().orElse(null));
        if (identifiableUuid == null) {
            return null;
        }
        return (I)((Identifiable)this.getByUuids(List.of(identifiableUuid)).stream().findFirst().orElse(null));
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "description": {
                return this.tableAlias + ".description";
            }
            case "identifiableObjectType": {
                return this.tableAlias + ".identifiable_objecttype";
            }
            case "label": {
                return this.tableAlias + ".label";
            }
            case "previewImage": {
                return this.tableAlias + ".previewfileresource";
            }
            case "type": {
                return this.tableAlias + ".identifiable_type";
            }
            case "identifiers.id": {
                return "id.identifier";
            }
            case "identifiers.namespace": {
                return "id.namespace";
            }
        }
        return super.getColumnName(modelProperty);
    }

    @Override
    protected LinkedHashMap<String, Function<I, Optional<Object>>> getJsonbFields() {
        LinkedHashMap<String, Function<I, Optional<Object>>> jsonbFields = super.getJsonbFields();
        jsonbFields.put("description", i -> Optional.ofNullable(i.getDescription()));
        jsonbFields.put("label", i -> Optional.ofNullable(i.getLabel()));
        jsonbFields.put("previewImageRenderingHints", i -> Optional.ofNullable(i.getPreviewImageRenderingHints()));
        return jsonbFields;
    }

    public List<Locale> getLanguages() throws RepositoryException {
        String query = "SELECT DISTINCT jsonb_object_keys(" + this.tableAlias + ".label) as languages FROM " + this.tableName + " AS " + this.tableAlias;
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public List<I> getRandom(int count) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", description, identifiable_objecttype,\nidentifiable_type, label, previewfileresource,\npreview_hints, split_label, tags_uuids, subjects_uuids\n";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :description::JSONB, :identifiableObjectType,\n:type, :label::JSONB, :previewFileResource,\n:previewImageRenderingHints::JSONB, :split_label::TEXT[], :tags_uuids::UUID[], :subjects_uuids::UUID[]\n";
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + "{{alias}}.description {{prefix}}_description,\n{{alias}}.identifiable_objecttype {{prefix}}_identifiableObjectType,\n{{alias}}.identifiable_type {{prefix}}_type,\n{{alias}}.label {{prefix}}_label,\n{{alias}}.preview_hints {{prefix}}_previewImageRenderingHints".replace("{{alias}}", tableAlias).replace("{{prefix}}", mappingPrefix);
    }

    @Override
    protected String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", description=:description::JSONB, label=:label::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, split_label=:split_label::TEXT[], tags_uuids=:tags_uuids::UUID[], subjects_uuids=:subjects_uuids::UUID[]";
    }

    @Override
    protected boolean hasSplitColumn(String propertyName) {
        return switch (propertyName) {
            case "label" -> true;
            default -> super.hasSplitColumn(propertyName);
        };
    }

    @Override
    protected List<I> retrieveList(String fieldsSql, String fieldsSqlAdditionalJoins, StringBuilder innerQuery, Map<String, Object> argumentMappings, String orderBy) throws RepositoryException {
        String sql = "SELECT " + fieldsSql + "," + IdentifierRepositoryImpl.sqlSelectAllFields("id", "id") + ", file.uuid pi_uuid, file.label pi_label, file.filename pi_filename, file.mimetype pi_mimeType, file.uri pi_uri, file.http_base_url pi_httpBaseUrl, " + UrlAliasRepositoryImpl.sqlSelectReducedFields("ua", "ua") + " FROM " + (String)(innerQuery != null ? "(" + innerQuery + ")" : this.tableName) + " AS " + this.tableAlias + (StringUtils.hasText((String)fieldsSqlAdditionalJoins) ? " %s".formatted(fieldsSqlAdditionalJoins) : "") + (StringUtils.hasText((String)this.getSqlSelectReducedFieldsJoins()) ? " %s ".formatted(this.getSqlSelectReducedFieldsJoins()) : "") + " LEFT JOIN identifiers AS id ON " + this.tableAlias + ".uuid = id.identifiable LEFT JOIN fileresources_image AS file ON " + this.tableAlias + ".previewfileresource = file.uuid LEFT JOIN url_aliases AS ua ON " + this.tableAlias + ".uuid = ua.target_uuid" + this.urlAliasRepository.getSqlSelectReducedFieldsJoins() + (String)(orderBy != null && orderBy.matches("(?iu)^\\s*order by.+") ? " " + orderBy : (StringUtils.hasText((String)orderBy) ? " ORDER BY " + orderBy : ""));
        List result = (List)this.dbi.withHandle(handle -> ((Query)handle.createQuery(sql).bindMap(argumentMappings)).reduceRows(this::basicReduceRowsBiConsumer).collect(Collectors.toList()));
        return result;
    }

    @Override
    public List<I> retrieveList(String fieldsSql, StringBuilder innerQuery, Map<String, Object> argumentMappings, String orderBy) throws RepositoryException {
        return this.retrieveList(fieldsSql, null, innerQuery, argumentMappings, orderBy);
    }

    @Override
    public List<I> retrieveMultiple(String fieldsSql, Filtering filtering, String sqlAdditionalJoins, Map<String, Object> argumentMappings, String innerSelect) throws RepositoryException {
        StringBuilder sql = new StringBuilder(("SELECT {{fieldsSql}}, {{identifierFields}},\n  {{imageFileFields}}, get_identifiers(file.uuid) pi_identifiers,\n  {{urlAliasFields}}, {{tagFields}}, {{subjectFields}}\nFROM {{mainTable}} {{mainAlias}}\n" + (StringUtils.hasText((String)sqlAdditionalJoins) ? "%s\n".formatted(sqlAdditionalJoins) : "") + (StringUtils.hasText((String)this.getSqlSelectAllFieldsJoins()) ? "%s\n".formatted(this.getSqlSelectAllFieldsJoins()) : "") + (StringUtils.hasText((String)this.getSqlSelectReducedFieldsJoins()) ? "%s\n".formatted(this.getSqlSelectReducedFieldsJoins()) : "") + "LEFT JOIN {{identifierTable}} AS {{identifierAlias}}\n  ON  {{mainAlias}}.uuid = {{identifierAlias}}.identifiable\nLEFT JOIN {{imageFileTable}} AS file\n  ON {{mainAlias}}.previewfileresource = file.uuid\nLEFT JOIN {{urlAliasTable}} AS {{urlAliasAlias}}\n  ON  {{mainAlias}}.uuid = {{urlAliasAlias}}.target_uuid\n{{urlAliasExtraJoins}}\nLEFT JOIN {{tagTable}} {{tagAlias}}\n  ON {{tagAlias}}.uuid = ANY({{mainAlias}}.tags_uuids)\nLEFT JOIN {{subjectTable}} {{subjectAlias}}\n  ON {{subjectAlias}}.uuid = ANY({{mainAlias}}.subjects_uuids)\n").replace("{{fieldsSql}}", fieldsSql).replace("{{identifierFields}}", IdentifierRepositoryImpl.sqlSelectAllFields("id", "id")).replace("{{imageFileFields}}", " file.uuid pi_uuid, file.label pi_label, file.filename pi_filename, file.mimetype pi_mimeType, file.uri pi_uri, file.http_base_url pi_httpBaseUrl").replace("{{urlAliasFields}}", UrlAliasRepositoryImpl.sqlSelectReducedFields("ua", "ua")).replace("{{tagFields}}", TagRepositoryImpl.sqlSelectReducedFields("tags", "tags")).replace("{{subjectFields}}", SubjectRepositoryImpl.sqlSelectReducedFields("subj", "subj")).replace("{{mainTable}}", StringUtils.hasText((String)innerSelect) ? innerSelect : this.tableName).replace("{{mainAlias}}", this.tableAlias).replace("{{identifierTable}}", "identifiers").replace("{{identifierAlias}}", "id").replace("{{imageFileTable}}", "fileresources_image").replace("{{urlAliasTable}}", "url_aliases").replace("{{urlAliasAlias}}", "ua").replace("{{urlAliasExtraJoins}}", this.urlAliasRepository.getSqlSelectReducedFieldsJoins()).replace("{{tagTable}}", "tags").replace("{{tagAlias}}", "tags").replace("{{subjectTable}}", "subjects").replace("{{subjectAlias}}", "subj"));
        if (argumentMappings == null) {
            argumentMappings = new HashMap<String, Object>(0);
        }
        this.addFiltering(filtering, sql, argumentMappings);
        Map<String, Object> bindMap = Map.copyOf(argumentMappings);
        List result = ((Stream)this.dbi.withHandle(h -> ((Query)h.createQuery(sql.toString()).bindMap(bindMap)).reduceRows((map, rowView) -> {
            this.fullReduceRowsBiConsumer((Map<UUID, I>)map, (RowView)rowView);
            this.additionalReduceRowsBiConsumer(map, (RowView)rowView);
        }))).collect(Collectors.toList());
        return result;
    }

    @Override
    public void save(I identifiable, Map<String, Object> bindings, BiFunction<String, Map<String, Object>, String> sqlModifier) throws RepositoryException {
        if (bindings == null) {
            bindings = new HashMap<String, Object>(0);
        }
        UUID previewImageUuid = identifiable.getPreviewImage() == null ? null : identifiable.getPreviewImage().getUuid();
        bindings.put("previewFileResource", previewImageUuid);
        bindings.put("split_label", this.splitToArray(identifiable.getLabel()));
        bindings.put("tags_uuids", this.extractUuids(identifiable.getTags()));
        bindings.put("subjects_uuids", this.extractUuids(identifiable.getSubjects()));
        super.save(identifiable, bindings, sqlModifier);
        try {
            identifiable.setIdentifiers(this.identifierRepository.saveForIdentifiable(identifiable, identifiable.getIdentifiers()));
        }
        catch (RepositoryException e) {
            LOGGER.error(String.format("Cannot save Identifiers %s: %s for %s", identifiable.getIdentifiers(), e.getMessage(), identifiable), (Throwable)e);
            throw e;
        }
    }

    private void setIdentifiersFromRowView(RowView rowView, I identifiable) {
        if (rowView.getColumn("id_uuid", UUID.class) != null) {
            Identifier dbIdentifier = (Identifier)rowView.getRow(Identifier.class);
            identifiable.addIdentifier(dbIdentifier);
        }
    }

    private void setLocalizedUrlAliasesFromRowView(RowView rowView, I identifiable) {
        if (rowView.getColumn("ua_uuid", UUID.class) != null) {
            UUID identifiableUuid;
            UrlAlias urlAlias = (UrlAlias)rowView.getRow(UrlAlias.class);
            UUID websiteUuid = (UUID)rowView.getColumn("uawebs_uuid", UUID.class);
            if (websiteUuid != null) {
                Website website = new Website((URL)rowView.getColumn("uawebs_url", URL.class));
                website.setUuid(websiteUuid);
                website.setLabel((LocalizedText)rowView.getColumn("uawebs_label", LocalizedText.class));
                urlAlias.setWebsite(website);
            }
            if ((identifiableUuid = (UUID)rowView.getColumn("uaidf_uuid", UUID.class)) != null) {
                Identifiable idf = new Identifiable();
                idf.setUuid(identifiableUuid);
                idf.setIdentifiableObjectType((IdentifiableObjectType)rowView.getColumn("uaidf_identifiableobjecttype", IdentifiableObjectType.class));
                idf.setType((IdentifiableType)rowView.getColumn("uaidf_identifiabletype", IdentifiableType.class));
                urlAlias.setTarget(idf);
            }
            if (identifiable.getLocalizedUrlAliases() == null) {
                identifiable.setLocalizedUrlAliases(new LocalizedUrlAliases(new UrlAlias[]{urlAlias}));
            } else if (!identifiable.getLocalizedUrlAliases().containsUrlAlias(urlAlias)) {
                identifiable.getLocalizedUrlAliases().add(new UrlAlias[]{urlAlias});
            }
        }
    }

    private void setPreviewImageFromRowView(RowView rowView, I identifiable) {
        if (rowView.getColumn("pi_uuid", UUID.class) != null) {
            if (identifiable.getPreviewImage() != null) {
                return;
            }
            ImageFileResource previewImage = new ImageFileResource();
            previewImage.setUuid((UUID)rowView.getColumn("pi_uuid", UUID.class));
            previewImage.setLabel((LocalizedText)rowView.getColumn("pi_label", LocalizedText.class));
            previewImage.setFilename((String)rowView.getColumn("pi_filename", String.class));
            previewImage.setHttpBaseUrl((URL)rowView.getColumn("pi_httpBaseUrl", URL.class));
            previewImage.setMimeType((MimeType)rowView.getColumn("pi_mimeType", MimeType.class));
            previewImage.setUri((URI)rowView.getColumn("pi_uri", URI.class));
            identifiable.setPreviewImage(previewImage);
        }
    }

    private void setPreviewImageIdentifier(RowView rowView, I identifiable) {
        if (identifiable.getPreviewImage() == null) {
            return;
        }
        Set imageIdentifiers = (Set)rowView.getColumn("pi_identifiers", (GenericType)new SetOfIdentifiers());
        if (identifiable.getPreviewImage().getIdentifiers() != null && !identifiable.getPreviewImage().getIdentifiers().isEmpty() || imageIdentifiers == null) {
            return;
        }
        identifiable.getPreviewImage().setIdentifiers(imageIdentifiers);
    }

    public List<Entity> setRelatedEntities(UUID identifiableUuid, List<Entity> entities) throws RepositoryException {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM rel_identifiable_entities WHERE identifiable_uuid = :identifiableUuid").bind("identifiableUuid", identifiableUuid)).execute());
        int pageSize = 10;
        if (entities != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO rel_identifiable_entities(identifiable_uuid, entity_uuid, sortIndex) VALUES(:identifiableUuid, :entityUuid, :sortIndex)");
                for (Entity entity : entities) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("identifiableUuid", identifiableUuid)).bind("entityUuid", entity.getUuid())).bind("sortIndex", this.getIndex(entities, (UniqueObject)entity))).add();
                }
                preparedBatch.execute();
            });
            pageSize = entities.size();
        }
        return this.findRelatedEntities(identifiableUuid, new PageRequest(0, pageSize)).getContent();
    }

    public List<FileResource> setRelatedFileResources(UUID identifiableUuid, List<FileResource> fileResources) throws RepositoryException {
        if (fileResources == null) {
            return null;
        }
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM rel_identifiable_fileresources WHERE identifiable_uuid = :identifiableUuid").bind("identifiableUuid", identifiableUuid)).execute());
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO rel_entity_fileresources(identifiable_uuid, fileresource_uuid, sortIndex) VALUES(:identifiableUuid, :fileResourceUuid, :sortIndex)");
            for (FileResource fileResource : fileResources) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("identifiableUuid", identifiableUuid)).bind("fileResourceUuid", fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (UniqueObject)fileResource))).add();
            }
            preparedBatch.execute();
        });
        return this.findRelatedFileResources(identifiableUuid, new PageRequest(0, fileResources.size())).getContent();
    }

    private void setSubjectsFromRowView(RowView rowView, I identifiable) {
        UUID subjectUuid = (UUID)rowView.getColumn("subj_uuid", UUID.class);
        if (!(subjectUuid == null || identifiable.getSubjects() != null && identifiable.getSubjects().stream().anyMatch(subj -> Objects.equals(subj.getUuid(), subjectUuid)))) {
            Subject subject = (Subject)rowView.getRow(Subject.class);
            identifiable.addSubject(subject);
        }
    }

    private void setTagsFromRowView(RowView rowView, I identifiable) {
        Tag tag;
        if (rowView.getColumn("tags_uuid", UUID.class) != null && (tag = (Tag)rowView.getRow(Tag.class)) != null) {
            identifiable.addTag(tag);
        }
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        return switch (modelProperty) {
            case "label", "identifiers.id", "identifiers.namespace" -> true;
            default -> false;
        };
    }

    @Override
    public void update(I identifiable, Map<String, Object> bindings, BiFunction<String, Map<String, Object>, String> sqlModifier) throws RepositoryException {
        if (bindings == null) {
            bindings = new HashMap<String, Object>(0);
        }
        UUID previewImageUuid = identifiable.getPreviewImage() == null ? null : identifiable.getPreviewImage().getUuid();
        bindings.put("previewFileResource", previewImageUuid);
        bindings.put("split_label", this.splitToArray(identifiable.getLabel()));
        bindings.put("tags_uuids", this.extractUuids(identifiable.getTags()));
        bindings.put("subjects_uuids", this.extractUuids(identifiable.getSubjects()));
        Identifiable identifiableFromRepo = this.getByUuids(List.of(identifiable.getUuid())).stream().findFirst().orElse(null);
        super.update(identifiable, bindings, sqlModifier);
        try {
            Set existingIdentifiers = identifiableFromRepo.getIdentifiers();
            Set providedIdentifiers = identifiable.getIdentifiers();
            Set obsoleteIdentifiers = existingIdentifiers.stream().filter(i -> !providedIdentifiers.contains(i)).collect(Collectors.toSet());
            Set missingIdentifiers = providedIdentifiers.stream().filter(i -> !existingIdentifiers.contains(i)).collect(Collectors.toSet());
            if (!obsoleteIdentifiers.isEmpty()) {
                try {
                    this.identifierRepository.delete(obsoleteIdentifiers);
                }
                catch (RepositoryException e) {
                    throw new RepositoryException("Can not delete obsolete identifiers", (Throwable)e);
                }
            }
            if (!missingIdentifiers.isEmpty()) {
                providedIdentifiers.removeAll(missingIdentifiers);
                Set savedIdentifiers = this.identifierRepository.saveForIdentifiable(identifiable, missingIdentifiers);
                providedIdentifiers.addAll(savedIdentifiers);
            }
        }
        catch (RepositoryException e) {
            LOGGER.error(String.format("Cannot save Identifiers %s: %s for %s", identifiable.getIdentifiers(), e.getMessage(), identifiable), (Throwable)e);
            throw e;
        }
    }

    private static class SetOfIdentifiers
    extends GenericType<Set<Identifier>> {
        private SetOfIdentifiers() {
        }
    }
}

