/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.relation;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.relation.EntityToEntityRelationRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.relation.EntityToEntityRelationMapper;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.relation.EntityRelation;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class EntityToEntityRelationRepositoryImpl
extends JdbiRepositoryImpl
implements EntityToEntityRelationRepository {
    public static final String MAPPING_PREFIX = "rel";
    public static final String TABLE_ALIAS = "rel";
    public static final String TABLE_NAME = "rel_entity_entities";
    private final EntityToEntityRelationMapper<Entity> entityRelationMapper;
    private final EntityRepositoryImpl<Entity> entityRepositoryImpl;

    public EntityToEntityRelationRepositoryImpl(Jdbi dbi, @Qualifier(value="entityRepositoryImpl") EntityRepositoryImpl<Entity> entityRepositoryImpl, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, "rel", "rel", cudamiConfig.getOffsetForAlternativePaging());
        this.entityRepositoryImpl = entityRepositoryImpl;
        this.entityRelationMapper = new EntityToEntityRelationMapper<Entity>(entityRepositoryImpl);
    }

    public void addRelation(UUID subjectEntityUuid, String predicate, UUID objectEntityUuid) throws RepositoryException {
        this.save(subjectEntityUuid, predicate, objectEntityUuid);
    }

    public void deleteByObject(UUID objectEntityUuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE object_uuid = :uuid").bind("uuid", objectEntityUuid)).execute());
    }

    public void deleteBySubject(UUID subjectEntityUuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE subject_uuid = :uuid").bind("uuid", subjectEntityUuid)).execute());
    }

    public PageResponse<EntityRelation> find(PageRequest pageRequest) {
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias);
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder query = new StringBuilder("SELECT rel.subject_uuid rel_subject, rel.predicate rel_predicate, rel.object_uuid rel_object, rel.additional_predicates rel_addpredicates" + commonSql);
        if (pageRequest == null || !pageRequest.hasSorting()) {
            query.append(" ORDER BY rel.sortindex");
        }
        this.addPagingAndSorting(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query.toString()).bindMap(argumentMappings)).map(this.entityRelationMapper.getMapper(null)).list());
        String countQuery = "SELECT count(*)" + commonSql;
        long count = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(countQuery).bindMap(argumentMappings)).mapTo(Long.class).findOne().get());
        PageResponse pageResponse = new PageResponse(result, pageRequest, count);
        return pageResponse;
    }

    public PageResponse<EntityRelation> findBySubject(UUID subjectUuid, PageRequest pageRequest) throws RepositoryException {
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias + " WHERE subject_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", subjectUuid);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder query = new StringBuilder("SELECT rel.subject_uuid rel_subject, rel.predicate rel_predicate, rel.object_uuid rel_object, rel.additional_predicates rel_addpredicates" + commonSql);
        if (pageRequest.getSorting() == null) {
            query.append(" ORDER BY rel.sortindex");
        }
        this.addPagingAndSorting(pageRequest, query);
        List list = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(query.toString()).bindMap(argumentMappings)).bind("uuid", subjectUuid)).map(this.entityRelationMapper.getMapper(null)).list());
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        PageResponse pageResponse = new PageResponse(list, pageRequest, total);
        return pageResponse;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("subject", "predicate", "object"));
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "object": {
                return this.tableAlias + ".object_uuid";
            }
            case "predicate": {
                return this.tableAlias + ".predicate";
            }
            case "subject": {
                return this.tableAlias + ".subject_uuid";
            }
        }
        return null;
    }

    @Override
    protected String getUniqueField() {
        return null;
    }

    public void save(List<EntityRelation> entityRelations) throws RepositoryException {
        if (entityRelations == null) {
            return;
        }
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO " + this.tableName + "(subject_uuid, predicate, object_uuid, additional_predicates, sortindex) VALUES(:subjectUuid, :predicate, :objectUuid, :additional_predicates, :sortindex) ON CONFLICT (subject_uuid, predicate, object_uuid) DO UPDATE SET additional_predicates = EXCLUDED.additional_predicates, sortindex = EXCLUDED.sortindex");
            for (int i = 0; i < entityRelations.size(); ++i) {
                EntityRelation relation = (EntityRelation)entityRelations.get(i);
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("subjectUuid", relation.getSubject().getUuid())).bind("predicate", relation.getPredicate())).bind("objectUuid", relation.getObject().getUuid())).bindByType("additional_predicates", (Object)relation.getAdditionalPredicates(), (GenericType)new GenericType<List<String>>(){})).bind("sortindex", i)).add();
            }
            preparedBatch.execute();
        });
    }

    public void save(UUID subjectEntityUuid, String predicate, UUID objectEntityUuid) throws RepositoryException {
        Entity subject = new Entity();
        subject.setUuid(subjectEntityUuid);
        Entity object = new Entity();
        object.setUuid(objectEntityUuid);
        this.save(List.of(new EntityRelation(subject, predicate, object)));
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        return false;
    }
}

