/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.resource;

import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.cudami.model.api.identifiable.Identifiable;
import de.digitalcollections.cudami.model.api.identifiable.resource.Webpage;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.WebpageRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.WebpageService;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebpageServiceImpl
implements WebpageService<Webpage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageServiceImpl.class);
    @Autowired
    private WebpageRepository webpageRepository;

    @Override
    public long count() {
        return this.webpageRepository.count();
    }

    @Override
    public Webpage create() {
        return (Webpage)this.webpageRepository.create();
    }

    @Override
    public PageResponse<Webpage> find(PageRequest pageRequest) {
        return this.webpageRepository.find(pageRequest);
    }

    @Override
    public Webpage get(UUID uuid) {
        return (Webpage)this.webpageRepository.findOne(uuid);
    }

    @Override
    public Webpage save(Webpage webpage) throws IdentifiableServiceException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Webpage save(Webpage webpage, UUID websiteUuid) throws IdentifiableServiceException {
        try {
            return this.webpageRepository.save(webpage, websiteUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save webpage " + webpage + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public Webpage update(Webpage webpage) throws IdentifiableServiceException {
        try {
            return (Webpage)this.webpageRepository.update((Identifiable)webpage);
        }
        catch (Exception e) {
            LOGGER.error("Cannot update webpage " + webpage + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    public void setRepository(WebpageRepository webpageRepository) {
        this.webpageRepository = webpageRepository;
    }
}

