/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity;

import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.cudami.model.api.identifiable.Identifiable;
import de.digitalcollections.cudami.model.api.identifiable.entity.Website;
import de.digitalcollections.cudami.model.api.identifiable.resource.Webpage;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.WebsiteRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.WebsiteService;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebsiteServiceImpl
implements WebsiteService<Website> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsiteServiceImpl.class);
    @Autowired
    private WebsiteRepository websiteRepository;

    @Override
    public long count() {
        return this.websiteRepository.count();
    }

    @Override
    public Website create() {
        return (Website)this.websiteRepository.create();
    }

    @Override
    public PageResponse<Website> find(PageRequest pageRequest) {
        return this.websiteRepository.find(pageRequest);
    }

    @Override
    public Website get(UUID uuid) {
        return (Website)this.websiteRepository.findOne(uuid);
    }

    @Override
    public List<Webpage> getRootPages(Website website) {
        return this.websiteRepository.getRootPages(website);
    }

    @Override
    public Website save(Website website) throws IdentifiableServiceException {
        try {
            return (Website)this.websiteRepository.save((Identifiable)website);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save website " + website + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public Website update(Website website) throws IdentifiableServiceException {
        try {
            return (Website)this.websiteRepository.update((Identifiable)website);
        }
        catch (Exception e) {
            LOGGER.error("Cannot update website " + website + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    public void setRepository(WebsiteRepository websiteRepository) {
        this.websiteRepository = websiteRepository;
    }
}

