/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.validator;

import de.digitalcollections.cudami.model.api.security.User;
import de.digitalcollections.cudami.server.business.api.service.security.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class UniqueUsernameValidator
implements Validator {
    @Autowired
    UserService userService;

    public boolean supports(Class<?> clazz) {
        return User.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        User user = (User)target;
        try {
            Object existingUser = this.userService.loadUserByUsername(user.getEmail());
            if (existingUser != null) {
                errors.rejectValue("email", "error.username_already_exists");
            }
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
    }
}

