/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.ProjectRepository;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.ProjectService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.EntityServiceImpl;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.Project;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectServiceImpl
extends EntityServiceImpl<Project>
implements ProjectService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectServiceImpl.class);
    private final IdentifierRepository identifierRepository;

    @Autowired
    public ProjectServiceImpl(ProjectRepository repository, IdentifierRepository identifierRepository) {
        super(repository);
        this.identifierRepository = identifierRepository;
    }

    @Override
    public boolean addDigitalObject(Project project, DigitalObject digitalObject) {
        return ((ProjectRepository)this.repository).addDigitalObject(project, digitalObject);
    }

    @Override
    public boolean addDigitalObjects(Project project, List<DigitalObject> digitalObjects) {
        return ((ProjectRepository)this.repository).addDigitalObjects(project, digitalObjects);
    }

    @Override
    public PageResponse<DigitalObject> getDigitalObjects(Project project, PageRequest pageRequest) {
        return ((ProjectRepository)this.repository).getDigitalObjects(project, pageRequest);
    }

    @Override
    public boolean removeDigitalObject(Project project, DigitalObject digitalObject) {
        return ((ProjectRepository)this.repository).removeDigitalObject(project, digitalObject);
    }

    @Override
    public boolean saveDigitalObjects(Project project, List<DigitalObject> digitalObjects) {
        return ((ProjectRepository)this.repository).saveDigitalObjects(project, digitalObjects);
    }

    @Override
    public void delete(UUID uuid) {
        Project existingProject = (Project)this.get(uuid);
        Set identifiers = existingProject != null ? existingProject.getIdentifiers() : Collections.emptySet();
        ((ProjectRepository)this.repository).delete(uuid);
        for (Identifier identifier : identifiers) {
            this.identifierRepository.delete(identifier.getUuid());
        }
    }

    @Override
    public List<Project> getAll() {
        return ((ProjectRepository)this.repository).getAll();
    }

    @Override
    public boolean removeDigitalObjectFromAllProjects(DigitalObject digitalObject) {
        if (digitalObject == null) {
            return false;
        }
        return ((ProjectRepository)this.repository).removeDigitalObjectFromAllProjects(digitalObject.getUuid());
    }
}

