/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.CollectionRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.CollectionService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.EntityServiceImpl;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.entity.Collection;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CollectionServiceImpl
extends EntityServiceImpl<Collection>
implements CollectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionServiceImpl.class);

    @Autowired
    public CollectionServiceImpl(CollectionRepository repository) {
        super(repository);
    }

    @Override
    public boolean addChild(Collection parent, Collection child) {
        return ((CollectionRepository)this.repository).addChild(parent, child);
    }

    @Override
    public boolean addChildren(Collection parent, List<Collection> children) {
        return ((CollectionRepository)this.repository).addChildren(parent, children);
    }

    @Override
    public boolean addDigitalObject(Collection collection, DigitalObject digitalObject) {
        return ((CollectionRepository)this.repository).addDigitalObject(collection, digitalObject);
    }

    @Override
    public boolean addDigitalObjects(Collection collection, List<DigitalObject> digitalObjects) {
        return ((CollectionRepository)this.repository).addDigitalObjects(collection, digitalObjects);
    }

    @Override
    public PageResponse<Collection> findActive(PageRequest pageRequest) {
        Filtering filtering = this.filteringForActive();
        pageRequest.add(filtering);
        return this.find(pageRequest);
    }

    @Override
    public SearchPageResponse<Collection> findActive(SearchPageRequest pageRequest) {
        Filtering filtering = this.filteringForActive();
        pageRequest.add(filtering);
        return this.find(pageRequest);
    }

    @Override
    public Collection getActive(UUID uuid) {
        Filtering filtering = this.filteringForActive();
        Collection collection = ((CollectionRepository)this.repository).findOne(uuid, filtering);
        if (collection != null) {
            collection.setChildren(this.getActiveChildren(uuid));
        }
        return collection;
    }

    @Override
    public Collection getActive(UUID uuid, Locale pLocale) {
        Collection collection = this.getActive(uuid);
        return this.reduceMultilanguageFieldsToGivenLocale(collection, pLocale);
    }

    @Override
    public List<Collection> getActiveChildren(UUID uuid) {
        Filtering filtering = this.filteringForActive();
        PageRequestImpl pageRequest = new PageRequestImpl();
        pageRequest.add(filtering);
        return this.getChildren(uuid, (PageRequest)pageRequest).getContent();
    }

    @Override
    public PageResponse<Collection> getActiveChildren(UUID uuid, PageRequest pageRequest) {
        Filtering filtering = this.filteringForActive();
        pageRequest.add(filtering);
        return this.getChildren(uuid, pageRequest);
    }

    @Override
    public BreadcrumbNavigation getBreadcrumbNavigation(UUID nodeUuid) {
        return ((NodeRepository)this.repository).getBreadcrumbNavigation(nodeUuid);
    }

    @Override
    public List<Collection> getChildren(Collection collection) {
        return ((NodeRepository)this.repository).getChildren((Node)collection);
    }

    @Override
    public List<Collection> getChildren(UUID uuid) {
        return ((NodeRepository)this.repository).getChildren(uuid);
    }

    @Override
    public PageResponse<Collection> getChildren(UUID uuid, PageRequest pageRequest) {
        return ((NodeRepository)this.repository).getChildren(uuid, pageRequest);
    }

    @Override
    public PageResponse<DigitalObject> getDigitalObjects(Collection collection, PageRequest pageRequest) {
        return ((CollectionRepository)this.repository).getDigitalObjects(collection, pageRequest);
    }

    @Override
    public Collection getParent(Collection node) {
        return this.getParent(node.getUuid());
    }

    @Override
    public Collection getParent(UUID nodeUuid) {
        return (Collection)((NodeRepository)this.repository).getParent(nodeUuid);
    }

    @Override
    public List<Collection> getParents(UUID uuid) {
        return ((CollectionRepository)this.repository).getParents(uuid);
    }

    @Override
    public List<CorporateBody> getRelatedCorporateBodies(UUID uuid, Filtering filtering) {
        return ((CollectionRepository)this.repository).getRelatedCorporateBodies(uuid, filtering);
    }

    @Override
    public PageResponse<Collection> getTopCollections(PageRequest pageRequest) {
        return ((CollectionRepository)this.repository).getTopCollections(pageRequest);
    }

    @Override
    public boolean removeChild(Collection parent, Collection child) {
        return ((CollectionRepository)this.repository).removeChild(parent, child);
    }

    @Override
    public boolean removeDigitalObject(Collection collection, DigitalObject digitalObject) {
        return ((CollectionRepository)this.repository).removeDigitalObject(collection, digitalObject);
    }

    @Override
    public boolean removeDigitalObjectFromAllCollections(DigitalObject digitalObject) {
        return ((CollectionRepository)this.repository).removeDigitalObjectFromAllCollections(digitalObject);
    }

    @Override
    public boolean saveDigitalObjects(Collection collection, List<DigitalObject> digitalObjects) {
        return ((CollectionRepository)this.repository).saveDigitalObjects(collection, digitalObjects);
    }

    @Override
    public Collection saveWithParentCollection(Collection collection, UUID parentUuid) throws IdentifiableServiceException {
        try {
            return ((CollectionRepository)this.repository).saveWithParentCollection(collection, parentUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save collection " + collection + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }
}

