/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifiableService;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.Order;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.paging.Sorting;
import de.digitalcollections.model.text.LocalizedText;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="identifiableService")
public class IdentifiableServiceImpl<I extends Identifiable>
implements IdentifiableService<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiableServiceImpl.class);
    @Autowired
    private LocaleService localeService;
    protected IdentifiableRepository<I> repository;

    @Autowired
    public IdentifiableServiceImpl(@Qualifier(value="identifiableRepositoryImpl") IdentifiableRepository<I> repository) {
        this.repository = repository;
    }

    @Override
    public void addRelatedEntity(UUID identifiableUuid, UUID entityUuid) {
        this.repository.addRelatedEntity(identifiableUuid, entityUuid);
    }

    @Override
    public void addRelatedFileresource(UUID identifiableUuid, UUID fileResourceUuid) {
        this.repository.addRelatedFileresource(identifiableUuid, fileResourceUuid);
    }

    @Override
    public long count() {
        return this.repository.count();
    }

    @Override
    public boolean delete(List<UUID> uuids) {
        return this.repository.delete(uuids);
    }

    @Override
    public PageResponse<I> find(PageRequest pageRequest) {
        this.setDefaultSorting(pageRequest);
        return this.repository.find(pageRequest);
    }

    @Override
    public SearchPageResponse<I> find(SearchPageRequest searchPageRequest) {
        this.setDefaultSorting((PageRequest)searchPageRequest);
        return this.repository.find(searchPageRequest);
    }

    @Override
    public List<I> find(String searchTerm, int maxResults) {
        return this.repository.find(searchTerm, maxResults);
    }

    @Override
    public List<I> findAllFull() {
        return this.repository.findAllFull();
    }

    @Override
    public List<I> findAllReduced() {
        return this.repository.findAllReduced();
    }

    @Override
    public PageResponse<I> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) {
        PageResponse result = this.repository.findByLanguageAndInitial(pageRequest, language, initial);
        return result;
    }

    @Override
    public I get(Identifier identifier) {
        return (I)this.repository.findOne(identifier);
    }

    @Override
    public I get(UUID uuid) {
        return (I)this.repository.findOne(uuid);
    }

    @Override
    public I get(UUID uuid, Locale locale) throws IdentifiableServiceException {
        I identifiable = this.get(uuid);
        return this.reduceMultilanguageFieldsToGivenLocale(identifiable, locale);
    }

    @Override
    public I getByIdentifier(String namespace, String id) {
        return (I)this.repository.findOneByIdentifier(namespace, id);
    }

    @Override
    public List<Locale> getLanguages() {
        return this.repository.getLanguages();
    }

    @Override
    public List<Entity> getRelatedEntities(UUID identifiableUuid) {
        return this.repository.getRelatedEntities(identifiableUuid);
    }

    @Override
    public List<FileResource> getRelatedFileResources(UUID identifiableUuid) {
        return this.repository.getRelatedFileResources(identifiableUuid);
    }

    protected I reduceMultilanguageFieldsToGivenLocale(I identifiable, Locale locale) {
        if (identifiable == null) {
            return null;
        }
        LocalizedText label = identifiable.getLabel();
        if (!(label.containsKey((Object)locale) && locale != null || label.containsKey((Object)(locale = new Locale(this.localeService.getDefaultLanguage()))))) {
            locale = (Locale)label.getLocales().iterator().next();
        }
        if (locale == null) {
            return null;
        }
        Locale fLocale = locale;
        label.entrySet().removeIf(entry -> !((Locale)entry.getKey()).equals(fLocale));
        if (identifiable.getDescription() != null) {
            identifiable.getDescription().entrySet().removeIf(entry -> !((Locale)entry.getKey()).equals(fLocale));
        }
        return identifiable;
    }

    @Override
    public I save(I identifiable) throws IdentifiableServiceException {
        try {
            return (I)this.repository.save(identifiable);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save identifiable " + identifiable + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public List<Entity> saveRelatedEntities(UUID identifiableUuid, List<Entity> entities) {
        return this.repository.saveRelatedEntities(identifiableUuid, entities);
    }

    @Override
    public List<FileResource> saveRelatedFileResources(UUID identifiableUuid, List<FileResource> fileResources) {
        return this.repository.saveRelatedFileResources(identifiableUuid, fileResources);
    }

    protected void setDefaultSorting(PageRequest pageRequest) {
        if (!pageRequest.hasSorting()) {
            String defaultLanguage = this.localeService.getDefaultLanguage();
            Order labelOrder1 = new Order(Direction.ASC, "label");
            labelOrder1.setSubProperty(defaultLanguage);
            Order labelOrder2 = new Order(Direction.ASC, "label");
            labelOrder2.setSubProperty("");
            Sorting sorting = Sorting.defaultBuilder().order(labelOrder1).order(labelOrder2).build();
            pageRequest.setSorting(sorting);
        }
    }

    @Override
    public I update(I identifiable) throws IdentifiableServiceException {
        try {
            return (I)this.repository.update(identifiable);
        }
        catch (Exception e) {
            LOGGER.error("Cannot update identifiable " + identifiable + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }
}

