/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.web;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.web.WebpageRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.web.WebpageService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.IdentifiableServiceImpl;
import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebpageServiceImpl
extends IdentifiableServiceImpl<Webpage>
implements WebpageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageServiceImpl.class);

    @Autowired
    public WebpageServiceImpl(WebpageRepository repository) {
        super(repository);
    }

    @Override
    public boolean addChildren(UUID parentUuid, List<UUID> childrenUuids) {
        return ((NodeRepository)this.repository).addChildren(parentUuid, childrenUuids);
    }

    @Override
    public SearchPageResponse<Webpage> findActiveChildren(UUID uuid, SearchPageRequest searchPageRequest) {
        Filtering filtering = this.filteringForActive();
        searchPageRequest.add(filtering);
        return this.findChildren(uuid, searchPageRequest);
    }

    @Override
    public SearchPageResponse<Webpage> findChildren(UUID uuid, SearchPageRequest searchPageRequest) {
        return ((NodeRepository)this.repository).findChildren(uuid, searchPageRequest);
    }

    @Override
    public Webpage getActive(UUID uuid) {
        Filtering filtering = this.filteringForActive();
        Webpage webpage = (Webpage)((WebpageRepository)this.repository).findOne(uuid, filtering);
        if (webpage != null) {
            webpage.setChildren(this.getActiveChildren(uuid));
        }
        return webpage;
    }

    @Override
    public Webpage getActive(UUID uuid, Locale pLocale) {
        Webpage webpage = this.getActive(uuid);
        return this.reduceMultilanguageFieldsToGivenLocale(webpage, pLocale);
    }

    @Override
    public List<Webpage> getActiveChildren(UUID uuid) {
        Filtering filtering = this.filteringForActive();
        PageRequest pageRequest = new PageRequest();
        pageRequest.add(filtering);
        return this.getChildren(uuid, pageRequest).getContent();
    }

    @Override
    public List<Webpage> getActiveChildrenTree(UUID uuid) {
        List<Webpage> webpages = this.getActiveChildren(uuid);
        return webpages.stream().peek(w -> w.setChildren(this.getActiveChildrenTree(w.getUuid()))).collect(Collectors.toList());
    }

    @Override
    public PageResponse<Webpage> getActiveChildren(UUID uuid, PageRequest pageRequest) {
        Filtering filtering = this.filteringForActive();
        pageRequest.add(filtering);
        return this.getChildren(uuid, pageRequest);
    }

    @Override
    public List<Webpage> getChildrenTree(UUID uuid) {
        List<Webpage> webpages = this.getChildren(uuid);
        return webpages.stream().peek(w -> w.setChildren(this.getChildrenTree(w.getUuid()))).collect(Collectors.toList());
    }

    @Override
    public BreadcrumbNavigation getBreadcrumbNavigation(UUID uuid) {
        return ((NodeRepository)this.repository).getBreadcrumbNavigation(uuid);
    }

    @Override
    public List<Webpage> getChildren(Webpage webpage) {
        return ((NodeRepository)this.repository).getChildren((Identifiable)webpage);
    }

    @Override
    public List<Webpage> getChildren(UUID uuid) {
        return ((NodeRepository)this.repository).getChildren(uuid);
    }

    @Override
    public PageResponse<Webpage> getChildren(UUID uuid, PageRequest pageRequest) {
        return ((NodeRepository)this.repository).getChildren(uuid, pageRequest);
    }

    @Override
    public Webpage getParent(UUID webpageUuid) {
        return (Webpage)((NodeRepository)this.repository).getParent(webpageUuid);
    }

    @Override
    public List<Webpage> getParents(UUID uuid) {
        return ((NodeRepository)this.repository).getParents(uuid);
    }

    @Override
    public PageResponse<Webpage> getRootNodes(PageRequest pageRequest) {
        return ((NodeRepository)this.repository).getRootNodes(pageRequest);
    }

    @Override
    public List<Locale> getRootNodesLanguages() {
        return ((NodeRepository)this.repository).getRootNodesLanguages();
    }

    @Override
    public Website getWebsite(UUID webpageUuid) {
        UUID rootWebpageUuid = webpageUuid;
        Webpage parent = this.getParent(webpageUuid);
        while (parent != null) {
            rootWebpageUuid = parent.getUuid();
            parent = this.getParent(parent);
        }
        return ((WebpageRepository)this.repository).getWebsite(rootWebpageUuid);
    }

    @Override
    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        return ((NodeRepository)this.repository).removeChild(parentUuid, childUuid);
    }

    @Override
    public Webpage saveWithParent(Webpage child, UUID parentUuid) throws IdentifiableServiceException {
        try {
            return (Webpage)((NodeRepository)this.repository).saveWithParent((Identifiable)child, parentUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save webpage " + child + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public Webpage saveWithParentWebsite(Webpage webpage, UUID parentWebsiteUuid) throws IdentifiableServiceException {
        try {
            return ((WebpageRepository)this.repository).saveWithParentWebsite(webpage, parentWebsiteUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save top-level webpage " + webpage + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public boolean updateChildrenOrder(UUID parentUuid, List<Webpage> children) {
        return ((NodeRepository)this.repository).updateChildrenOrder(parentUuid, children);
    }

    @Override
    public SearchPageResponse<Webpage> findRootNodes(SearchPageRequest searchPageRequest) {
        return ((NodeRepository)this.repository).findRootNodes(searchPageRequest);
    }
}

