/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.CollectionRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.CollectionService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.EntityServiceImpl;
import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CollectionServiceImpl
extends EntityServiceImpl<Collection>
implements CollectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionServiceImpl.class);

    @Autowired
    public CollectionServiceImpl(CollectionRepository repository) {
        super(repository);
    }

    @Override
    public boolean addChildren(UUID parentUuid, List<UUID> childrenUuids) {
        return ((NodeRepository)this.repository).addChildren(parentUuid, childrenUuids);
    }

    @Override
    public boolean addDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) {
        return ((CollectionRepository)this.repository).addDigitalObjects(collectionUuid, digitalObjects);
    }

    @Override
    public PageResponse<Collection> findActive(PageRequest pageRequest) {
        Filtering filtering = this.filteringForActive();
        pageRequest.add(filtering);
        return this.find(pageRequest);
    }

    @Override
    public SearchPageResponse<Collection> findActive(SearchPageRequest pageRequest) {
        Filtering filtering = this.filteringForActive();
        pageRequest.add(filtering);
        return this.find(pageRequest);
    }

    @Override
    public SearchPageResponse<Collection> findActiveChildren(UUID uuid, SearchPageRequest searchPageRequest) {
        Filtering filtering = this.filteringForActive();
        searchPageRequest.add(filtering);
        return this.findChildren(uuid, searchPageRequest);
    }

    @Override
    public SearchPageResponse<Collection> findChildren(UUID nodeUuid, SearchPageRequest searchPageRequest) {
        return ((NodeRepository)this.repository).findChildren(nodeUuid, searchPageRequest);
    }

    @Override
    public Collection getActive(UUID uuid) {
        Filtering filtering = this.filteringForActive();
        Collection collection = (Collection)((CollectionRepository)this.repository).findOne(uuid, filtering);
        if (collection != null) {
            collection.setChildren(this.getActiveChildren(uuid));
        }
        return collection;
    }

    @Override
    public Collection getActive(UUID uuid, Locale pLocale) {
        Collection collection = this.getActive(uuid);
        return this.reduceMultilanguageFieldsToGivenLocale(collection, pLocale);
    }

    @Override
    public List<Collection> getActiveChildren(UUID uuid) {
        Filtering filtering = this.filteringForActive();
        PageRequest pageRequest = new PageRequest();
        pageRequest.add(filtering);
        return this.getChildren(uuid, pageRequest).getContent();
    }

    @Override
    public PageResponse<Collection> getActiveChildren(UUID uuid, PageRequest pageRequest) {
        Filtering filtering = this.filteringForActive();
        pageRequest.add(filtering);
        return this.getChildren(uuid, pageRequest);
    }

    @Override
    public BreadcrumbNavigation getBreadcrumbNavigation(UUID nodeUuid) {
        return ((NodeRepository)this.repository).getBreadcrumbNavigation(nodeUuid);
    }

    @Override
    public List<Collection> getChildren(UUID nodeUuid) {
        return ((NodeRepository)this.repository).getChildren(nodeUuid);
    }

    @Override
    public PageResponse<Collection> getChildren(UUID nodeUuid, PageRequest pageRequest) {
        return ((NodeRepository)this.repository).getChildren(nodeUuid, pageRequest);
    }

    @Override
    public SearchPageResponse<DigitalObject> getDigitalObjects(UUID collectionUuid, SearchPageRequest searchPageRequest) {
        return ((CollectionRepository)this.repository).getDigitalObjects(collectionUuid, searchPageRequest);
    }

    @Override
    public Collection getParent(UUID nodeUuid) {
        return (Collection)((NodeRepository)this.repository).getParent(nodeUuid);
    }

    @Override
    public List<Collection> getParents(UUID uuid) {
        return ((CollectionRepository)this.repository).getParents(uuid);
    }

    @Override
    public List<CorporateBody> getRelatedCorporateBodies(UUID uuid, Filtering filtering) {
        return ((CollectionRepository)this.repository).getRelatedCorporateBodies(uuid, filtering);
    }

    @Override
    public PageResponse<Collection> getRootNodes(PageRequest pageRequest) {
        this.setDefaultSorting(pageRequest);
        return ((NodeRepository)this.repository).getRootNodes(pageRequest);
    }

    @Override
    public SearchPageResponse<Collection> findRootNodes(SearchPageRequest searchPageRequest) {
        this.setDefaultSorting((PageRequest)searchPageRequest);
        return ((NodeRepository)this.repository).findRootNodes(searchPageRequest);
    }

    @Override
    public List<Locale> getRootNodesLanguages() {
        return ((NodeRepository)this.repository).getRootNodesLanguages();
    }

    @Override
    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        return ((NodeRepository)this.repository).removeChild(parentUuid, childUuid);
    }

    @Override
    public boolean removeDigitalObject(UUID collectionUuid, UUID digitalObjectUuid) {
        return ((CollectionRepository)this.repository).removeDigitalObject(collectionUuid, digitalObjectUuid);
    }

    @Override
    public boolean removeDigitalObjectFromAllCollections(DigitalObject digitalObject) {
        return ((CollectionRepository)this.repository).removeDigitalObjectFromAllCollections(digitalObject);
    }

    @Override
    public boolean saveDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) {
        return ((CollectionRepository)this.repository).saveDigitalObjects(collectionUuid, digitalObjects);
    }

    @Override
    public Collection saveWithParent(Collection child, UUID parentUuid) throws IdentifiableServiceException {
        try {
            return (Collection)((CollectionRepository)this.repository).saveWithParent((Identifiable)child, parentUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save collection " + child + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public boolean updateChildrenOrder(UUID parentUuid, List<Collection> children) {
        return ((NodeRepository)this.repository).updateChildrenOrder(parentUuid, children);
    }
}

