/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.api.service.semantic;

import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.semantic.Headword;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface HeadwordService {
    default public void addRelatedEntity(Headword headword, Entity entity) {
        if (headword == null || entity == null) {
            return;
        }
        this.addRelatedEntity(headword.getUuid(), entity.getUuid());
    }

    public void addRelatedEntity(UUID var1, UUID var2);

    default public void addRelatedFileresource(Headword headword, FileResource fileResource) {
        if (headword == null || fileResource == null) {
            return;
        }
        this.addRelatedFileresource(headword.getUuid(), fileResource.getUuid());
    }

    public void addRelatedFileresource(UUID var1, UUID var2);

    public long count();

    default public boolean delete(UUID uuid) {
        return this.delete(List.of(uuid));
    }

    public boolean delete(List<UUID> var1);

    public PageResponse<Headword> find(PageRequest var1);

    public SearchPageResponse<Headword> find(SearchPageRequest var1);

    public List<Headword> find(String var1, int var2);

    public List<Headword> findAll();

    public PageResponse<Headword> findByLanguageAndInitial(PageRequest var1, String var2, String var3);

    public Headword get(UUID var1);

    public List<Headword> get(String var1, Locale var2);

    public List<Locale> getLanguages();

    public List<Headword> getRandom(int var1);

    default public List<Entity> getRelatedEntities(Headword headword) {
        if (headword == null) {
            return null;
        }
        return this.getRelatedEntities(headword.getUuid());
    }

    public List<Entity> getRelatedEntities(UUID var1);

    public PageResponse<Entity> getRelatedEntities(UUID var1, PageRequest var2);

    default public List<FileResource> getRelatedFileResources(Headword headword) {
        if (headword == null) {
            return null;
        }
        return this.getRelatedFileResources(headword.getUuid());
    }

    public List<FileResource> getRelatedFileResources(UUID var1);

    public PageResponse<FileResource> getRelatedFileResources(UUID var1, PageRequest var2);

    public Headword save(Headword var1) throws ServiceException;

    default public List<Entity> saveRelatedEntities(Headword headword, List<Entity> entities) {
        if (headword == null || entities == null) {
            return null;
        }
        return this.saveRelatedEntities(headword.getUuid(), entities);
    }

    public List<Entity> saveRelatedEntities(UUID var1, List<Entity> var2);

    default public List<FileResource> saveRelatedFileResources(Headword headword, List<FileResource> fileResources) {
        if (headword == null || fileResources == null) {
            return null;
        }
        return this.saveRelatedFileResources(headword.getUuid(), fileResources);
    }

    public List<FileResource> saveRelatedFileResources(UUID var1, List<FileResource> var2);

    public Headword update(Headword var1) throws ServiceException;
}

