/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.api.service.identifiable;

import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.text.LocalizedText;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface IdentifiableService<I extends Identifiable> {
    default public void addRelatedEntity(I identifiable, Entity entity) {
        if (identifiable == null || entity == null) {
            return;
        }
        this.addRelatedEntity(identifiable.getUuid(), entity.getUuid());
    }

    public void addRelatedEntity(UUID var1, UUID var2);

    default public void addRelatedFileresource(I identifiable, FileResource fileResource) {
        if (identifiable == null || fileResource == null) {
            return;
        }
        this.addRelatedFileresource(identifiable.getUuid(), fileResource.getUuid());
    }

    public void addRelatedFileresource(UUID var1, UUID var2);

    default public void cleanupLabelFromUnwantedLocales(Locale locale, Locale fallbackLocale, LocalizedText label) {
        if (label == null || label.getLocales() == null || label.getLocales().isEmpty()) {
            return;
        }
        String defaultLabel = null;
        if (label.getLocales().contains(fallbackLocale)) {
            defaultLabel = label.getText(fallbackLocale);
        }
        Locale firstLocale = (Locale)label.getLocales().get(0);
        String firstLocaleLabel = label.getText(firstLocale);
        label.entrySet().removeIf(e -> e.getKey() != locale);
        if (label.keySet().isEmpty()) {
            if (defaultLabel != null) {
                label.put((Object)fallbackLocale, (Object)defaultLabel);
            } else if (firstLocale != null) {
                label.put((Object)firstLocale, (Object)firstLocaleLabel);
            }
        }
    }

    public long count();

    default public boolean delete(UUID uuid) throws IdentifiableServiceException {
        return this.delete(List.of(uuid));
    }

    public boolean delete(List<UUID> var1) throws IdentifiableServiceException;

    public boolean deleteIdentifiers(UUID var1);

    public PageResponse<I> find(PageRequest var1);

    public SearchPageResponse<I> find(SearchPageRequest var1);

    public List<I> find(String var1, int var2);

    public List<I> findAllFull();

    public List<I> findAllReduced();

    public PageResponse<I> findByLanguageAndInitial(PageRequest var1, String var2, String var3);

    public I get(Identifier var1);

    public I get(UUID var1);

    public I get(UUID var1, Locale var2) throws IdentifiableServiceException;

    public I getByIdentifier(String var1, String var2);

    public List<Locale> getLanguages();

    default public List<Entity> getRelatedEntities(I identifiable) {
        if (identifiable == null) {
            return null;
        }
        return this.getRelatedEntities(identifiable.getUuid());
    }

    public List<Entity> getRelatedEntities(UUID var1);

    default public List<FileResource> getRelatedFileResources(I identifiable) {
        if (identifiable == null) {
            return null;
        }
        return this.getRelatedFileResources(identifiable.getUuid());
    }

    public List<FileResource> getRelatedFileResources(UUID var1);

    public I save(I var1) throws IdentifiableServiceException, ValidationException;

    default public List<Entity> saveRelatedEntities(I identifiable, List<Entity> entities) {
        if (identifiable == null || entities == null) {
            return null;
        }
        return this.saveRelatedEntities(identifiable.getUuid(), entities);
    }

    public List<Entity> saveRelatedEntities(UUID var1, List<Entity> var2);

    default public List<FileResource> saveRelatedFileResources(I identifiable, List<FileResource> fileResources) {
        if (identifiable == null || fileResources == null) {
            return null;
        }
        return this.saveRelatedFileResources(identifiable.getUuid(), fileResources);
    }

    public List<FileResource> saveRelatedFileResources(UUID var1, List<FileResource> var2);

    public I update(I var1) throws IdentifiableServiceException, ValidationException;
}

