/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.semantic;

import de.digitalcollections.cudami.server.backend.api.repository.semantic.HeadwordRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.semantic.HeadwordService;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.paging.Sorting;
import de.digitalcollections.model.semantic.Headword;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HeadwordServiceImpl
implements HeadwordService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadwordServiceImpl.class);
    private final HeadwordRepository repository;

    public HeadwordServiceImpl(HeadwordRepository repository) {
        this.repository = repository;
    }

    @Override
    public void addRelatedEntity(UUID headwordUuid, UUID entityUuid) {
        this.repository.addRelatedEntity(headwordUuid, entityUuid);
    }

    @Override
    public void addRelatedFileresource(UUID headwordUuid, UUID fileResourceUuid) {
        this.repository.addRelatedFileresource(headwordUuid, fileResourceUuid);
    }

    @Override
    public long count() {
        return this.repository.count();
    }

    @Override
    public boolean delete(List<UUID> uuids) {
        return this.repository.delete(uuids);
    }

    @Override
    public PageResponse<Headword> find(PageRequest pageRequest) {
        this.setDefaultSorting(pageRequest);
        return this.repository.find(pageRequest);
    }

    @Override
    public SearchPageResponse<Headword> find(SearchPageRequest searchPageRequest) {
        this.setDefaultSorting((PageRequest)searchPageRequest);
        return this.repository.find(searchPageRequest);
    }

    @Override
    public List<Headword> find(String searchTerm, int maxResults) {
        return this.repository.find(searchTerm, maxResults);
    }

    @Override
    public List<Headword> findAll() {
        return this.repository.findAll();
    }

    @Override
    public PageResponse<Headword> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) {
        PageResponse result = this.repository.findByLanguageAndInitial(pageRequest, language, initial);
        return result;
    }

    @Override
    public Headword get(UUID uuid) {
        return this.repository.findOne(uuid);
    }

    @Override
    public List<Headword> get(String label, Locale locale) {
        return this.repository.find(label, locale);
    }

    @Override
    public List<Locale> getLanguages() {
        return this.repository.getLanguages();
    }

    @Override
    public List<Headword> getRandom(int count) {
        return this.repository.findRandom(count);
    }

    @Override
    public List<Entity> getRelatedEntities(UUID headwordUuid) {
        return this.repository.getRelatedEntities(headwordUuid);
    }

    @Override
    public PageResponse<Entity> getRelatedEntities(UUID headwordUuid, PageRequest pageRequest) {
        return this.repository.getRelatedEntities(headwordUuid, pageRequest);
    }

    @Override
    public List<FileResource> getRelatedFileResources(UUID headwordUuid) {
        return this.repository.getRelatedFileResources(headwordUuid);
    }

    @Override
    public PageResponse<FileResource> getRelatedFileResources(UUID headwordUuid, PageRequest pageRequest) {
        return this.repository.getRelatedFileResources(headwordUuid, pageRequest);
    }

    @Override
    public Headword save(Headword headword) throws ServiceException {
        try {
            return this.repository.save(headword);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save headword " + headword.getLabel() + ": ", (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }

    @Override
    public List<Entity> saveRelatedEntities(UUID headwordUuid, List<Entity> entities) {
        return this.repository.saveRelatedEntities(headwordUuid, entities);
    }

    @Override
    public List<FileResource> saveRelatedFileResources(UUID headwordUuid, List<FileResource> fileResources) {
        return this.repository.saveRelatedFileResources(headwordUuid, fileResources);
    }

    protected void setDefaultSorting(PageRequest pageRequest) {
        if (!pageRequest.hasSorting()) {
            Sorting sorting = new Sorting(Direction.ASC, new String[]{"label", "uuid"});
            pageRequest.setSorting(sorting);
        }
    }

    @Override
    public Headword update(Headword headword) throws ServiceException {
        try {
            return this.repository.update(headword);
        }
        catch (Exception e) {
            LOGGER.error("Cannot update headword " + headword + ": ", (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }
}

