/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.business.api.service.exceptions.CudamiServiceException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class IdentifiableUrlAliasAlignHelper<I extends Identifiable> {
    private CudamiConfig cudamiConfig;
    private SlugGeneratorService slugGeneratorService;
    private I identifiableInDatabase;
    private I actualIdentifiable;

    private IdentifiableUrlAliasAlignHelper(I actualIdentifiable, I identifiableInDatabase, CudamiConfig cudamiConfig, SlugGeneratorService slugGeneratorService) {
        this.actualIdentifiable = actualIdentifiable;
        this.identifiableInDatabase = identifiableInDatabase;
        this.cudamiConfig = cudamiConfig;
        this.slugGeneratorService = slugGeneratorService;
    }

    public static <I extends Identifiable> void alignForUpdate(I actualIdentifiable, I identifiableInDatabase, CudamiConfig cudamiConfig, SlugGeneratorService slugGeneratorService) throws CudamiServiceException {
        if (actualIdentifiable == null || identifiableInDatabase == null || cudamiConfig == null || slugGeneratorService == null) {
            throw new CudamiServiceException("Missing argument. Every parameter must be passed (not null).");
        }
        IdentifiableUrlAliasAlignHelper<I> inst = new IdentifiableUrlAliasAlignHelper<I>(actualIdentifiable, identifiableInDatabase, cudamiConfig, slugGeneratorService);
        try {
            inst.fixMissingLocalizedUrlAliases();
            inst.alignLabelUpdate();
            inst.ensureDefaultAliasesExist();
        }
        catch (RuntimeException e) {
            throw new CudamiServiceException("Uncaught error in IdentifiableUrlAliasAlignHelper::alignForUpdate.", e);
        }
    }

    public static <I extends Identifiable> void checkDefaultAliases(I actualIdentifiable, CudamiConfig cudamiConfig, SlugGeneratorService slugGeneratorService) throws CudamiServiceException {
        if (actualIdentifiable == null || cudamiConfig == null || slugGeneratorService == null) {
            throw new CudamiServiceException("Missing argument. Every parameter must be passed (not null).");
        }
        IdentifiableUrlAliasAlignHelper<Object> inst = new IdentifiableUrlAliasAlignHelper<Object>(actualIdentifiable, null, cudamiConfig, slugGeneratorService);
        try {
            inst.ensureDefaultAliasesExist();
        }
        catch (RuntimeException e) {
            throw new CudamiServiceException("Uncaught error in IdentifiableUrlAliasAlignHelper::checkDefaultAliases.", e);
        }
    }

    private void alignLabelUpdate() throws CudamiServiceException {
        if (this.actualIdentifiable == null || this.actualIdentifiable instanceof Entity && this.cudamiConfig.getUrlAlias().getGenerationExcludes().contains(((Entity)this.actualIdentifiable).getEntityType()) || this.actualIdentifiable.getLabel() == null) {
            return;
        }
        if (this.identifiableInDatabase == null) {
            return;
        }
        for (Locale langFromDb : this.identifiableInDatabase.getLabel().getLocales()) {
            String labelInIdentifiable;
            String labelSavedInDb = (String)this.identifiableInDatabase.getLabel().get((Object)langFromDb);
            if (Objects.equals(labelSavedInDb, labelInIdentifiable = (String)this.actualIdentifiable.getLabel().get((Object)langFromDb)) || labelInIdentifiable == null) continue;
            List<UrlAlias> primariesFromDb = this.getPrimaryUrlAliases(this.identifiableInDatabase.getLocalizedUrlAliases(), langFromDb);
            if (this.actualIdentifiable.getLocalizedUrlAliases() == null) {
                this.actualIdentifiable.setLocalizedUrlAliases(new LocalizedUrlAliases());
            }
            for (UrlAlias primaryFromDb : primariesFromDb) {
                UUID websiteUuid = primaryFromDb.getWebsite() != null ? primaryFromDb.getWebsite().getUuid() : null;
                String newSlug = this.slugGeneratorService.apply(langFromDb, labelInIdentifiable, websiteUuid);
                if (this.actualIdentifiable.getLocalizedUrlAliases().flatten().stream().anyMatch(ua -> Objects.equals(ua.getSlug(), newSlug) && Objects.equals(ua.getTargetLanguage(), langFromDb) && Objects.equals(ua.getWebsite() != null ? ua.getWebsite().getUuid() : null, websiteUuid))) continue;
                UrlAlias newAlias = new UrlAlias();
                newAlias.setSlug(newSlug);
                newAlias.setTargetIdentifiableType(this.actualIdentifiable.getType());
                newAlias.setTargetLanguage(langFromDb);
                newAlias.setTargetUuid(this.actualIdentifiable.getUuid());
                if (this.actualIdentifiable instanceof Entity) {
                    newAlias.setTargetEntityType(((Entity)this.actualIdentifiable).getEntityType());
                }
                if (websiteUuid != null) {
                    Website ws = new Website();
                    ws.setUuid(websiteUuid);
                    newAlias.setWebsite(ws);
                }
                newAlias.setPrimary(true);
                this.actualIdentifiable.getLocalizedUrlAliases().add(new UrlAlias[]{newAlias});
            }
        }
        this.unsetConflictingPrimaries(this.getPrimaryUrlAliases(this.identifiableInDatabase.getLocalizedUrlAliases(), null), this.getPrimaryUrlAliases(this.actualIdentifiable.getLocalizedUrlAliases(), null));
    }

    private void ensureDefaultAliasesExist() throws CudamiServiceException {
        if (this.actualIdentifiable instanceof Entity && this.cudamiConfig.getUrlAlias().getGenerationExcludes().contains(((Entity)this.actualIdentifiable).getEntityType())) {
            return;
        }
        LocalizedUrlAliases urlAliases = this.actualIdentifiable.getLocalizedUrlAliases();
        if (urlAliases == null) {
            urlAliases = new LocalizedUrlAliases();
            this.actualIdentifiable.setLocalizedUrlAliases(urlAliases);
        }
        for (Locale lang : this.actualIdentifiable.getLabel().getLocales()) {
            if (!(this.actualIdentifiable instanceof Webpage || urlAliases.containsKey((Object)lang) && !((List)urlAliases.get((Object)lang)).stream().allMatch(alias -> alias.getWebsite() != null))) {
                UrlAlias defaultAlias = new UrlAlias();
                defaultAlias.setTargetIdentifiableType(this.actualIdentifiable.getType());
                defaultAlias.setTargetLanguage(lang);
                defaultAlias.setTargetUuid(this.actualIdentifiable.getUuid());
                if (this.actualIdentifiable instanceof Entity) {
                    defaultAlias.setTargetEntityType(((Entity)this.actualIdentifiable).getEntityType());
                }
                defaultAlias.setPrimary(!urlAliases.containsKey((Object)lang));
                try {
                    defaultAlias.setSlug(this.slugGeneratorService.apply(lang, this.actualIdentifiable.getLabel().getText(lang), null));
                }
                catch (CudamiServiceException e) {
                    throw new CudamiServiceException("An error occured during slug generation.", e);
                }
                urlAliases.add(new UrlAlias[]{defaultAlias});
            }
            if (urlAliases.get((Object)lang) != null && ((List)urlAliases.get((Object)lang)).stream().anyMatch(alias -> alias.isPrimary())) continue;
            throw new CudamiServiceException(String.format("There is not any primary alias for language '%s' of identifiable '%s'.", lang, this.actualIdentifiable.getUuid()));
        }
    }

    private void fixMissingLocalizedUrlAliases() {
        if (this.actualIdentifiable.getLocalizedUrlAliases() == null || this.actualIdentifiable.getLocalizedUrlAliases().isEmpty()) {
            LocalizedUrlAliases aliasesFromDb = this.identifiableInDatabase.getLocalizedUrlAliases();
            this.actualIdentifiable.setLocalizedUrlAliases(aliasesFromDb);
        } else if (this.actualIdentifiable.getLocalizedUrlAliases().flatten().stream().allMatch(ua -> ua.isPrimary())) {
            LocalizedUrlAliases urlAliasesToUpdate = this.actualIdentifiable.getLocalizedUrlAliases();
            List<UrlAlias> allPrimariesFromDb = this.getPrimaryUrlAliases(this.identifiableInDatabase.getLocalizedUrlAliases(), null);
            this.unsetConflictingPrimaries(allPrimariesFromDb, urlAliasesToUpdate.flatten());
        }
    }

    private List<UrlAlias> getPrimaryUrlAliases(LocalizedUrlAliases localizedUrlAliases, Locale lang) {
        if (localizedUrlAliases == null) {
            return new ArrayList<UrlAlias>();
        }
        return localizedUrlAliases.flatten().stream().filter(ua -> ua.isPrimary() && (lang == null || ua.getTargetLanguage().equals(lang))).collect(Collectors.toList());
    }

    private void unsetConflictingPrimaries(List<UrlAlias> primariesFromDb, List<UrlAlias> newPrimaryAliases) {
        if (primariesFromDb == null || newPrimaryAliases == null) {
            return;
        }
        for (UrlAlias primaryFromDb : primariesFromDb) {
            Optional<UrlAlias> oldPrimary;
            if (newPrimaryAliases.stream().filter(ua -> !ua.equals((Object)primaryFromDb) && ua.isPrimary()).anyMatch(ua -> (ua.getWebsite() != null && primaryFromDb.getWebsite() != null && ua.getWebsite().getUuid().equals(primaryFromDb.getWebsite().getUuid()) || ua.getWebsite() == primaryFromDb.getWebsite()) && Objects.equals(ua.getTargetLanguage(), primaryFromDb.getTargetLanguage()))) {
                primaryFromDb.setPrimary(false);
            }
            if ((oldPrimary = this.actualIdentifiable.getLocalizedUrlAliases().flatten().stream().filter(ua -> Objects.equals(ua.getUuid(), primaryFromDb.getUuid())).findFirst()).isPresent()) {
                oldPrimary.get().setPrimary(primaryFromDb.isPrimary());
                continue;
            }
            this.actualIdentifiable.getLocalizedUrlAliases().add(new UrlAlias[]{primaryFromDb});
        }
    }

    public static interface SlugGeneratorService {
        public String apply(Locale var1, String var2, UUID var3) throws CudamiServiceException;
    }
}

