/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.alias;

import de.digitalcollections.commons.web.SlugGenerator;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.UrlAliasRepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.CudamiServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class UrlAliasServiceImpl
implements UrlAliasService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlAliasServiceImpl.class);
    private final LocaleService localeService;
    private final UrlAliasRepository repository;
    private final SlugGenerator slugGenerator;

    @Autowired
    public UrlAliasServiceImpl(UrlAliasRepository repository, SlugGenerator slugGenerator, LocaleService localeService) {
        this.repository = repository;
        this.slugGenerator = slugGenerator;
        this.localeService = localeService;
    }

    protected void checkPublication(UrlAlias urlAlias) throws CudamiServiceException {
        if (urlAlias.getLastPublished() != null) {
            if (urlAlias.getUuid() != null) {
                UrlAlias publishedAlias = this.getByUuid(urlAlias.getUuid());
                if (!publishedAlias.isPrimary() && urlAlias.isPrimary()) {
                    urlAlias.setLastPublished(LocalDateTime.now());
                }
                publishedAlias.setPrimary(urlAlias.isPrimary());
                publishedAlias.setLastPublished(urlAlias.getLastPublished());
                if (!urlAlias.equals((Object)publishedAlias)) {
                    throw new CudamiServiceException(String.format("Error: Attempt to change an already published Alias. UUID: %s", urlAlias.getUuid()));
                }
            }
        } else if (urlAlias.isPrimary()) {
            urlAlias.setLastPublished(LocalDateTime.now());
        }
    }

    @Override
    public boolean delete(List<UUID> uuids) throws CudamiServiceException {
        try {
            return this.repository.delete(uuids) > 0;
        }
        catch (UrlAliasRepositoryException e) {
            throw new CudamiServiceException("Cannot delete UrlAliases by uuids: " + e, e);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class, CudamiServiceException.class})
    public boolean deleteAllForTarget(UUID uuid, boolean force) throws CudamiServiceException {
        if (uuid == null) {
            return false;
        }
        LocalizedUrlAliases urlAliases = this.getLocalizedUrlAliases(uuid);
        return this.delete(urlAliases.flatten().stream().filter(ua -> force || ua.getLastPublished() == null).map(ua -> ua.getUuid()).collect(Collectors.toList()));
    }

    protected LocalizedUrlAliases filterForLocale(Locale pLocale, LocalizedUrlAliases localizedUrlAliases) {
        List filteredUrlAliases = localizedUrlAliases.flatten().stream().filter(u -> pLocale.equals(u.getTargetLanguage())).collect(Collectors.toList());
        return new LocalizedUrlAliases(filteredUrlAliases);
    }

    protected LocalizedUrlAliases filterForLocaleWithFallback(Locale pLocale, LocalizedUrlAliases localizedUrlAliases) {
        if (pLocale == null) {
            return localizedUrlAliases;
        }
        if (localizedUrlAliases == null || localizedUrlAliases.isEmpty()) {
            return localizedUrlAliases;
        }
        if (localizedUrlAliases.hasTargetLanguage(pLocale)) {
            return this.filterForLocale(pLocale, localizedUrlAliases);
        }
        return this.filterForLocale(Locale.forLanguageTag(this.localeService.getDefaultLanguage()), localizedUrlAliases);
    }

    @Override
    public PageResponse<LocalizedUrlAliases> find(PageRequest pageRequest) throws CudamiServiceException {
        try {
            return this.repository.find(pageRequest);
        }
        catch (Exception e) {
            throw new CudamiServiceException("Cannot find LocalizedUrlAliases with pageRequest=" + pageRequest + ": " + e, e);
        }
    }

    @Override
    public String generateSlug(Locale pLocale, String label, UUID websiteUuid) throws CudamiServiceException {
        String slug = this.slugGenerator.generateSlug(label);
        try {
            if (!this.repository.hasUrlAlias(slug, websiteUuid, pLocale)) {
                return slug;
            }
        }
        catch (Exception e) {
            throw new CudamiServiceException("Cannot check, if UrlAliases for websiteUuid=" + websiteUuid + ", slug=" + slug + ", locale=" + pLocale + " already exist: " + e, e);
        }
        int suffixId = 1;
        while (true) {
            String numericalSuffixedSlug = slug + "-" + suffixId;
            try {
                if (!this.repository.hasUrlAlias(numericalSuffixedSlug, websiteUuid, pLocale)) {
                    return numericalSuffixedSlug;
                }
            }
            catch (Exception e) {
                throw new CudamiServiceException("Cannot check, if UrlAliases for websiteUuid=" + websiteUuid + ", slug=" + numericalSuffixedSlug + ", locale=" + pLocale + " already exist: " + e, e);
            }
            ++suffixId;
        }
    }

    @Override
    public UrlAlias getByUuid(UUID uuid) throws CudamiServiceException {
        if (uuid == null) {
            return null;
        }
        try {
            return this.repository.getByUuid(uuid);
        }
        catch (Exception e) {
            throw new CudamiServiceException("Cannot find an UrlAlias with uuid=" + uuid + ": " + e, e);
        }
    }

    @Override
    public LocalizedUrlAliases getLocalizedUrlAliases(UUID targetUuid) throws CudamiServiceException {
        try {
            return this.repository.getAllForTarget(targetUuid);
        }
        catch (Exception e) {
            throw new CudamiServiceException("Cannot find LocalizedUrlAliases for identifiable with uuid=" + targetUuid + ": " + e, e);
        }
    }

    @Override
    public LocalizedUrlAliases getPrimaryUrlAliases(UUID websiteUuid, String slug, Locale pLocale) throws CudamiServiceException {
        if (slug == null || slug.isBlank()) {
            throw new CudamiServiceException("Missing or empty slug");
        }
        try {
            if (websiteUuid == null) {
                LocalizedUrlAliases unspecificLocalizedUrlAliases = this.repository.findPrimaryLinksForWebsite(null, slug);
                unspecificLocalizedUrlAliases = this.filterForLocaleWithFallback(pLocale, unspecificLocalizedUrlAliases);
                return unspecificLocalizedUrlAliases;
            }
            LocalizedUrlAliases localizedUrlAliases = this.repository.findPrimaryLinksForWebsite(websiteUuid, slug);
            if (localizedUrlAliases.isEmpty()) {
                localizedUrlAliases = this.repository.findPrimaryLinksForWebsite(null, slug);
            }
            localizedUrlAliases = this.filterForLocaleWithFallback(pLocale, localizedUrlAliases);
            return localizedUrlAliases;
        }
        catch (Exception e) {
            throw new CudamiServiceException("Could not find mainLink for websiteUuid=" + websiteUuid + ", slug=" + slug + ": " + e, e);
        }
    }

    @Override
    public List<UrlAlias> getPrimaryUrlAliasesForTarget(UUID targetUuid) throws CudamiServiceException {
        try {
            LocalizedUrlAliases localizedUrlAliases = this.repository.getAllForTarget(targetUuid);
            if (localizedUrlAliases == null) {
                return new ArrayList<UrlAlias>(0);
            }
            return localizedUrlAliases.flatten().stream().filter(ua -> ua.isPrimary()).collect(Collectors.toList());
        }
        catch (UrlAliasRepositoryException e) {
            throw new CudamiServiceException(String.format("Cannot find all UrlAliases of a specific target. targetUuid='%s'.", targetUuid), e);
        }
    }

    protected LocalizedUrlAliases removeNonmatchingLanguagesForSlug(LocalizedUrlAliases localizedUrlAliases, String slug) {
        List matchingLocales = localizedUrlAliases.flatten().stream().filter(u -> slug.equalsIgnoreCase(u.getSlug())).map(u -> u.getTargetLanguage()).collect(Collectors.toList());
        return new LocalizedUrlAliases(localizedUrlAliases.flatten().stream().filter(u -> matchingLocales.contains(u.getTargetLanguage())).collect(Collectors.toList()));
    }

    @Override
    public UrlAlias save(UrlAlias urlAlias, boolean force) throws CudamiServiceException {
        if (urlAlias == null) {
            throw new CudamiServiceException("Cannot create an empty UrlAlias");
        }
        if (!force && urlAlias.getUuid() != null) {
            throw new CudamiServiceException("Cannot create an UrlAlias, when its UUID is already set!");
        }
        this.checkPublication(urlAlias);
        try {
            return this.repository.save(urlAlias);
        }
        catch (Exception e) {
            throw new CudamiServiceException("Cannot save urlAlias: " + e, e);
        }
    }

    @Override
    public UrlAlias update(UrlAlias urlAlias) throws CudamiServiceException {
        if (urlAlias == null) {
            throw new CudamiServiceException("Cannot update an empty UrlAlias");
        }
        if (urlAlias.getUuid() == null) {
            throw new CudamiServiceException("Cannot update an UrlAlias with empty UUID");
        }
        this.checkPublication(urlAlias);
        try {
            return this.repository.update(urlAlias);
        }
        catch (Exception e) {
            throw new CudamiServiceException("Cannot update urlAlias: " + e, e);
        }
    }

    @Override
    public void validate(LocalizedUrlAliases localizedUrlAliases) throws ValidationException {
        if (localizedUrlAliases == null || localizedUrlAliases.isEmpty()) {
            return;
        }
        HashMap primaries = new HashMap(0);
        localizedUrlAliases.flatten().stream().forEach(u -> {
            String key = (Serializable)(u.getWebsite() != null ? u.getWebsite().getUuid() : "default") + "-" + u.getTargetUuid() + "-" + u.getTargetLanguage();
            Integer primariesPerTuple = primaries.getOrDefault(key, 0);
            if (u.isPrimary()) {
                Integer n = primariesPerTuple;
                Integer n2 = primariesPerTuple = Integer.valueOf(primariesPerTuple + 1);
            }
            primaries.put(key, primariesPerTuple);
        });
        if (primaries.values().stream().collect(Collectors.toSet()).size() != 1 || !primaries.values().contains(1)) {
            throw new ValidationException("violated single primaries: " + primaries);
        }
        HashSet<CallSite> tuples = new HashSet<CallSite>(0);
        for (UrlAlias u2 : localizedUrlAliases.flatten()) {
            String key = (Serializable)(u2.getWebsite() != null ? u2.getWebsite().getUuid() : "default") + "-" + u2.getTargetLanguage() + "-" + u2.getSlug();
            if (tuples.contains(key)) {
                throw new ValidationException("multiple entries for slug=" + u2.getSlug() + ", language=" + u2.getTargetLanguage() + ", website=" + u2.getWebsite() + ", target=" + u2.getTargetUuid());
            }
            tuples.add((CallSite)((Object)key));
        }
    }
}

