/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.DigitalObjectRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.CudamiServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.CollectionService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.DigitalObjectService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.ProjectService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.DigitalObjectLinkedDataFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.DigitalObjectRenderingFileResourceService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.EntityServiceImpl;
import de.digitalcollections.cudami.server.config.HookProperties;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.identifiable.entity.work.Item;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.identifiable.resource.LinkedDataFileResource;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DigitalObjectServiceImpl
extends EntityServiceImpl<DigitalObject>
implements DigitalObjectService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalObjectServiceImpl.class);
    private final CollectionService collectionService;
    private final DigitalObjectLinkedDataFileResourceService digitalObjectLinkedDataFileResourceService;
    private final DigitalObjectRenderingFileResourceService digitalObjectRenderingFileResourceService;
    private final ProjectService projectService;

    public DigitalObjectServiceImpl(DigitalObjectRepository repository, CollectionService collectionService, ProjectService projectService, IdentifierRepository identifierRepository, UrlAliasService urlAliasService, DigitalObjectLinkedDataFileResourceService digitalObjectLinkedDataFileResourceService, DigitalObjectRenderingFileResourceService digitalObjectRenderingFileResourceService, HookProperties hookProperties, LocaleService localeService, CudamiConfig cudamiConfig) {
        super(repository, identifierRepository, urlAliasService, hookProperties, localeService, cudamiConfig);
        this.collectionService = collectionService;
        this.projectService = projectService;
        this.digitalObjectRenderingFileResourceService = digitalObjectRenderingFileResourceService;
        this.digitalObjectLinkedDataFileResourceService = digitalObjectLinkedDataFileResourceService;
    }

    @Override
    public boolean delete(UUID uuid) {
        DigitalObject existingDigitalObject = (DigitalObject)this.getByUuid(uuid);
        if (existingDigitalObject == null) {
            return false;
        }
        this.collectionService.removeDigitalObjectFromAllCollections(existingDigitalObject);
        this.projectService.removeDigitalObjectFromAllProjects(existingDigitalObject);
        this.deleteFileResources(existingDigitalObject.getUuid());
        this.deleteIdentifiers(existingDigitalObject.getUuid());
        this.repository.delete(uuid);
        return true;
    }

    @Override
    public void deleteFileResources(UUID digitalObjectUuid) {
        ((DigitalObjectRepository)this.repository).deleteFileResources(digitalObjectUuid);
    }

    private DigitalObject fillDigitalObject(DigitalObject digitalObject) {
        List<FileResource> renderingResources;
        if (digitalObject == null) {
            return null;
        }
        List<LinkedDataFileResource> linkedDataFileResources = this.getLinkedDataFileResources(digitalObject.getUuid());
        if (linkedDataFileResources != null && !linkedDataFileResources.isEmpty()) {
            digitalObject.setLinkedDataResources(new ArrayList<LinkedDataFileResource>(linkedDataFileResources));
        }
        if ((renderingResources = this.getRenderingResources(digitalObject.getUuid())) != null && !renderingResources.isEmpty()) {
            digitalObject.setRenderingResources(new ArrayList<FileResource>(renderingResources));
        }
        return digitalObject;
    }

    @Override
    public PageResponse<Collection> findActiveCollections(DigitalObject digitalObject, PageRequest pageRequest) {
        Filtering filtering = this.filteringForActive();
        pageRequest.add(filtering);
        return ((DigitalObjectRepository)this.repository).findCollections(digitalObject, pageRequest);
    }

    @Override
    public PageResponse<Collection> findCollections(UUID digitalObjectUuid, PageRequest pageRequest) {
        return ((DigitalObjectRepository)this.repository).findCollections(digitalObjectUuid, pageRequest);
    }

    @Override
    public PageResponse<Project> findProjects(UUID digitalObjectUuid, PageRequest pageRequest) {
        return ((DigitalObjectRepository)this.repository).findProjects(digitalObjectUuid, pageRequest);
    }

    @Override
    public DigitalObject getByIdentifier(Identifier identifier) {
        return this.fillDigitalObject((DigitalObject)super.getByIdentifier(identifier));
    }

    @Override
    public DigitalObject getByIdentifier(String namespace, String id) {
        Identifier identifier = new Identifier(null, namespace, id);
        return this.getByIdentifier(identifier);
    }

    @Override
    public DigitalObject getByRefId(long refId) {
        return this.fillDigitalObject((DigitalObject)super.getByRefId(refId));
    }

    @Override
    public DigitalObject getByUuidAndLocale(UUID uuid, Locale locale) throws IdentifiableServiceException {
        return this.fillDigitalObject((DigitalObject)super.getByUuidAndLocale(uuid, locale));
    }

    @Override
    public List<FileResource> getFileResources(UUID digitalObjectUuid) {
        return ((DigitalObjectRepository)this.repository).getFileResources(digitalObjectUuid);
    }

    @Override
    public List<ImageFileResource> getImageFileResources(UUID digitalObjectUuid) {
        return ((DigitalObjectRepository)this.repository).getImageFileResources(digitalObjectUuid);
    }

    @Override
    public Item getItem(UUID digitalObjectUuid) {
        return ((DigitalObjectRepository)this.repository).getItem(digitalObjectUuid);
    }

    @Override
    public List<Locale> getLanguagesOfCollections(UUID uuid) {
        return ((DigitalObjectRepository)this.repository).getLanguagesOfCollections(uuid);
    }

    @Override
    public List<Locale> getLanguagesOfProjects(UUID uuid) {
        return ((DigitalObjectRepository)this.repository).getLanguagesOfProjects(uuid);
    }

    @Override
    public List<LinkedDataFileResource> getLinkedDataFileResources(UUID digitalObjectUuid) {
        return this.digitalObjectLinkedDataFileResourceService.getLinkedDataFileResources(digitalObjectUuid);
    }

    @Override
    public List<DigitalObject> getRandom(int count) {
        List<DigitalObject> digitalObjects = super.getRandom(count);
        if (digitalObjects == null || digitalObjects.isEmpty()) {
            return digitalObjects;
        }
        return digitalObjects.stream().map(this::fillDigitalObject).collect(Collectors.toList());
    }

    @Override
    public List<FileResource> getRenderingResources(UUID digitalObjectUuid) {
        return this.digitalObjectRenderingFileResourceService.getRenderingFileResources(digitalObjectUuid);
    }

    @Override
    public List<FileResource> getRenderingResources(DigitalObject digitalObject) throws CudamiServiceException {
        return this.digitalObjectRenderingFileResourceService.getRenderingFileResources(digitalObject);
    }

    @Override
    public DigitalObject save(DigitalObject digitalObject) throws IdentifiableServiceException, ValidationException {
        List linkedDataResources = digitalObject.getLinkedDataResources();
        List renderingResources = digitalObject.getRenderingResources();
        digitalObject = super.save(digitalObject);
        this.setLinkedDataFileResources(digitalObject, (List<LinkedDataFileResource>)linkedDataResources);
        try {
            this.setRenderingFileResources(digitalObject, (List<FileResource>)renderingResources);
        }
        catch (CudamiServiceException e) {
            throw new IdentifiableServiceException("Cannot update DigitalObject: " + e, e);
        }
        return this.fillDigitalObject(digitalObject);
    }

    @Override
    public List<FileResource> setFileResources(UUID digitalObjectUuid, List<FileResource> fileResources) {
        return ((DigitalObjectRepository)this.repository).setFileResources(digitalObjectUuid, fileResources);
    }

    @Override
    public List<LinkedDataFileResource> setLinkedDataFileResources(UUID digitalObjectUuid, List<LinkedDataFileResource> linkedDataFileResources) {
        return this.digitalObjectLinkedDataFileResourceService.setLinkedDataFileResources(digitalObjectUuid, linkedDataFileResources);
    }

    @Override
    public List<FileResource> setRenderingFileResources(UUID digitalObjectUuid, List<FileResource> renderingFileResources) throws CudamiServiceException {
        return this.digitalObjectRenderingFileResourceService.setRenderingFileResources(digitalObjectUuid, renderingFileResources);
    }

    @Override
    public List<FileResource> setRenderingFileResources(DigitalObject digitalObject, List<FileResource> renderingFileResources) throws CudamiServiceException {
        return this.digitalObjectRenderingFileResourceService.setRenderingFileResources(digitalObject, renderingFileResources);
    }

    @Override
    public DigitalObject update(DigitalObject digitalObject) throws IdentifiableServiceException, ValidationException {
        List linkedDataResources = digitalObject.getLinkedDataResources();
        List renderingResources = digitalObject.getRenderingResources();
        digitalObject = super.update(digitalObject);
        this.setLinkedDataFileResources(digitalObject, (List<LinkedDataFileResource>)linkedDataResources);
        try {
            this.setRenderingFileResources(digitalObject, (List<FileResource>)renderingResources);
        }
        catch (CudamiServiceException e) {
            throw new IdentifiableServiceException("Cannot update DigitalObject: " + e, e);
        }
        return this.fillDigitalObject(digitalObject);
    }
}

