/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.resource;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.DigitalObjectRenderingFileResourceRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.CudamiServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.ApplicationFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.AudioFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.DigitalObjectRenderingFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.FileResourceMetadataService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.ImageFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.LinkedDataFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.TextFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.VideoFileResourceService;
import de.digitalcollections.model.identifiable.resource.ApplicationFileResource;
import de.digitalcollections.model.identifiable.resource.AudioFileResource;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.identifiable.resource.TextFileResource;
import de.digitalcollections.model.identifiable.resource.VideoFileResource;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DigitalObjectRenderingFileResourceServiceImpl
implements DigitalObjectRenderingFileResourceService {
    protected final ApplicationFileResourceService applicationFileResourceService;
    protected final AudioFileResourceService audioFileResourceService;
    private final DigitalObjectRenderingFileResourceRepository digitalObjectRenderingFileResourceRepository;
    protected final FileResourceMetadataService<FileResource> fileResourceMetadataService;
    protected final ImageFileResourceService imageFileResourceService;
    protected final LinkedDataFileResourceService linkedDataFileResourceService;
    protected final TextFileResourceService textFileResourceService;
    protected final VideoFileResourceService videoFileResourceService;

    public DigitalObjectRenderingFileResourceServiceImpl(ApplicationFileResourceService applicationFileResourceService, AudioFileResourceService audioFileResourceService, @Qualifier(value="fileResourceMetadataService") FileResourceMetadataService<FileResource> fileResourceMetadataService, ImageFileResourceService imageFileResourceService, LinkedDataFileResourceService linkedDataFileResourceService, TextFileResourceService textFileResourceService, VideoFileResourceService videoFileResourceService, DigitalObjectRenderingFileResourceRepository digitalObjectRenderingFileResourceRepository) {
        this.applicationFileResourceService = applicationFileResourceService;
        this.audioFileResourceService = audioFileResourceService;
        this.imageFileResourceService = imageFileResourceService;
        this.fileResourceMetadataService = fileResourceMetadataService;
        this.linkedDataFileResourceService = linkedDataFileResourceService;
        this.textFileResourceService = textFileResourceService;
        this.videoFileResourceService = videoFileResourceService;
        this.digitalObjectRenderingFileResourceRepository = digitalObjectRenderingFileResourceRepository;
    }

    private boolean deleteRenderingResource(FileResource renderingResource) throws IdentifiableServiceException {
        switch (renderingResource.getMimeType().getPrimaryType()) {
            case "application": {
                return this.applicationFileResourceService.delete(renderingResource.getUuid());
            }
            case "audio": {
                return this.audioFileResourceService.delete(renderingResource.getUuid());
            }
            case "image": {
                return this.imageFileResourceService.delete(renderingResource.getUuid());
            }
            case "text": {
                return this.textFileResourceService.delete(renderingResource.getUuid());
            }
            case "video": {
                return this.videoFileResourceService.delete(renderingResource.getUuid());
            }
        }
        return this.fileResourceMetadataService.delete(renderingResource.getUuid());
    }

    @Override
    public List<FileResource> getRenderingFileResources(UUID digitalObjectUuid) {
        return this.digitalObjectRenderingFileResourceRepository.getRenderingFileResources(digitalObjectUuid);
    }

    private FileResource saveRenderingFileResource(FileResource renderingResource) throws ValidationException, IdentifiableServiceException {
        if (renderingResource.getUuid() == null) {
            switch (renderingResource.getMimeType().getPrimaryType()) {
                case "application": {
                    return (FileResource)this.applicationFileResourceService.save((ApplicationFileResource)renderingResource);
                }
                case "audio": {
                    return (FileResource)this.audioFileResourceService.save((AudioFileResource)renderingResource);
                }
                case "image": {
                    return (FileResource)this.imageFileResourceService.save((ImageFileResource)renderingResource);
                }
                case "text": {
                    return (FileResource)this.textFileResourceService.save((TextFileResource)renderingResource);
                }
                case "video": {
                    return (FileResource)this.videoFileResourceService.save((VideoFileResource)renderingResource);
                }
            }
            return this.fileResourceMetadataService.save(renderingResource);
        }
        return renderingResource;
    }

    @Override
    public List<FileResource> setRenderingFileResources(UUID digitalObjectUuid, List<FileResource> renderingResources) throws CudamiServiceException {
        List<FileResource> existingRenderingResources = this.getRenderingFileResources(digitalObjectUuid);
        for (FileResource existingRenderingResource : existingRenderingResources) {
            try {
                this.deleteRenderingResource(existingRenderingResource);
            }
            catch (IdentifiableServiceException e) {
                throw new CudamiServiceException("Cannot remove existing rendering resource=" + existingRenderingResource + ": " + e, e);
            }
        }
        this.digitalObjectRenderingFileResourceRepository.removeByDigitalObject(digitalObjectUuid);
        if (renderingResources != null) {
            ArrayList<FileResource> savedRenderingResources = new ArrayList<FileResource>();
            for (FileResource renderingResource : renderingResources) {
                FileResource savedRenderingResource = null;
                try {
                    savedRenderingResource = this.saveRenderingFileResource(renderingResource);
                }
                catch (IdentifiableServiceException | ValidationException e) {
                    throw new CudamiServiceException("Cannot save RenderingResource" + renderingResource + ": " + e, e);
                }
                savedRenderingResources.add(savedRenderingResource);
            }
            this.digitalObjectRenderingFileResourceRepository.saveRenderingFileResources(digitalObjectUuid, savedRenderingResources);
        }
        return renderingResources;
    }
}

