/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.api.service.identifiable.entity;

import de.digitalcollections.cudami.server.business.api.service.identifiable.NodeService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.EntityService;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface CollectionService
extends NodeService<Collection>,
EntityService<Collection> {
    default public boolean addDigitalObject(Collection collection, DigitalObject digitalObject) {
        if (collection == null || digitalObject == null) {
            return false;
        }
        return this.addDigitalObjects(collection.getUuid(), Arrays.asList(digitalObject));
    }

    default public boolean addDigitalObjects(Collection collection, List<DigitalObject> digitalObjects) {
        if (collection == null || digitalObjects == null) {
            return false;
        }
        return this.addDigitalObjects(collection.getUuid(), digitalObjects);
    }

    public boolean addDigitalObjects(UUID var1, List<DigitalObject> var2);

    public PageResponse<Collection> findActive(PageRequest var1);

    public PageResponse<Collection> findActiveChildren(UUID var1, PageRequest var2);

    default public PageResponse<DigitalObject> findDigitalObjects(Collection collection, PageRequest pageRequest) {
        if (collection == null) {
            return null;
        }
        return this.findDigitalObjects(collection.getUuid(), pageRequest);
    }

    public PageResponse<DigitalObject> findDigitalObjects(UUID var1, PageRequest var2);

    public List<CorporateBody> findRelatedCorporateBodies(UUID var1, Filtering var2);

    public Collection getActive(UUID var1);

    public Collection getActive(UUID var1, Locale var2);

    public List<Collection> getActiveChildren(UUID var1);

    default public boolean removeDigitalObject(Collection collection, DigitalObject digitalObject) {
        if (collection == null || digitalObject == null) {
            return false;
        }
        return this.removeDigitalObject(collection.getUuid(), digitalObject.getUuid());
    }

    public boolean removeDigitalObject(UUID var1, UUID var2);

    public boolean removeDigitalObjectFromAllCollections(DigitalObject var1);

    default public boolean saveDigitalObjects(Collection collection, List<DigitalObject> digitalObjects) {
        if (collection == null || digitalObjects == null) {
            return false;
        }
        return this.setDigitalObjects(collection.getUuid(), digitalObjects);
    }

    public boolean setDigitalObjects(UUID var1, List<DigitalObject> var2);
}

