/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.CollectionRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.CollectionService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.EntityServiceImpl;
import de.digitalcollections.cudami.server.config.HookProperties;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CollectionServiceImpl
extends EntityServiceImpl<Collection>
implements CollectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionServiceImpl.class);

    public CollectionServiceImpl(CollectionRepository repository, IdentifierRepository identifierRepository, UrlAliasService urlAliasService, HookProperties hookProperties, LocaleService localeService, CudamiConfig cudamiConfig) {
        super(repository, identifierRepository, urlAliasService, hookProperties, localeService, cudamiConfig);
    }

    @Override
    public boolean addChildren(UUID parentUuid, List<UUID> childrenUuids) {
        return ((NodeRepository)this.repository).addChildren(parentUuid, childrenUuids);
    }

    @Override
    public boolean addDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) {
        return ((CollectionRepository)this.repository).addDigitalObjects(collectionUuid, digitalObjects);
    }

    @Override
    public PageResponse<Collection> findActive(PageRequest pageRequest) {
        Filtering filtering = this.filteringForActive();
        pageRequest.add(filtering);
        return this.find(pageRequest);
    }

    @Override
    public PageResponse<Collection> findActiveChildren(UUID uuid, PageRequest pageRequest) {
        Filtering filtering = this.filteringForActive();
        pageRequest.add(filtering);
        return this.findChildren(uuid, pageRequest);
    }

    @Override
    public PageResponse<Collection> findChildren(UUID nodeUuid, PageRequest pageRequest) {
        return ((NodeRepository)this.repository).findChildren(nodeUuid, pageRequest);
    }

    @Override
    public PageResponse<DigitalObject> findDigitalObjects(UUID collectionUuid, PageRequest pageRequest) {
        return ((CollectionRepository)this.repository).findDigitalObjects(collectionUuid, pageRequest);
    }

    @Override
    public List<CorporateBody> findRelatedCorporateBodies(UUID uuid, Filtering filtering) {
        return ((CollectionRepository)this.repository).findRelatedCorporateBodies(uuid, filtering);
    }

    @Override
    public PageResponse<Collection> findRootNodes(PageRequest pageRequest) {
        this.setDefaultSorting(pageRequest);
        return ((NodeRepository)this.repository).findRootNodes(pageRequest);
    }

    @Override
    public Collection getActive(UUID uuid) {
        Filtering filtering = this.filteringForActive();
        Collection collection = (Collection)((CollectionRepository)this.repository).getByUuidAndFiltering(uuid, filtering);
        if (collection != null) {
            collection.setChildren(this.getActiveChildren(uuid));
        }
        return collection;
    }

    @Override
    public Collection getActive(UUID uuid, Locale pLocale) {
        Collection collection = this.getActive(uuid);
        return this.reduceMultilanguageFieldsToGivenLocale(collection, pLocale);
    }

    @Override
    public List<Collection> getActiveChildren(UUID uuid) {
        Filtering filtering = this.filteringForActive();
        PageRequest pageRequest = new PageRequest();
        pageRequest.add(filtering);
        return this.findChildren(uuid, pageRequest).getContent();
    }

    @Override
    public BreadcrumbNavigation getBreadcrumbNavigation(UUID nodeUuid) {
        return ((NodeRepository)this.repository).getBreadcrumbNavigation(nodeUuid);
    }

    @Override
    public List<Collection> getChildren(UUID nodeUuid) {
        return ((NodeRepository)this.repository).getChildren(nodeUuid);
    }

    @Override
    public Collection getParent(UUID nodeUuid) {
        return (Collection)((NodeRepository)this.repository).getParent(nodeUuid);
    }

    @Override
    public List<Collection> getParents(UUID uuid) {
        return ((CollectionRepository)this.repository).getParents(uuid);
    }

    @Override
    public List<Locale> getRootNodesLanguages() {
        return ((NodeRepository)this.repository).getRootNodesLanguages();
    }

    @Override
    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        return ((NodeRepository)this.repository).removeChild(parentUuid, childUuid);
    }

    @Override
    public boolean removeDigitalObject(UUID collectionUuid, UUID digitalObjectUuid) {
        return ((CollectionRepository)this.repository).removeDigitalObject(collectionUuid, digitalObjectUuid);
    }

    @Override
    public boolean removeDigitalObjectFromAllCollections(DigitalObject digitalObject) {
        return ((CollectionRepository)this.repository).removeDigitalObjectFromAllCollections(digitalObject);
    }

    @Override
    public Collection saveWithParent(UUID childUuid, UUID parentUuid) throws IdentifiableServiceException {
        try {
            return (Collection)((CollectionRepository)this.repository).saveWithParent(childUuid, parentUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save collection " + childUuid + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public boolean setDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) {
        return ((CollectionRepository)this.repository).setDigitalObjects(collectionUuid, digitalObjects);
    }

    @Override
    public boolean updateChildrenOrder(UUID parentUuid, List<Collection> children) {
        return ((NodeRepository)this.repository).updateChildrenOrder(parentUuid, children);
    }
}

