/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.resource;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.FileResourceMetadataRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.ApplicationFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.AudioFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.FileResourceMetadataService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.ImageFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.LinkedDataFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.TextFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.VideoFileResourceService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.IdentifiableServiceImpl;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.resource.ApplicationFileResource;
import de.digitalcollections.model.identifiable.resource.AudioFileResource;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.identifiable.resource.LinkedDataFileResource;
import de.digitalcollections.model.identifiable.resource.TextFileResource;
import de.digitalcollections.model.identifiable.resource.VideoFileResource;
import de.digitalcollections.model.text.LocalizedText;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="fileResourceMetadataService")
public class FileResourceMetadataServiceImpl
extends IdentifiableServiceImpl<FileResource>
implements FileResourceMetadataService<FileResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourceMetadataServiceImpl.class);
    protected final ApplicationFileResourceService applicationFileResourceService;
    protected final AudioFileResourceService audioFileResourceService;
    protected final ImageFileResourceService imageFileResourceService;
    protected final LinkedDataFileResourceService linkedDataFileResourceService;
    private final LocaleService localeService;
    protected final TextFileResourceService textFileResourceService;
    protected final VideoFileResourceService videoFileResourceService;

    public FileResourceMetadataServiceImpl(FileResourceMetadataRepository<FileResource> metadataRepository, ApplicationFileResourceService applicationFileResourceService, AudioFileResourceService audioFileResourceService, ImageFileResourceService imageFileResourceService, LinkedDataFileResourceService linkedDataFileResourceService, TextFileResourceService textFileResourceService, VideoFileResourceService videoFileResourceService, LocaleService localeService, IdentifierRepository identifierRepository, UrlAliasService urlAliasService, CudamiConfig cudamiConfig) {
        super(metadataRepository, identifierRepository, urlAliasService, localeService, cudamiConfig);
        this.applicationFileResourceService = applicationFileResourceService;
        this.audioFileResourceService = audioFileResourceService;
        this.imageFileResourceService = imageFileResourceService;
        this.linkedDataFileResourceService = linkedDataFileResourceService;
        this.textFileResourceService = textFileResourceService;
        this.videoFileResourceService = videoFileResourceService;
        this.localeService = localeService;
    }

    @Override
    public FileResource createByMimeType(MimeType mimeType) {
        return ((FileResourceMetadataRepository)this.repository).createByMimeType(mimeType);
    }

    @Override
    public FileResource getByIdentifier(String namespace, String id) {
        FileResource fileResource = (FileResource)this.repository.getByIdentifier(namespace, id);
        return this.getTypeSpecific(fileResource);
    }

    @Override
    public FileResource getByUuid(UUID uuid) {
        FileResource fileResource = (FileResource)this.repository.getByUuid(uuid);
        return this.getTypeSpecific(fileResource);
    }

    private FileResource getTypeSpecific(FileResource fileResource) {
        if (fileResource == null) {
            return null;
        }
        FileResource specificFileResource = this.createByMimeType(fileResource.getMimeType());
        if (specificFileResource instanceof ApplicationFileResource) {
            return (FileResource)this.applicationFileResourceService.getByUuid(fileResource.getUuid());
        }
        if (specificFileResource instanceof AudioFileResource) {
            return (FileResource)this.audioFileResourceService.getByUuid(fileResource.getUuid());
        }
        if (specificFileResource instanceof ImageFileResource) {
            return (FileResource)this.imageFileResourceService.getByUuid(fileResource.getUuid());
        }
        if (specificFileResource instanceof LinkedDataFileResource) {
            return (FileResource)this.linkedDataFileResourceService.getByUuid(fileResource.getUuid());
        }
        if (specificFileResource instanceof TextFileResource) {
            return (FileResource)this.textFileResourceService.getByUuid(fileResource.getUuid());
        }
        if (specificFileResource instanceof VideoFileResource) {
            return (FileResource)this.videoFileResourceService.getByUuid(fileResource.getUuid());
        }
        return fileResource;
    }

    @Override
    public FileResource save(FileResource fileResource) throws IdentifiableServiceException, ValidationException {
        if (fileResource.getLabel() == null && fileResource.getFilename() != null) {
            fileResource.setLabel(new LocalizedText(new Locale(this.localeService.getDefaultLanguage()), fileResource.getFilename()));
        }
        if (fileResource instanceof ApplicationFileResource) {
            return (FileResource)this.applicationFileResourceService.save((ApplicationFileResource)fileResource);
        }
        if (fileResource instanceof AudioFileResource) {
            return (FileResource)this.audioFileResourceService.save((AudioFileResource)fileResource);
        }
        if (fileResource instanceof ImageFileResource) {
            return (FileResource)this.imageFileResourceService.save((ImageFileResource)fileResource);
        }
        if (fileResource instanceof LinkedDataFileResource) {
            return (FileResource)this.linkedDataFileResourceService.save((LinkedDataFileResource)fileResource);
        }
        if (fileResource instanceof TextFileResource) {
            return (FileResource)this.textFileResourceService.save((TextFileResource)fileResource);
        }
        if (fileResource instanceof VideoFileResource) {
            return (FileResource)this.videoFileResourceService.save((VideoFileResource)fileResource);
        }
        return super.save(fileResource);
    }

    @Override
    public FileResource update(FileResource fileResource) throws IdentifiableServiceException, ValidationException {
        if (fileResource instanceof ApplicationFileResource) {
            return (FileResource)this.applicationFileResourceService.update((ApplicationFileResource)fileResource);
        }
        if (fileResource instanceof AudioFileResource) {
            return (FileResource)this.audioFileResourceService.update((AudioFileResource)fileResource);
        }
        if (fileResource instanceof ImageFileResource) {
            return (FileResource)this.imageFileResourceService.update((ImageFileResource)fileResource);
        }
        if (fileResource instanceof LinkedDataFileResource) {
            return (FileResource)this.linkedDataFileResourceService.update((LinkedDataFileResource)fileResource);
        }
        if (fileResource instanceof TextFileResource) {
            return (FileResource)this.textFileResourceService.update((TextFileResource)fileResource);
        }
        if (fileResource instanceof VideoFileResource) {
            return (FileResource)this.videoFileResourceService.update((VideoFileResource)fileResource);
        }
        return super.update(fileResource);
    }
}

