/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.TopicRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifierService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.TopicService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.EntityServiceImpl;
import de.digitalcollections.cudami.server.config.HookProperties;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.Topic;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TopicServiceImpl
extends EntityServiceImpl<Topic>
implements TopicService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopicServiceImpl.class);

    public TopicServiceImpl(TopicRepository repository, IdentifierService identifierService, UrlAliasService urlAliasService, HookProperties hookProperties, LocaleService localeService, CudamiConfig cudamiConfig) {
        super(repository, identifierService, urlAliasService, hookProperties, localeService, cudamiConfig);
    }

    @Override
    public boolean addChild(Topic parent, Topic child) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).addChild((Identifiable)parent, (Identifiable)child);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public boolean addChildren(Topic parent, List<Topic> children) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).addChildren((Identifiable)parent, children);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public PageResponse<Topic> findChildren(Topic topic, PageRequest pageRequest) throws ServiceException {
        PageResponse pageResponse;
        try {
            pageResponse = ((NodeRepository)this.repository).findChildren((Identifiable)topic, pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        return pageResponse;
    }

    @Override
    public PageResponse<Entity> findEntities(Topic topic, PageRequest pageRequest) throws ServiceException {
        try {
            return ((TopicRepository)this.repository).findEntities(topic, pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public PageResponse<FileResource> findFileResources(Topic topic, PageRequest pageRequest) throws ServiceException {
        try {
            return ((TopicRepository)this.repository).findFileResources(topic, pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public PageResponse<Topic> findRootNodes(PageRequest pageRequest) throws ServiceException {
        PageResponse pageResponse;
        this.setDefaultSorting(pageRequest);
        try {
            pageResponse = ((NodeRepository)this.repository).findRootNodes(pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        return pageResponse;
    }

    @Override
    public BreadcrumbNavigation getBreadcrumbNavigation(Topic topic) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).getBreadcrumbNavigation((Identifiable)topic);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<Topic> getChildren(Topic topic) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).getChildren((Identifiable)topic);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<FileResource> getFileResources(Topic topic) throws ServiceException {
        try {
            return ((TopicRepository)this.repository).getFileResources(topic);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<Locale> getLanguagesOfEntities(Topic topic) throws ServiceException {
        try {
            return ((TopicRepository)this.repository).getLanguagesOfEntities(topic);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<Locale> getLanguagesOfFileResources(Topic topic) throws ServiceException {
        try {
            return ((TopicRepository)this.repository).getLanguagesOfFileResources(topic);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public Topic getParent(Topic topic) throws ServiceException {
        Topic parent;
        try {
            parent = (Topic)((NodeRepository)this.repository).getParent((Identifiable)topic);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        return parent;
    }

    @Override
    public List<Topic> getParents(Topic topic) throws ServiceException {
        List parents;
        try {
            parents = ((NodeRepository)this.repository).getParents((Identifiable)topic);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        return parents;
    }

    @Override
    public List<Locale> getRootNodesLanguages() throws ServiceException {
        try {
            return ((NodeRepository)this.repository).getRootNodesLanguages();
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<Topic> getTopicsOfEntity(Entity entity) throws ServiceException {
        try {
            return ((TopicRepository)this.repository).getTopicsOfEntity(entity);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<Topic> getTopicsOfFileResource(FileResource fileResource) throws ServiceException {
        try {
            return ((TopicRepository)this.repository).getTopicsOfFileResource(fileResource);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public boolean removeChild(Topic parent, Topic child) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).removeChild((Identifiable)parent, (Identifiable)child);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public Topic saveWithParent(Topic child, Topic parent) throws ServiceException {
        try {
            Topic topic = (Topic)((TopicRepository)this.repository).saveWithParent((Identifiable)child, (Identifiable)parent);
            return topic;
        }
        catch (Exception e) {
            LOGGER.error("Cannot save topic " + child + ": ", (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }

    @Override
    public List<Entity> setEntities(Topic topic, List<Entity> entities) throws ServiceException {
        try {
            return ((TopicRepository)this.repository).setEntities(topic, entities);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<FileResource> setFileResources(Topic topic, List<FileResource> fileResources) throws ServiceException {
        try {
            return ((TopicRepository)this.repository).setFileResources(topic, fileResources);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public boolean updateChildrenOrder(Topic parent, List<Topic> children) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).updateChildrenOrder((Identifiable)parent, children);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }
}

