/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.web;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.web.WebpageRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.content.ManagedContentService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifierService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.web.WebpageService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.IdentifiableServiceImpl;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebpageServiceImpl
extends IdentifiableServiceImpl<Webpage, WebpageRepository>
implements WebpageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageServiceImpl.class);

    @Autowired
    public WebpageServiceImpl(WebpageRepository repository, IdentifierService identifierService, UrlAliasService urlAliasService, LocaleService localeService, CudamiConfig cudamiConfig) {
        super(repository, identifierService, urlAliasService, localeService, cudamiConfig);
    }

    @Override
    public boolean addChild(Webpage parent, Webpage child) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).addChild((Identifiable)parent, (Identifiable)child);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public boolean addChildren(Webpage parent, List<Webpage> children) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).addChildren((Identifiable)parent, children);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public PageResponse<Webpage> find(PageRequest pageRequest) throws ServiceException {
        PageResponse pageResponse = super.find(pageRequest);
        this.setPublicationStatus(pageResponse.getContent());
        return pageResponse;
    }

    @Override
    public PageResponse<Webpage> findActiveChildren(Webpage webpage, PageRequest pageRequest) throws ServiceException {
        Filtering filtering = ManagedContentService.filteringForActive();
        pageRequest.add(filtering);
        return this.findChildren(webpage, pageRequest);
    }

    @Override
    public PageResponse<Webpage> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) throws ServiceException {
        PageResponse pageResponse = super.findByLanguageAndInitial(pageRequest, language, initial);
        this.setPublicationStatus(pageResponse.getContent());
        return pageResponse;
    }

    @Override
    public PageResponse<Webpage> findChildren(Webpage webpage, PageRequest pageRequest) throws ServiceException {
        PageResponse pageResponse;
        try {
            pageResponse = ((NodeRepository)this.repository).findChildren((Identifiable)webpage, pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        this.setPublicationStatus(pageResponse.getContent());
        return pageResponse;
    }

    @Override
    public PageResponse<Webpage> findRootNodes(PageRequest pageRequest) throws ServiceException {
        PageResponse pageResponse;
        try {
            pageResponse = ((NodeRepository)this.repository).findRootNodes(pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        this.setPublicationStatus(pageResponse.getContent());
        return pageResponse;
    }

    @Override
    public PageResponse<Webpage> findRootWebpagesForWebsite(Website website, PageRequest pageRequest) throws ServiceException {
        PageResponse pageResponse;
        try {
            pageResponse = ((WebpageRepository)this.repository).findRootWebpagesForWebsite(website, pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        this.setPublicationStatus(pageResponse.getContent());
        return pageResponse;
    }

    @Override
    public List<Webpage> getActiveChildren(Webpage webpage) throws ServiceException {
        Filtering filtering = ManagedContentService.filteringForActive();
        PageRequest pageRequest = new PageRequest();
        pageRequest.add(filtering);
        List children = this.findChildren(webpage, pageRequest).getContent();
        this.setPublicationStatus(children);
        return children;
    }

    @Override
    public List<Webpage> getActiveChildrenTree(Webpage webpage) throws ServiceException {
        List<Webpage> webpages = this.getActiveChildren(webpage);
        List<Webpage> list = webpages.stream().peek(w -> {
            try {
                w.setChildren(this.getActiveChildrenTree((Webpage)w));
            }
            catch (ServiceException e) {
                LOGGER.error("Can not get active children tree for webpage", (Throwable)e);
            }
        }).collect(Collectors.toList());
        this.setPublicationStatus(list);
        return list;
    }

    @Override
    public BreadcrumbNavigation getBreadcrumbNavigation(Webpage webpage) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).getBreadcrumbNavigation((Identifiable)webpage);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public Webpage getByExample(Webpage uniqueObject) throws ServiceException {
        Webpage webpage = super.getByExample(uniqueObject);
        if (webpage != null) {
            this.setPublicationStatus(webpage);
        }
        return webpage;
    }

    @Override
    public Webpage getByExampleAndActive(Webpage example) throws ServiceException {
        Webpage webpage;
        Filtering filtering = ManagedContentService.filteringForActive();
        try {
            webpage = (Webpage)((WebpageRepository)this.repository).getByExampleAndFiltering((UniqueObject)example, filtering);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        if (webpage != null) {
            this.setPublicationStatus(webpage);
            webpage.setChildren(this.getActiveChildren(webpage));
        }
        return webpage;
    }

    @Override
    public Webpage getByExampleAndActiveAndLocale(Webpage example, Locale pLocale) throws ServiceException {
        Webpage webpage = this.getByExampleAndActive(example);
        if ((webpage = this.reduceMultilanguageFieldsToGivenLocale(webpage, pLocale)) != null) {
            this.setPublicationStatus(webpage);
            webpage.setChildren(this.getActiveChildren(webpage));
        }
        return webpage;
    }

    @Override
    public Webpage getByIdentifier(Identifier identifier) throws ServiceException {
        Webpage webpage = (Webpage)super.getByIdentifier(identifier);
        if (webpage != null) {
            this.setPublicationStatus(webpage);
        }
        return webpage;
    }

    @Override
    public Webpage getByExampleAndLocale(Webpage example, Locale locale) throws ServiceException {
        Webpage webpage = super.getByExampleAndLocale(example, locale);
        this.setPublicationStatus(webpage);
        return webpage;
    }

    @Override
    public List<Webpage> getChildren(Webpage webpage) throws ServiceException {
        List children;
        try {
            children = ((NodeRepository)this.repository).getChildren((Identifiable)webpage);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        this.setPublicationStatus(children);
        return children;
    }

    @Override
    public List<Webpage> getChildrenTree(Webpage webpage) throws ServiceException {
        List<Webpage> webpages = this.getChildren(webpage);
        List<Webpage> list = webpages.stream().peek(w -> {
            try {
                w.setChildren(this.getChildrenTree((Webpage)w));
            }
            catch (ServiceException e) {
                LOGGER.error("Can not get children tree for webpage", (Throwable)e);
            }
        }).collect(Collectors.toList());
        this.setPublicationStatus(list);
        return list;
    }

    @Override
    public Webpage getParent(Webpage webpage) throws ServiceException {
        Webpage parent;
        try {
            parent = (Webpage)((NodeRepository)this.repository).getParent((Identifiable)webpage);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        this.setPublicationStatus(parent);
        return parent;
    }

    @Override
    public List<Webpage> getParents(Webpage webpage) throws ServiceException {
        List parents;
        try {
            parents = ((NodeRepository)this.repository).getParents((Identifiable)webpage);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        this.setPublicationStatus(parents);
        return parents;
    }

    @Override
    public List<Webpage> getRandom(int count) throws ServiceException {
        List<Webpage> webpages = super.getRandom(count);
        this.setPublicationStatus(webpages);
        return webpages;
    }

    @Override
    public List<Locale> getRootNodesLanguages() throws ServiceException {
        try {
            return ((NodeRepository)this.repository).getRootNodesLanguages();
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public Website getWebsite(Webpage webpage) throws ServiceException {
        Webpage rootWebpage = webpage;
        Webpage parent = this.getParent(webpage);
        while (parent != null) {
            rootWebpage = parent;
            parent = this.getParent(parent);
        }
        try {
            return ((WebpageRepository)this.repository).getWebsite(rootWebpage);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public boolean removeChild(Webpage parent, Webpage child) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).removeChild((Identifiable)parent, (Identifiable)child);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public void save(Webpage identifiable) throws ServiceException, ValidationException {
        if (identifiable.getLocalizedUrlAliases() != null && !identifiable.getLocalizedUrlAliases().isEmpty()) {
            this.validate(identifiable.getLocalizedUrlAliases());
        }
        super.save(identifiable);
        this.setPublicationStatus(identifiable);
    }

    @Override
    public Webpage saveWithParent(Webpage child, Webpage parent) throws ServiceException {
        try {
            Webpage webpage = (Webpage)((NodeRepository)this.repository).saveWithParent((Identifiable)child, (Identifiable)parent);
            this.setPublicationStatus(webpage);
            return webpage;
        }
        catch (Exception e) {
            LOGGER.error("Cannot save webpage " + child + ": ", (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }

    @Override
    public Webpage saveWithParentWebsite(Webpage webpage, Website parentWebsite) throws ServiceException {
        try {
            if (webpage.getUuid() == null) {
                this.save(webpage);
            }
            try {
                webpage = ((WebpageRepository)this.repository).saveWithParentWebsite(webpage, parentWebsite);
            }
            catch (RepositoryException e) {
                throw new ServiceException("Backend failure", e);
            }
            this.setPublicationStatus(webpage);
            return webpage;
        }
        catch (ServiceException | ValidationException e) {
            LOGGER.error("Cannot save top-level webpage " + webpage + ": ", (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }

    @Override
    public void update(Webpage identifiable) throws ServiceException, ValidationException {
        if (identifiable.getLocalizedUrlAliases() != null && !identifiable.getLocalizedUrlAliases().isEmpty()) {
            this.validate(identifiable.getLocalizedUrlAliases());
        }
        super.update(identifiable);
        this.setPublicationStatus(identifiable);
    }

    @Override
    public boolean updateChildrenOrder(Webpage parent, List<Webpage> children) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).updateChildrenOrder((Identifiable)parent, children);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    private void validate(LocalizedUrlAliases localizedUrlAliases) throws ValidationException {
        for (UrlAlias urlAlias : localizedUrlAliases.flatten()) {
            if (urlAlias.getWebsite() != null && urlAlias.getWebsite().getUuid() != null) continue;
            throw new ValidationException("Empty website for " + urlAlias);
        }
    }
}

