/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.validator;

import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.security.UserService;
import de.digitalcollections.model.security.User;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class UniqueUsernameValidator
implements Validator {
    private final UserService userService;

    public UniqueUsernameValidator(UserService userService) {
        this.userService = userService;
    }

    public boolean supports(Class<?> clazz) {
        return User.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        User user = (User)target;
        try {
            User existingUser;
            try {
                existingUser = this.userService.getByUsername(user.getEmail());
            }
            catch (ServiceException e) {
                errors.rejectValue("email", "error.service_unavailable");
                return;
            }
            if (existingUser != null) {
                errors.rejectValue("email", "error.username_already_exists");
                return;
            }
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
    }
}

