/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ResourceNotFoundException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifiableService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifierService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.impl.service.UniqueObjectServiceImpl;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.IdentifiableUrlAliasAlignHelper;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.text.LocalizedText;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="identifiableService")
public class IdentifiableServiceImpl<I extends Identifiable, R extends IdentifiableRepository<I>>
extends UniqueObjectServiceImpl<I, R>
implements IdentifiableService<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiableServiceImpl.class);
    private final CudamiConfig cudamiConfig;
    protected IdentifierService identifierService;
    private final LocaleService localeService;
    private final UrlAliasService urlAliasService;

    public IdentifiableServiceImpl(@Qualifier(value="identifiableRepositoryImpl") R repository, IdentifierService identifierService, UrlAliasService urlAliasService, LocaleService localeService, CudamiConfig cudamiConfig) {
        super(repository);
        this.identifierService = identifierService;
        this.urlAliasService = urlAliasService;
        this.localeService = localeService;
        this.cudamiConfig = cudamiConfig;
    }

    @Override
    public void addRelatedEntity(I identifiable, Entity entity) throws ServiceException {
        try {
            ((IdentifiableRepository)this.repository).addRelatedEntity(identifiable, entity);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public void addRelatedFileresource(I identifiable, FileResource fileResource) throws ServiceException {
        try {
            ((IdentifiableRepository)this.repository).addRelatedFileresource(identifiable, fileResource);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public PageResponse<I> find(PageRequest pageRequest) throws ServiceException {
        this.setDefaultSorting(pageRequest);
        try {
            return super.find(pageRequest);
        }
        catch (ServiceException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public PageResponse<I> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) throws ServiceException {
        try {
            return ((IdentifiableRepository)this.repository).findByLanguageAndInitial(pageRequest, language, initial);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public PageResponse<Entity> findRelatedEntities(I identifiable, PageRequest pageRequest) throws ServiceException {
        try {
            return ((IdentifiableRepository)this.repository).findRelatedEntities(identifiable, pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public PageResponse<FileResource> findRelatedFileResources(I identifiable, PageRequest pageRequest) throws ServiceException {
        try {
            return ((IdentifiableRepository)this.repository).findRelatedFileResources(identifiable, pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public I getByExampleAndLocale(I identifiable, Locale locale) throws ServiceException {
        identifiable = (Identifiable)this.getByExample(identifiable);
        return this.reduceMultilanguageFieldsToGivenLocale(identifiable, locale);
    }

    @Override
    public I getByIdentifier(Identifier identifier) throws ServiceException {
        try {
            return (I)((IdentifiableRepository)this.repository).getByIdentifier(identifier);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<Locale> getLanguages() throws ServiceException {
        try {
            return ((IdentifiableRepository)this.repository).getLanguages();
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    protected I reduceMultilanguageFieldsToGivenLocale(I identifiable, Locale locale) {
        if (identifiable == null) {
            return null;
        }
        LocalizedText label = identifiable.getLabel();
        if (!(label.containsKey((Object)locale) && locale != null || label.containsKey((Object)(locale = new Locale(this.localeService.getDefaultLanguage()))))) {
            locale = (Locale)label.getLocales().iterator().next();
        }
        if (locale == null) {
            return null;
        }
        Locale fLocale = locale;
        label.entrySet().removeIf(entry -> !((Locale)entry.getKey()).equals(fLocale));
        if (identifiable.getDescription() != null) {
            identifiable.getDescription().entrySet().removeIf(entry -> !((Locale)entry.getKey()).equals(fLocale));
        }
        return identifiable;
    }

    @Override
    public void save(I identifiable) throws ServiceException, ValidationException {
        this.validate(identifiable);
        try {
            ((IdentifiableRepository)this.repository).save(identifiable);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Cannot save identifiable " + identifiable + ": " + e, e);
        }
        try {
            IdentifiableUrlAliasAlignHelper.checkDefaultAliases(identifiable, this.cudamiConfig, this.urlAliasService::generateSlug);
            this.urlAliasService.validate(identifiable.getLocalizedUrlAliases());
            if (identifiable.getLocalizedUrlAliases() != null && !identifiable.getLocalizedUrlAliases().isEmpty()) {
                LocalizedUrlAliases savedUrlAliases = new LocalizedUrlAliases();
                for (UrlAlias urlAlias : identifiable.getLocalizedUrlAliases().flatten()) {
                    Identifiable target = ((Identifiable.IdentifiableBuilder)Identifiable.builder().uuid(identifiable.getUuid())).identifiableObjectType(identifiable.getIdentifiableObjectType()).type(identifiable.getType()).build();
                    urlAlias.setTarget(target);
                    this.urlAliasService.save(urlAlias);
                    savedUrlAliases.add(new UrlAlias[]{urlAlias});
                }
                identifiable.setLocalizedUrlAliases(savedUrlAliases);
            }
        }
        catch (ServiceException e) {
            LOGGER.error(String.format("Cannot save UrlAliases for: %s", identifiable), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<Entity> setRelatedEntities(I identifiable, List<Entity> entities) throws ServiceException {
        try {
            return ((IdentifiableRepository)this.repository).setRelatedEntities(identifiable, entities);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<FileResource> setRelatedFileResources(I identifiable, List<FileResource> fileResources) throws ServiceException {
        try {
            return ((IdentifiableRepository)this.repository).setRelatedFileResources(identifiable, fileResources);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public void update(I identifiable) throws ServiceException, ValidationException {
        Identifiable identifiableFromRepo;
        this.validate(identifiable);
        try {
            identifiableFromRepo = (Identifiable)((IdentifiableRepository)this.repository).getByExample(identifiable);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        if (identifiableFromRepo == null) {
            throw new ResourceNotFoundException("No " + identifiable.getClass().getSimpleName() + " found with uuid=" + identifiable.getUuid());
        }
        try {
            ((IdentifiableRepository)this.repository).update(identifiable);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Cannot update identifiable " + identifiable + ": " + e, e);
        }
        try {
            if (IdentifiableUrlAliasAlignHelper.checkIdentifiableExcluded(identifiable, this.cudamiConfig)) {
                return;
            }
            IdentifiableUrlAliasAlignHelper.alignForUpdate(identifiable, identifiableFromRepo, this.cudamiConfig, this.urlAliasService::generateSlug);
            try {
                this.urlAliasService.deleteByIdentifiable((Identifiable)identifiable);
            }
            catch (ConflictException e) {
                throw new ServiceException("Can not delete url alias by identifiable", e);
            }
            try {
                this.urlAliasService.validate(identifiable.getLocalizedUrlAliases());
            }
            catch (ValidationException e) {
                throw new ValidationException("Validation error: " + e, e);
            }
            if (identifiable.getLocalizedUrlAliases() != null) {
                for (UrlAlias urlAlias : identifiable.getLocalizedUrlAliases().flatten()) {
                    if (urlAlias.getUuid() != null && urlAlias.getLastPublished() != null) {
                        this.urlAliasService.update(urlAlias);
                        continue;
                    }
                    this.urlAliasService.save(urlAlias, true);
                }
            }
        }
        catch (ServiceException e) {
            LOGGER.error("Error while updating URL aliases for " + identifiable, (Throwable)e);
            throw e;
        }
    }

    @Override
    public void validate(I identifiable) throws ServiceException, ValidationException {
        if (identifiable.getLabel() == null || identifiable.getLabel().isEmpty()) {
            throw new ValidationException("Missing label");
        }
        try {
            this.identifierService.validate(identifiable.getIdentifiers());
        }
        catch (ServiceException e) {
            throw new ValidationException("Cannot validate: " + e, e);
        }
    }
}

