/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.alias;

import de.digitalcollections.commons.web.SlugGenerator;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.impl.service.UniqueObjectServiceImpl;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UrlAliasServiceImpl
extends UniqueObjectServiceImpl<UrlAlias, UrlAliasRepository>
implements UrlAliasService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlAliasServiceImpl.class);
    private final LocaleService localeService;
    private final SlugGenerator slugGenerator;

    @Autowired
    public UrlAliasServiceImpl(UrlAliasRepository repository, SlugGenerator slugGenerator, LocaleService localeService) {
        super(repository);
        this.slugGenerator = slugGenerator;
        this.localeService = localeService;
    }

    protected void checkPublication(UrlAlias urlAlias) throws ServiceException {
        if (urlAlias.getLastPublished() != null) {
            if (urlAlias.getUuid() != null) {
                UrlAlias publishedAlias = this.getByExample(urlAlias);
                if (!publishedAlias.isPrimary() && urlAlias.isPrimary()) {
                    urlAlias.setLastPublished(LocalDateTime.now());
                }
                publishedAlias.setPrimary(urlAlias.isPrimary());
                publishedAlias.setLastPublished(urlAlias.getLastPublished());
                if (!urlAlias.equals((Object)publishedAlias)) {
                    throw new ServiceException(String.format("Error: Attempt to change an already published Alias. UUID: %s", urlAlias.getUuid()));
                }
            }
        } else if (urlAlias.isPrimary()) {
            urlAlias.setLastPublished(LocalDateTime.now());
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class, ServiceException.class})
    public boolean deleteByIdentifiable(Identifiable identifiable, boolean force) throws ServiceException, ConflictException {
        try {
            return ((UrlAliasRepository)this.repository).deleteByIdentifiable(identifiable, force);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure");
        }
    }

    protected LocalizedUrlAliases filterForLocale(Locale pLocale, LocalizedUrlAliases localizedUrlAliases) {
        List filteredUrlAliases = localizedUrlAliases.flatten().stream().filter(u -> pLocale.equals(UrlAliasRepository.grabLanguageLocale((Locale)u.getTargetLanguage()))).collect(Collectors.toList());
        return new LocalizedUrlAliases(filteredUrlAliases);
    }

    protected LocalizedUrlAliases filterForLocaleWithFallback(Locale pLocale, LocalizedUrlAliases localizedUrlAliases) {
        if (pLocale == null) {
            return localizedUrlAliases;
        }
        if (localizedUrlAliases == null || localizedUrlAliases.isEmpty()) {
            return localizedUrlAliases;
        }
        if (localizedUrlAliases.hasTargetLanguage(pLocale = UrlAliasRepository.grabLanguageLocale((Locale)pLocale))) {
            return this.filterForLocale(pLocale, localizedUrlAliases);
        }
        return this.filterForLocale(Locale.forLanguageTag(this.localeService.getDefaultLanguage()), localizedUrlAliases);
    }

    @Override
    public PageResponse<LocalizedUrlAliases> findLocalizedUrlAliases(PageRequest pageRequest) throws ServiceException {
        try {
            return ((UrlAliasRepository)this.repository).findLocalizedUrlAliases(pageRequest);
        }
        catch (Exception e) {
            throw new ServiceException("Cannot find LocalizedUrlAliases with pageRequest=" + pageRequest + ": " + e, e);
        }
    }

    @Override
    public String generateSlug(Locale pLocale, String label, Website website) throws ServiceException {
        String slug = this.slugGenerator.generateSlug(label);
        try {
            if (!((UrlAliasRepository)this.repository).hasUrlAlias(slug, website, pLocale)) {
                return slug;
            }
        }
        catch (Exception e) {
            throw new ServiceException("Cannot check, if UrlAliases for website=" + website + ", slug=" + slug + ", locale=" + pLocale + " already exist: " + e, e);
        }
        int suffixId = 1;
        while (true) {
            String numericalSuffixedSlug = slug + "-" + suffixId;
            try {
                if (!((UrlAliasRepository)this.repository).hasUrlAlias(numericalSuffixedSlug, website, pLocale)) {
                    return numericalSuffixedSlug;
                }
            }
            catch (Exception e) {
                throw new ServiceException("Cannot check, if UrlAliases for website=" + website + ", slug=" + numericalSuffixedSlug + ", locale=" + pLocale + " already exist: " + e, e);
            }
            ++suffixId;
        }
    }

    @Override
    public LocalizedUrlAliases getByIdentifiable(Identifiable identifiable) throws ServiceException {
        try {
            return ((UrlAliasRepository)this.repository).getByIdentifiable(identifiable);
        }
        catch (Exception e) {
            throw new ServiceException("Cannot find LocalizedUrlAliases for identifiable =" + identifiable + ": " + e, e);
        }
    }

    @Override
    public LocalizedUrlAliases getPrimaryUrlAliases(Website website, String slug, Locale pLocale) throws ServiceException {
        if (slug == null || slug.isBlank()) {
            throw new ServiceException("Missing or empty slug");
        }
        try {
            if (website == null) {
                LocalizedUrlAliases unspecificLocalizedUrlAliases = ((UrlAliasRepository)this.repository).findPrimaryLinksForWebsite((Website)null, slug, pLocale != null);
                unspecificLocalizedUrlAliases = this.filterForLocaleWithFallback(pLocale, unspecificLocalizedUrlAliases);
                return unspecificLocalizedUrlAliases;
            }
            LocalizedUrlAliases localizedUrlAliases = ((UrlAliasRepository)this.repository).findPrimaryLinksForWebsite(website, slug, pLocale != null);
            if (localizedUrlAliases.isEmpty()) {
                localizedUrlAliases = ((UrlAliasRepository)this.repository).findPrimaryLinksForWebsite((Website)null, slug, pLocale != null);
            }
            localizedUrlAliases = this.filterForLocaleWithFallback(pLocale, localizedUrlAliases);
            return localizedUrlAliases;
        }
        catch (Exception e) {
            throw new ServiceException("Could not find mainLink for website=" + website + ", slug=" + slug + ": " + e, e);
        }
    }

    @Override
    public List<UrlAlias> getPrimaryUrlAliasesByIdentifiable(Identifiable identifiable) throws ServiceException {
        try {
            LocalizedUrlAliases localizedUrlAliases = ((UrlAliasRepository)this.repository).getByIdentifiable(identifiable);
            if (localizedUrlAliases == null) {
                return new ArrayList<UrlAlias>(0);
            }
            return localizedUrlAliases.flatten().stream().filter(ua -> ua.isPrimary()).collect(Collectors.toList());
        }
        catch (RepositoryException e) {
            throw new ServiceException(String.format("Cannot find primary UrlAliases by identifiable='%s'.", identifiable), e);
        }
    }

    protected LocalizedUrlAliases removeNonmatchingLanguagesForSlug(LocalizedUrlAliases localizedUrlAliases, String slug) {
        List matchingLocales = localizedUrlAliases.flatten().stream().filter(u -> slug.equalsIgnoreCase(u.getSlug())).map(u -> u.getTargetLanguage()).collect(Collectors.toList());
        return new LocalizedUrlAliases(localizedUrlAliases.flatten().stream().filter(u -> matchingLocales.contains(u.getTargetLanguage())).collect(Collectors.toList()));
    }

    @Override
    public void save(UrlAlias urlAlias, boolean force) throws ServiceException {
        if (urlAlias == null) {
            throw new ServiceException("Cannot create an empty UrlAlias");
        }
        if (!force && urlAlias.getUuid() != null) {
            throw new ServiceException("Cannot create an UrlAlias, when its UUID is already set!");
        }
        this.checkPublication(urlAlias);
        try {
            ((UrlAliasRepository)this.repository).save((UniqueObject)urlAlias);
        }
        catch (Exception e) {
            throw new ServiceException("Cannot save urlAlias: " + e, e);
        }
    }

    @Override
    public void update(UrlAlias urlAlias) throws ServiceException {
        if (urlAlias == null) {
            throw new ServiceException("Cannot update an empty UrlAlias");
        }
        if (urlAlias.getUuid() == null) {
            throw new ServiceException("Cannot update an UrlAlias with empty UUID");
        }
        this.checkPublication(urlAlias);
        try {
            ((UrlAliasRepository)this.repository).update((UniqueObject)urlAlias);
        }
        catch (Exception e) {
            throw new ServiceException("Cannot update urlAlias: " + e, e);
        }
    }

    @Override
    public void validate(LocalizedUrlAliases localizedUrlAliases) throws ValidationException {
        if (localizedUrlAliases == null || localizedUrlAliases.isEmpty()) {
            return;
        }
        HashMap primaries = new HashMap(0);
        localizedUrlAliases.flatten().stream().forEach(u -> {
            String key = (Serializable)(u.getWebsite() != null ? u.getWebsite().getUuid() : "default") + "-" + u.getTarget().getUuid() + "-" + UrlAliasRepository.grabLanguage((Locale)u.getTargetLanguage());
            Integer primariesPerTuple = primaries.getOrDefault(key, 0);
            if (u.isPrimary()) {
                Integer n = primariesPerTuple;
                primariesPerTuple = primariesPerTuple + 1;
            }
            primaries.put(key, primariesPerTuple);
        });
        if (primaries.values().stream().collect(Collectors.toSet()).size() != 1 || !primaries.values().contains(1)) {
            throw new ValidationException("violated single primaries: " + primaries);
        }
        HashSet<CallSite> tuples = new HashSet<CallSite>(0);
        for (UrlAlias u2 : localizedUrlAliases.flatten()) {
            String key = (Serializable)(u2.getWebsite() != null ? u2.getWebsite().getUuid() : "default") + "-" + UrlAliasRepository.grabLanguage((Locale)u2.getTargetLanguage()) + "-" + u2.getSlug();
            if (tuples.contains(key)) {
                throw new ValidationException("multiple entries for slug=" + u2.getSlug() + ", language=" + UrlAliasRepository.grabLanguage((Locale)u2.getTargetLanguage()) + ", website=" + u2.getWebsite() + ", target=" + u2.getTarget().getUuid() + " in " + tuples + " of " + localizedUrlAliases);
            }
            tuples.add((CallSite)((Object)key));
        }
    }
}

