/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class IdentifiableUrlAliasAlignHelper<I extends Identifiable> {
    private CudamiConfig cudamiConfig;
    private SlugGeneratorService slugGeneratorService;
    private I identifiableInDatabase;
    private I actualIdentifiable;

    private IdentifiableUrlAliasAlignHelper(I actualIdentifiable, I identifiableInDatabase, CudamiConfig cudamiConfig, SlugGeneratorService slugGeneratorService) {
        this.actualIdentifiable = actualIdentifiable;
        this.identifiableInDatabase = identifiableInDatabase;
        this.cudamiConfig = cudamiConfig;
        this.slugGeneratorService = slugGeneratorService;
    }

    public static <I extends Identifiable> void alignForUpdate(I actualIdentifiable, I identifiableInDatabase, CudamiConfig cudamiConfig, SlugGeneratorService slugGeneratorService) throws ServiceException {
        if (actualIdentifiable == null || identifiableInDatabase == null || cudamiConfig == null || slugGeneratorService == null) {
            throw new ServiceException("Missing argument. Every parameter must be passed (not null).");
        }
        IdentifiableUrlAliasAlignHelper<I> inst = new IdentifiableUrlAliasAlignHelper<I>(actualIdentifiable, identifiableInDatabase, cudamiConfig, slugGeneratorService);
        try {
            inst.fixMissingLocalizedUrlAliases();
            inst.alignLabelUpdate();
            inst.ensureDefaultAliasesExist();
        }
        catch (RuntimeException e) {
            throw new ServiceException("Uncaught error in IdentifiableUrlAliasAlignHelper::alignForUpdate.", e);
        }
    }

    public static <I extends Identifiable> void checkDefaultAliases(I actualIdentifiable, CudamiConfig cudamiConfig, SlugGeneratorService slugGeneratorService) throws ServiceException {
        if (actualIdentifiable == null || cudamiConfig == null || slugGeneratorService == null) {
            throw new ServiceException("Missing argument. Every parameter must be passed (not null).");
        }
        IdentifiableUrlAliasAlignHelper<Object> inst = new IdentifiableUrlAliasAlignHelper<Object>(actualIdentifiable, null, cudamiConfig, slugGeneratorService);
        try {
            inst.ensureDefaultAliasesExist();
        }
        catch (RuntimeException e) {
            throw new ServiceException("Uncaught error in IdentifiableUrlAliasAlignHelper::checkDefaultAliases.", e);
        }
    }

    private void alignLabelUpdate() throws ServiceException {
        if (this.checkIdentifiableExcluded() || this.identifiableInDatabase == null) {
            return;
        }
        for (Locale langFromDb : UrlAliasRepository.grabLocalesByScript((Collection)this.identifiableInDatabase.getLabel().getLocales())) {
            String labelInIdentifiable;
            String labelSavedInDb = (String)this.identifiableInDatabase.getLabel().get((Object)langFromDb);
            if (Objects.equals(labelSavedInDb, labelInIdentifiable = (String)this.actualIdentifiable.getLabel().get((Object)langFromDb)) || labelInIdentifiable == null) continue;
            Locale langFromDbForAlias = UrlAliasRepository.grabLanguageLocale((Locale)langFromDb);
            List<UrlAlias> primariesFromDb = this.getPrimaryUrlAliases(this.identifiableInDatabase.getLocalizedUrlAliases(), langFromDbForAlias);
            if (this.actualIdentifiable.getLocalizedUrlAliases() == null) {
                this.actualIdentifiable.setLocalizedUrlAliases(new LocalizedUrlAliases());
            }
            for (UrlAlias primaryFromDb : primariesFromDb) {
                UUID websiteUuid = primaryFromDb.getWebsite() != null ? primaryFromDb.getWebsite().getUuid() : null;
                String newSlug = this.slugGeneratorService.apply(langFromDbForAlias, labelInIdentifiable, primaryFromDb.getWebsite());
                if (this.actualIdentifiable.getLocalizedUrlAliases().flatten().stream().anyMatch(ua -> Objects.equals(ua.getSlug(), newSlug) && Objects.equals(UrlAliasRepository.grabLanguageLocale((Locale)ua.getTargetLanguage()), langFromDbForAlias) && Objects.equals(ua.getWebsite() != null ? ua.getWebsite().getUuid() : null, websiteUuid))) continue;
                UrlAlias newAlias = new UrlAlias();
                newAlias.setSlug(newSlug);
                newAlias.setTarget(this.reduceToBasicIdentifiable(this.actualIdentifiable));
                newAlias.setTargetLanguage(langFromDbForAlias);
                if (websiteUuid != null) {
                    Website ws = new Website();
                    ws.setUuid(websiteUuid);
                    newAlias.setWebsite(ws);
                }
                newAlias.setPrimary(true);
                this.actualIdentifiable.getLocalizedUrlAliases().add(new UrlAlias[]{newAlias});
            }
        }
        this.unsetConflictingPrimaries(this.getPrimaryUrlAliases(this.identifiableInDatabase.getLocalizedUrlAliases(), null), this.getPrimaryUrlAliases(this.actualIdentifiable.getLocalizedUrlAliases(), null));
    }

    private boolean checkIdentifiableExcluded() {
        return this.cudamiConfig.getUrlAlias().getGenerationExcludes().contains(this.actualIdentifiable.getIdentifiableObjectType().toString()) || this.actualIdentifiable.getLabel() == null;
    }

    public static <I extends Identifiable> boolean checkIdentifiableExcluded(I actualIdentifiable, CudamiConfig cudamiConfig) throws ServiceException {
        if (actualIdentifiable == null || cudamiConfig == null) {
            throw new ServiceException("Actual Identifiable and cudami config must not be null!");
        }
        IdentifiableUrlAliasAlignHelper<Object> inst = new IdentifiableUrlAliasAlignHelper<Object>(actualIdentifiable, null, cudamiConfig, null);
        return inst.checkIdentifiableExcluded();
    }

    private void ensureDefaultAliasesExist() throws ServiceException {
        List filteredLocales;
        if (this.checkIdentifiableExcluded()) {
            return;
        }
        LocalizedUrlAliases urlAliases = this.actualIdentifiable.getLocalizedUrlAliases();
        if (urlAliases == null) {
            urlAliases = new LocalizedUrlAliases();
            this.actualIdentifiable.setLocalizedUrlAliases(urlAliases);
        }
        if ((filteredLocales = UrlAliasRepository.grabLocalesByScript((Collection)this.actualIdentifiable.getLabel().getLocales())).isEmpty()) {
            Locale urlAliasLang = new Locale("und");
            UrlAlias alias2 = new UrlAlias();
            alias2.setTarget(this.reduceToBasicIdentifiable(this.actualIdentifiable));
            alias2.setTargetLanguage(urlAliasLang);
            alias2.setPrimary(!urlAliases.containsKey((Object)urlAliasLang));
            alias2.setSlug(this.actualIdentifiable.getUuid().toString());
            urlAliases.add(new UrlAlias[]{alias2});
            return;
        }
        for (Locale labelLang : filteredLocales) {
            Locale urlAliasLang = UrlAliasRepository.grabLanguageLocale((Locale)labelLang);
            if (!(this.actualIdentifiable instanceof Webpage || urlAliases.containsKey((Object)urlAliasLang) && !((List)urlAliases.get((Object)urlAliasLang)).stream().allMatch(alias -> alias.getWebsite() != null))) {
                UrlAlias defaultAlias = new UrlAlias();
                defaultAlias.setTarget(this.reduceToBasicIdentifiable(this.actualIdentifiable));
                defaultAlias.setTargetLanguage(urlAliasLang);
                defaultAlias.setPrimary(!urlAliases.containsKey((Object)urlAliasLang));
                try {
                    String labelText = this.actualIdentifiable.getLabel().getText(labelLang);
                    String slug = this.slugGeneratorService.apply(urlAliasLang, labelText, null);
                    defaultAlias.setSlug(slug);
                }
                catch (ServiceException e) {
                    throw new ServiceException("An error occured during slug generation.", e);
                }
                urlAliases.add(new UrlAlias[]{defaultAlias});
            }
            if (urlAliases.get((Object)urlAliasLang) != null && ((List)urlAliases.get((Object)urlAliasLang)).stream().anyMatch(alias -> alias.isPrimary())) continue;
            throw new ServiceException(String.format("There is not any primary alias for language '%s' (%s) of identifiable '%s'.", urlAliasLang, labelLang, this.actualIdentifiable.getUuid()));
        }
    }

    private I reduceToBasicIdentifiable(I identifiable) {
        Identifiable basicIdentifiable = null;
        try {
            basicIdentifiable = (Identifiable)identifiable.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            basicIdentifiable = new Identifiable();
        }
        basicIdentifiable.setIdentifiableObjectType(identifiable.getIdentifiableObjectType());
        basicIdentifiable.setIdentifiers(identifiable.getIdentifiers());
        basicIdentifiable.setUuid(identifiable.getUuid());
        basicIdentifiable.setLabel(identifiable.getLabel());
        return (I)basicIdentifiable;
    }

    private void fixMissingLocalizedUrlAliases() {
        if (this.actualIdentifiable.getLocalizedUrlAliases() == null || this.actualIdentifiable.getLocalizedUrlAliases().isEmpty()) {
            LocalizedUrlAliases aliasesFromDb = this.identifiableInDatabase.getLocalizedUrlAliases();
            this.actualIdentifiable.setLocalizedUrlAliases(aliasesFromDb);
        } else if (this.actualIdentifiable.getLocalizedUrlAliases().flatten().stream().allMatch(ua -> ua.isPrimary())) {
            LocalizedUrlAliases urlAliasesToUpdate = this.actualIdentifiable.getLocalizedUrlAliases();
            List<UrlAlias> allPrimariesFromDb = this.getPrimaryUrlAliases(this.identifiableInDatabase.getLocalizedUrlAliases(), null);
            this.unsetConflictingPrimaries(allPrimariesFromDb, urlAliasesToUpdate.flatten());
        }
    }

    private List<UrlAlias> getPrimaryUrlAliases(LocalizedUrlAliases localizedUrlAliases, Locale lang) {
        if (localizedUrlAliases == null) {
            return new ArrayList<UrlAlias>();
        }
        return localizedUrlAliases.flatten().stream().filter(ua -> ua.isPrimary() && (lang == null || UrlAliasRepository.grabLanguageLocale((Locale)ua.getTargetLanguage()).equals(lang))).collect(Collectors.toList());
    }

    private void unsetConflictingPrimaries(List<UrlAlias> primariesFromDb, List<UrlAlias> newPrimaryAliases) {
        if (primariesFromDb == null || newPrimaryAliases == null) {
            return;
        }
        for (UrlAlias primaryFromDb : primariesFromDb) {
            Optional<UrlAlias> oldPrimary;
            if (newPrimaryAliases.stream().filter(ua -> !ua.equals((Object)primaryFromDb) && ua.isPrimary()).anyMatch(ua -> (ua.getWebsite() != null && primaryFromDb.getWebsite() != null && ua.getWebsite().getUuid().equals(primaryFromDb.getWebsite().getUuid()) || ua.getWebsite() == primaryFromDb.getWebsite()) && Objects.equals(UrlAliasRepository.grabLanguage((Locale)ua.getTargetLanguage()), UrlAliasRepository.grabLanguage((Locale)primaryFromDb.getTargetLanguage())))) {
                primaryFromDb.setPrimary(false);
            }
            if ((oldPrimary = this.actualIdentifiable.getLocalizedUrlAliases().flatten().stream().filter(ua -> Objects.equals(ua.getUuid(), primaryFromDb.getUuid())).findFirst()).isPresent()) {
                oldPrimary.get().setPrimary(primaryFromDb.isPrimary());
                continue;
            }
            this.actualIdentifiable.getLocalizedUrlAliases().add(new UrlAlias[]{primaryFromDb});
        }
    }

    public static interface SlugGeneratorService {
        public String apply(Locale var1, String var2, Website var3) throws ServiceException;
    }
}

