/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.resource;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.DigitalObjectRenderingFileResourceRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.ApplicationFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.AudioFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.DigitalObjectRenderingFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.FileResourceMetadataService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.ImageFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.LinkedDataFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.TextFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.VideoFileResourceService;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.identifiable.resource.FileResource;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DigitalObjectRenderingFileResourceServiceImpl
implements DigitalObjectRenderingFileResourceService {
    protected final ApplicationFileResourceService applicationFileResourceService;
    protected final AudioFileResourceService audioFileResourceService;
    private final DigitalObjectRenderingFileResourceRepository digitalObjectRenderingFileResourceRepository;
    protected final FileResourceMetadataService<FileResource> fileResourceMetadataService;
    protected final ImageFileResourceService imageFileResourceService;
    protected final LinkedDataFileResourceService linkedDataFileResourceService;
    protected final TextFileResourceService textFileResourceService;
    protected final VideoFileResourceService videoFileResourceService;

    public DigitalObjectRenderingFileResourceServiceImpl(ApplicationFileResourceService applicationFileResourceService, AudioFileResourceService audioFileResourceService, @Qualifier(value="fileResourceMetadataService") FileResourceMetadataService<FileResource> fileResourceMetadataService, ImageFileResourceService imageFileResourceService, LinkedDataFileResourceService linkedDataFileResourceService, TextFileResourceService textFileResourceService, VideoFileResourceService videoFileResourceService, DigitalObjectRenderingFileResourceRepository digitalObjectRenderingFileResourceRepository) {
        this.applicationFileResourceService = applicationFileResourceService;
        this.audioFileResourceService = audioFileResourceService;
        this.imageFileResourceService = imageFileResourceService;
        this.fileResourceMetadataService = fileResourceMetadataService;
        this.linkedDataFileResourceService = linkedDataFileResourceService;
        this.textFileResourceService = textFileResourceService;
        this.videoFileResourceService = videoFileResourceService;
        this.digitalObjectRenderingFileResourceRepository = digitalObjectRenderingFileResourceRepository;
    }

    @Override
    public void deleteRenderingFileResources(DigitalObject digitalObject) throws ServiceException {
        List<FileResource> renderingFileResources = this.getRenderingFileResources(digitalObject);
        if (renderingFileResources == null || renderingFileResources.isEmpty()) {
            return;
        }
        for (FileResource renderingFileResource : renderingFileResources) {
            try {
                int amountDeletedRelations;
                try {
                    amountDeletedRelations = this.digitalObjectRenderingFileResourceRepository.delete(renderingFileResource);
                }
                catch (RepositoryException e) {
                    throw new ServiceException("Backend failure", e);
                }
                if (amountDeletedRelations != 1) {
                    throw new ServiceException("Could not delete relation for RenderingFileResource=" + renderingFileResource + " for DigitalObject =" + digitalObject);
                }
                try {
                    if (this.digitalObjectRenderingFileResourceRepository.countDigitalObjectsForResource(renderingFileResource.getUuid()) != 0) continue;
                    this.fileResourceMetadataService.delete(renderingFileResource);
                }
                catch (RepositoryException e) {
                    throw new ServiceException("Backend failure", e);
                }
            }
            catch (ConflictException | ServiceException e) {
                throw new ServiceException("Cannot delete RenderingFileResource=" + renderingFileResource + " for DigitalObject=" + digitalObject + ": " + e, e);
            }
        }
    }

    @Override
    public List<FileResource> getRenderingFileResources(DigitalObject digitalObject) throws ServiceException {
        try {
            return this.digitalObjectRenderingFileResourceRepository.getRenderingFileResources(digitalObject);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<FileResource> setRenderingFileResources(DigitalObject digitalObject, List<FileResource> renderingResources) throws ServiceException {
        List<FileResource> existingRenderingResources = this.getRenderingFileResources(digitalObject);
        for (FileResource fileResource : existingRenderingResources) {
            try {
                this.fileResourceMetadataService.delete(fileResource);
            }
            catch (ConflictException | ServiceException e) {
                throw new ServiceException("Cannot remove existing rendering resource=" + fileResource + ": " + e, e);
            }
        }
        try {
            this.digitalObjectRenderingFileResourceRepository.removeByDigitalObject(digitalObject);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        if (renderingResources != null) {
            ArrayList<FileResource> savedRenderingResources = new ArrayList<FileResource>();
            for (FileResource renderingResource : renderingResources) {
                try {
                    this.fileResourceMetadataService.save(renderingResource);
                }
                catch (ServiceException | ValidationException e) {
                    throw new ServiceException("Cannot save RenderingResource" + renderingResource + ": " + e, e);
                }
                savedRenderingResources.add(renderingResource);
            }
            try {
                this.digitalObjectRenderingFileResourceRepository.setRenderingFileResources(digitalObject, savedRenderingResources);
            }
            catch (RepositoryException repositoryException) {
                throw new ServiceException("Backend failure", repositoryException);
            }
        }
        return renderingResources;
    }
}

