/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.api.service.identifiable.resource;

import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifiableService;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.resource.FileResource;

public interface FileResourceMetadataService<F extends FileResource>
extends IdentifiableService<F> {
    default public FileResource createByContentTypeAndFilename(String contentType, String filename) {
        return this.createByMimeTypeAndFilename(MimeType.fromTypename((String)contentType), filename);
    }

    default public FileResource createByFilename(String filename) {
        MimeType mimeType = MimeType.fromFilename((String)filename);
        FileResource result = this.createByMimeType(mimeType);
        result.setFilename(filename);
        return result;
    }

    default public FileResource createByFilenameExtension(String filenameExtension) {
        MimeType mimeType = MimeType.fromExtension((String)filenameExtension);
        FileResource result = this.createByMimeType(mimeType);
        return result;
    }

    public FileResource createByMimeType(MimeType var1);

    default public FileResource createByMimeTypeAndFilename(MimeType mimeType, String filename) {
        FileResource result = this.createByMimeType(mimeType);
        result.setFilename(filename);
        return result;
    }
}

