/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.api.service.identifiable.entity.geo.location;

import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.EntityService;
import de.digitalcollections.model.geo.CoordinateLocation;
import de.digitalcollections.model.identifiable.entity.geo.location.GeoLocation;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;

public interface GeoLocationService<G extends GeoLocation>
extends EntityService<G> {
    public static final double EARTH_RADIUS_KM = 6371.009;

    public static double deg2dec(int degree, int minutes, int seconds) {
        double dec = (double)degree + (double)minutes / 60.0 + (double)seconds / 3600.0;
        return dec;
    }

    public static double deg2rad(double deg) {
        return deg * Math.PI / 180.0;
    }

    public static double distance(double latitude1, double longitude1, double latitude2, double longitude2) {
        double latitudeSin = Math.sin(Math.toRadians(latitude2 - latitude1) / 2.0);
        double longitudeSin = Math.sin(Math.toRadians(longitude2 - longitude1) / 2.0);
        double a = latitudeSin * latitudeSin + Math.cos(Math.toRadians(latitude1)) * Math.cos(Math.toRadians(latitude2)) * longitudeSin * longitudeSin;
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6378137.0 * c;
    }

    public static double distance(double lat1, double lon1, double lat2, double lon2, String unit) {
        double theta = lon1 - lon2;
        double dist = Math.sin(GeoLocationService.deg2rad(lat1)) * Math.sin(GeoLocationService.deg2rad(lat2)) + Math.cos(GeoLocationService.deg2rad(lat1)) * Math.cos(GeoLocationService.deg2rad(lat2)) * Math.cos(GeoLocationService.deg2rad(theta));
        dist = Math.acos(dist);
        dist = GeoLocationService.rad2deg(dist);
        dist = dist * 60.0 * 1.1515;
        if ("K".equals(unit)) {
            dist *= 1.609344;
        } else if ("N".equals(unit)) {
            dist *= 0.8684;
        }
        return dist;
    }

    public static String distanceInPreferredUnit(GeoLocation geoLocation1, GeoLocation geoLocation2, Unit<Length> preferredUnit) {
        double distanceInMeter = GeoLocationService.distance(geoLocation1.getLatitude(), geoLocation1.getLongitude(), geoLocation2.getLatitude(), geoLocation2.getLongitude());
        long distanceKm = Math.round(distanceInMeter / 1000.0);
        Amount distanceInKm = Amount.valueOf((long)distanceKm, (Unit)SI.KILOMETER);
        long distanceInPreferredUnit = Math.round(distanceInKm.doubleValue(preferredUnit));
        String distance = String.valueOf(distanceInPreferredUnit) + " " + preferredUnit.toString();
        return distance;
    }

    public static double getExtremeLatitudesDiffForPoint(GeoLocation p1, double distance) {
        double latitudeRadians = distance / 6371.009;
        double diffLat = GeoLocationService.rad2deg(latitudeRadians);
        return diffLat;
    }

    public static double getExtremeLongitudesDiffForPoint(GeoLocation p1, double distance) {
        double lat1 = p1.getLatitude();
        lat1 = GeoLocationService.deg2rad(lat1);
        double longitudeRadius = Math.cos(lat1) * 6371.009;
        double diffLong = distance / longitudeRadius;
        diffLong = GeoLocationService.rad2deg(diffLong);
        return diffLong;
    }

    public static GeoLocation[] getExtremePointsFrom(GeoLocation centerLocation, Double distance) {
        double longDiff = GeoLocationService.getExtremeLongitudesDiffForPoint(centerLocation, distance);
        double latDiff = GeoLocationService.getExtremeLatitudesDiffForPoint(centerLocation, distance);
        CoordinateLocation c1 = new CoordinateLocation(Double.valueOf(centerLocation.getLatitude() - latDiff), Double.valueOf(centerLocation.getLongitude() - longDiff), Double.valueOf(0.0), Double.valueOf(0.0));
        GeoLocation p1 = new GeoLocation();
        p1.setCoordinateLocation(c1);
        p1 = GeoLocationService.validatePoint(p1);
        CoordinateLocation c2 = new CoordinateLocation(Double.valueOf(centerLocation.getLatitude() + latDiff), Double.valueOf(centerLocation.getLongitude() + longDiff), Double.valueOf(0.0), Double.valueOf(0.0));
        GeoLocation p2 = new GeoLocation();
        p2.setCoordinateLocation(c2);
        p2 = GeoLocationService.validatePoint(p2);
        return new GeoLocation[]{p1, p2};
    }

    public static double rad2deg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    public static GeoLocation validatePoint(GeoLocation point) {
        if (point.getLatitude() > 90.0) {
            point.getCoordinateLocation().setLatitude(90.0 - (point.getLatitude() - 90.0));
        }
        if (point.getLatitude() < -90.0) {
            point.getCoordinateLocation().setLatitude(-90.0 - (point.getLatitude() + 90.0));
        }
        if (point.getLongitude() > 180.0) {
            point.getCoordinateLocation().setLongitude(-180.0 + (point.getLongitude() - 180.0));
        }
        if (point.getLongitude() < -180.0) {
            point.getCoordinateLocation().setLongitude(180.0 + (point.getLongitude() + 180.0));
        }
        return point;
    }
}

