/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.security;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.security.UserRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.security.UserService;
import de.digitalcollections.cudami.server.business.impl.service.UniqueObjectServiceImpl;
import de.digitalcollections.cudami.server.business.impl.validator.UniqueUsernameValidator;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Sorting;
import de.digitalcollections.model.security.Role;
import de.digitalcollections.model.security.User;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;

@Service
public class UserServiceImpl
extends UniqueObjectServiceImpl<User, UserRepository>
implements UserService,
InitializingBean {
    private UniqueUsernameValidator uniqueUsernameValidator;

    public UserServiceImpl(UserRepository userRepository) {
        super(userRepository);
    }

    @Override
    public User activate(User user) throws ServiceException {
        User userFromRepo;
        try {
            userFromRepo = (User)((UserRepository)this.repository).getByExample((UniqueObject)user);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        userFromRepo.setEnabled(true);
        try {
            ((UserRepository)this.repository).save((UniqueObject)userFromRepo);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        return userFromRepo;
    }

    public void afterPropertiesSet() {
        this.uniqueUsernameValidator = new UniqueUsernameValidator(this);
    }

    @Override
    public User createAdminUser() throws ServiceException {
        User user;
        try {
            user = (User)((UserRepository)this.repository).create();
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        user.getRoles().add(Role.ADMIN);
        return user;
    }

    @Override
    public User deactivate(User user) throws ServiceException {
        User userFromRepo;
        try {
            userFromRepo = (User)((UserRepository)this.repository).getByExample((UniqueObject)user);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        userFromRepo.setEnabled(false);
        try {
            ((UserRepository)this.repository).save((UniqueObject)userFromRepo);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        return userFromRepo;
    }

    @Override
    public boolean doesActiveAdminUserExist() throws ServiceException {
        List findActiveAdminUsers;
        try {
            findActiveAdminUsers = ((UserRepository)this.repository).getActiveAdminUsers();
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        return findActiveAdminUsers != null && !findActiveAdminUsers.isEmpty();
    }

    @Override
    public List<User> getActiveAdminUsers() throws ServiceException {
        try {
            return ((UserRepository)this.repository).getActiveAdminUsers();
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public User getByUsername(String username) throws UsernameNotFoundException, ServiceException {
        User user;
        try {
            user = ((UserRepository)this.repository).getByEmail(username);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        if (user == null || !user.isEnabled()) {
            throw new UsernameNotFoundException(String.format("User \"%s\" was not found.", username));
        }
        return user;
    }

    @Override
    public User save(User user, Errors results) throws ServiceException {
        this.uniqueUsernameValidator.validate(user, results);
        if (!results.hasErrors()) {
            try {
                ((UserRepository)this.repository).save((UniqueObject)user);
            }
            catch (RepositoryException e) {
                throw new ServiceException("Backend failure", e);
            }
            return user;
        }
        return null;
    }

    @Override
    protected void setDefaultSorting(PageRequest pageRequest) {
        if (!pageRequest.hasSorting()) {
            Sorting sorting = new Sorting(Direction.ASC, new String[]{"email"});
            pageRequest.setSorting(sorting);
        }
    }

    @Override
    public User update(User user, Errors results) throws ServiceException {
        try {
            ((UserRepository)this.repository).update((UniqueObject)user);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        return user;
    }
}

