/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.api.service.content;

import de.digitalcollections.model.content.ManagedContent;
import de.digitalcollections.model.content.PublicationStatus;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.time.LocalDateRange;
import de.digitalcollections.model.time.TimeBasedStatus;
import java.time.LocalDate;
import java.util.List;

public interface ManagedContentService<T extends ManagedContent> {
    public static Filtering filteringForActive() {
        LocalDate now = LocalDate.now();
        Filtering filtering = Filtering.builder().add(FilterCriterion.builder().withExpression("publicationStart").lessOrEqualAndSet((Object)now).build()).add(FilterCriterion.builder().withExpression("publicationEnd").greaterOrNotSet((Object)now).build()).build();
        return filtering;
    }

    default public void setPublicationStatus(List<T> managedContentObjects) {
        if (managedContentObjects == null || managedContentObjects.isEmpty()) {
            return;
        }
        managedContentObjects.stream().forEach(mco -> this.setPublicationStatus(mco));
    }

    default public void setPublicationStatus(T managedContentObject) {
        if (managedContentObject == null) {
            return;
        }
        TimeBasedStatus tbs = TimeBasedStatus.get((LocalDateRange)new LocalDateRange(managedContentObject.getPublicationStart(), managedContentObject.getPublicationEnd()), (LocalDate)LocalDate.now());
        switch (tbs) {
            case NOT_YET_IN_RANGE: {
                managedContentObject.setPublicationStatus(PublicationStatus.NOT_YET_PUBLISHED);
                break;
            }
            case IS_IN_RANGE: {
                managedContentObject.setPublicationStatus(PublicationStatus.PUBLISHED);
                break;
            }
            case NO_LONGER_IN_RANGE: {
                managedContentObject.setPublicationStatus(PublicationStatus.NO_LONGER_PUBLISHED);
            }
        }
    }
}

