/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.api.service.identifiable;

import de.digitalcollections.cudami.server.business.api.service.UniqueObjectService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.text.LocalizedText;
import java.util.List;
import java.util.Locale;

public interface IdentifiableService<I extends Identifiable>
extends UniqueObjectService<I> {
    public void addRelatedEntity(I var1, Entity var2) throws ServiceException;

    public void addRelatedFileresource(I var1, FileResource var2) throws ServiceException;

    default public void cleanupLabelFromUnwantedLocales(Locale locale, Locale fallbackLocale, LocalizedText label) {
        if (label == null || label.getLocales() == null || label.getLocales().isEmpty()) {
            return;
        }
        String defaultLabel = null;
        if (label.getLocales().contains(fallbackLocale)) {
            defaultLabel = label.getText(fallbackLocale);
        }
        Locale firstLocale = (Locale)label.getLocales().get(0);
        String firstLocaleLabel = label.getText(firstLocale);
        label.entrySet().removeIf(e -> e.getKey() != locale);
        if (label.keySet().isEmpty()) {
            if (defaultLabel != null) {
                label.put((Object)fallbackLocale, (Object)defaultLabel);
            } else if (firstLocale != null) {
                label.put((Object)firstLocale, (Object)firstLocaleLabel);
            }
        }
    }

    public PageResponse<I> findByLanguageAndInitial(PageRequest var1, String var2, String var3) throws ServiceException;

    public PageResponse<Entity> findRelatedEntities(I var1, PageRequest var2) throws ServiceException;

    public PageResponse<FileResource> findRelatedFileResources(I var1, PageRequest var2) throws ServiceException;

    @Override
    public I getByExampleAndLocale(I var1, Locale var2) throws ServiceException;

    public I getByIdentifier(Identifier var1) throws ServiceException;

    public List<Locale> getLanguages() throws ServiceException;

    public List<Entity> setRelatedEntities(I var1, List<Entity> var2) throws ServiceException;

    public List<FileResource> setRelatedFileResources(I var1, List<FileResource> var2) throws ServiceException;

    public void validate(I var1) throws ServiceException, ValidationException;
}

