/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import de.digitalcollections.cudami.model.api.identifiable.parts.MultilanguageDocument;
import de.digitalcollections.cudami.model.api.identifiable.resource.parts.ContentBlock;
import de.digitalcollections.cudami.model.impl.identifiable.parts.TranslationImpl;
import de.digitalcollections.cudami.model.impl.identifiable.resource.WebpageImpl;
import de.digitalcollections.cudami.server.config.XmlHttpMessageConverter;
import de.digitalcollections.prosemirror.model.impl.DocumentImpl;
import de.digitalcollections.prosemirror.model.impl.MarkImpl;
import de.digitalcollections.prosemirror.model.impl.contentblocks.BlockquoteImpl;
import de.digitalcollections.prosemirror.model.impl.contentblocks.BulletListImpl;
import de.digitalcollections.prosemirror.model.impl.contentblocks.CodeBlockImpl;
import de.digitalcollections.prosemirror.model.impl.contentblocks.HardBreakImpl;
import de.digitalcollections.prosemirror.model.impl.contentblocks.HeadingImpl;
import de.digitalcollections.prosemirror.model.impl.contentblocks.IFrameImpl;
import de.digitalcollections.prosemirror.model.impl.contentblocks.ListItemImpl;
import de.digitalcollections.prosemirror.model.impl.contentblocks.OrderedListImpl;
import de.digitalcollections.prosemirror.model.impl.contentblocks.ParagraphImpl;
import de.digitalcollections.prosemirror.model.impl.contentblocks.TextImpl;
import java.util.HashMap;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.xml.MarshallingHttpMessageConverter;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.xstream.XStreamMarshaller;

public class XmlHttpMessageConverter {
    public HttpMessageConverter<Object> createConverter() {
        XStreamMarshaller xstreamMarshaller = new XStreamMarshaller();
        xstreamMarshaller.setStreamDriver((HierarchicalStreamDriver)new CdataXppDriver(this));
        HashMap<String, Class> aliases = new HashMap<String, Class>();
        aliases.put("blockquote", BlockquoteImpl.class);
        aliases.put("bulletList", BulletListImpl.class);
        aliases.put("codeBlock", CodeBlockImpl.class);
        aliases.put("content", ContentBlock.class);
        aliases.put("contentBlocksContainer", MultilanguageDocument.class);
        aliases.put("document", DocumentImpl.class);
        aliases.put("iframe", IFrameImpl.class);
        aliases.put("hardBreak", HardBreakImpl.class);
        aliases.put("heading", HeadingImpl.class);
        aliases.put("listItem", ListItemImpl.class);
        aliases.put("mark", MarkImpl.class);
        aliases.put("orderedList", OrderedListImpl.class);
        aliases.put("paragraph", ParagraphImpl.class);
        aliases.put("text", TextImpl.class);
        aliases.put("translation", TranslationImpl.class);
        aliases.put("webpage", WebpageImpl.class);
        xstreamMarshaller.setAliases(aliases);
        HashMap<Class<MarkImpl>, String> attributes = new HashMap<Class<MarkImpl>, String>();
        attributes.put(MarkImpl.class, "type");
        xstreamMarshaller.setUseAttributeFor(attributes);
        XStream xStream = xstreamMarshaller.getXStream();
        xStream.aliasSystemAttribute(null, "class");
        xStream.registerConverter((Converter)new MapToFlatConverter(this, xStream.getMapper()));
        xStream.aliasField("body", TextImpl.class, "text");
        xStream.aliasField("content", BlockquoteImpl.class, "contentBlocks");
        xStream.aliasField("content", BulletListImpl.class, "contentBlocks");
        xStream.aliasField("content", CodeBlockImpl.class, "contentBlocks");
        xStream.aliasField("content", DocumentImpl.class, "contentBlocks");
        xStream.aliasField("content", HeadingImpl.class, "contentBlocks");
        xStream.aliasField("content", ListItemImpl.class, "contentBlocks");
        xStream.aliasField("content", OrderedListImpl.class, "contentBlocks");
        xStream.aliasField("content", ParagraphImpl.class, "contentBlocks");
        xStream.setMode(1001);
        MarshallingHttpMessageConverter xmlConverter = new MarshallingHttpMessageConverter();
        xmlConverter.setMarshaller((Marshaller)xstreamMarshaller);
        xmlConverter.setUnmarshaller((Unmarshaller)xstreamMarshaller);
        return xmlConverter;
    }
}

