/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.model.jackson.CudamiObjectMapper;
import de.digitalcollections.cudami.server.config.XmlHttpMessageConverter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableAspectJAutoProxy
public class SpringConfigWeb
implements WebMvcConfigurer,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConfigWeb.class);
    @Autowired
    ObjectMapper objectMapper;
    @Value(value="${server.port:80}")
    Integer port;
    @Value(value="${info.app.project.version:unknown}")
    String projectVersion;

    public void afterPropertiesSet() throws Exception {
        CudamiObjectMapper.customize((ObjectMapper)this.objectMapper);
        this.setupJsondoc();
    }

    private void setupJsondoc() {
        String hostName;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostName = addr.getCanonicalHostName();
            if (!hostName.contains(".")) {
                hostName = "localhost";
            }
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        System.setProperty("jsondoc.basePath", "http://" + hostName + ":" + this.port);
        System.setProperty("jsondoc.version", this.projectVersion);
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseRegisteredSuffixPatternMatch(Boolean.TRUE);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorParameter(true).favorPathExtension(true).ignoreUnknownPathExtensions(true).useRegisteredExtensionsOnly(false).defaultContentType(new MediaType[]{MediaType.APPLICATION_JSON});
        configurer.mediaType("html", MediaType.TEXT_HTML);
        configurer.mediaType("json", MediaType.APPLICATION_JSON);
        configurer.mediaType("xml", MediaType.APPLICATION_XML);
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(this.createXmlHttpMessageConverter());
    }

    private HttpMessageConverter<Object> createXmlHttpMessageConverter() {
        return new XmlHttpMessageConverter().createConverter();
    }
}

