/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.resource;

import de.digitalcollections.cudami.model.api.identifiable.resource.Webpage;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.WebpageService;
import java.util.Locale;
import java.util.UUID;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.annotation.ApiPathParam;
import org.jsondoc.core.annotation.ApiQueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class HtmlViewController {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlViewController.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private WebpageService webpageServcie;

    @ApiMethod(description="get a webpage as HTML")
    @RequestMapping(value={"/v1/webpages/{uuid}.html"}, produces={"text/html"}, method={RequestMethod.GET})
    public String getWebpageAsHtml(@ApiPathParam(description="UUID of the webpage, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @ApiQueryParam(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale, Model model) throws IdentifiableServiceException {
        if (pLocale == null) {
            pLocale = this.localeService.getDefault();
        }
        Webpage webpage = this.webpageServcie.get(uuid, pLocale);
        Locale returnedLocale = this.getLocale(webpage);
        model.addAttribute("locale", (Object)returnedLocale);
        model.addAttribute("webpage", (Object)webpage);
        return "webpage";
    }

    private Locale getLocale(Webpage webpage) {
        if (webpage == null) {
            return null;
        }
        Locale returnedLocale = (Locale)webpage.getText().getDocuments().keySet().iterator().next();
        return returnedLocale;
    }
}

