/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable;

import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifierTypeService;
import de.digitalcollections.model.api.identifiable.IdentifierType;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.api.paging.enums.NullHandling;
import de.digitalcollections.model.impl.paging.OrderImpl;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import de.digitalcollections.model.impl.paging.SortingImpl;
import java.util.Objects;
import java.util.UUID;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.annotation.ApiResponseObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="The identifier types controller", name="Identifier types controller")
public class IndentifierTypeController {
    @Autowired
    private IdentifierTypeService service;

    @ApiMethod(description="Get all identifier types")
    @RequestMapping(value={"/latest/identifiertypes", "/v2/identifiertypes"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiResponseObject
    public PageResponse<IdentifierType> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortField", required=false, defaultValue="uuid") String sortField, @RequestParam(name="sortDirection", required=false, defaultValue="ASC") Direction sortDirection, @RequestParam(name="nullHandling", required=false, defaultValue="NATIVE") NullHandling nullHandling) {
        OrderImpl order = new OrderImpl(sortDirection, sortField, nullHandling);
        SortingImpl sorting = new SortingImpl(new Order[]{order});
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize, (Sorting)sorting);
        return this.service.find((PageRequest)pageRequest);
    }

    @ApiMethod(description="get identifier type by uuid")
    @RequestMapping(value={"/latest/identifiertypes/{uuid}", "/v2/identifiertypes/{uuid}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiResponseObject
    public IdentifierType findById(@PathVariable UUID uuid) {
        return this.service.get(uuid);
    }

    @ApiMethod(description="save a newly created identifier type")
    @RequestMapping(value={"/latest/identifiertypes", "/v2/identifiertypes"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiResponseObject
    public IdentifierType save(@RequestBody IdentifierType identifierType, BindingResult errors) {
        return this.service.save(identifierType);
    }

    @ApiMethod(description="update an identifier type")
    @RequestMapping(value={"/latest/identifiertypes/{uuid}", "/v2/identifiertypes/{uuid}"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ApiResponseObject
    public IdentifierType update(@PathVariable UUID uuid, @RequestBody IdentifierType identifierType, BindingResult errors) {
        assert (Objects.equals(uuid, identifierType.getUuid()));
        return this.service.update(identifierType);
    }
}

