/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity;

import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.ArticleService;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.Article;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.api.paging.enums.NullHandling;
import de.digitalcollections.model.impl.paging.OrderImpl;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import de.digitalcollections.model.impl.paging.SortingImpl;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.annotation.ApiPathParam;
import org.jsondoc.core.annotation.ApiQueryParam;
import org.jsondoc.core.annotation.ApiResponseObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="The article controller", name="Article controller")
public class ArticleController {
    @Autowired
    private ArticleService articleService;

    @ApiMethod(description="Get all articles")
    @RequestMapping(value={"/latest/articles", "/v2/articles"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiResponseObject
    public PageResponse<Article> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortField", required=false, defaultValue="uuid") String sortField, @RequestParam(name="sortDirection", required=false, defaultValue="ASC") Direction sortDirection, @RequestParam(name="nullHandling", required=false, defaultValue="NATIVE") NullHandling nullHandling) {
        OrderImpl order = new OrderImpl(sortDirection, sortField, nullHandling);
        SortingImpl sorting = new SortingImpl(new Order[]{order});
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize, (Sorting)sorting);
        return this.articleService.find((PageRequest)pageRequest);
    }

    @ApiMethod(description="Get an article as JSON or XML, depending on extension or <tt>format</tt> request parameter or accept header")
    @RequestMapping(value={"/latest/articles/{uuid}", "/v2/articles/{uuid}"}, produces={"application/json", "application/xml"}, method={RequestMethod.GET})
    @ApiResponseObject
    public ResponseEntity<Article> getWebpage(@ApiPathParam(description="UUID of the article, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @ApiQueryParam(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) throws IdentifiableServiceException {
        Article article = pLocale == null ? (Article)this.articleService.get(uuid) : this.articleService.get(uuid, pLocale);
        return new ResponseEntity((Object)article, HttpStatus.OK);
    }

    @ApiMethod(description="Save a newly created article")
    @RequestMapping(value={"/latest/articles", "/v2/articles"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiResponseObject
    public Article save(@RequestBody Article article, BindingResult errors) throws IdentifiableServiceException {
        return (Article)this.articleService.save((Identifiable)article);
    }

    @ApiMethod(description="Update an article")
    @RequestMapping(value={"/latest/articles/{uuid}", "/v2/articles/{uuid}"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ApiResponseObject
    public Article update(@PathVariable UUID uuid, @RequestBody Article article, BindingResult errors) throws IdentifiableServiceException {
        assert (Objects.equals(uuid, article.getUuid()));
        return (Article)this.articleService.update((Identifiable)article);
    }
}

