/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity;

import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.CollectionService;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.Collection;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.api.paging.enums.NullHandling;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.paging.OrderImpl;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import de.digitalcollections.model.impl.paging.SortingImpl;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.annotation.ApiPathParam;
import org.jsondoc.core.annotation.ApiQueryParam;
import org.jsondoc.core.annotation.ApiResponseObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="The collection controller", name="Collection controller")
public class CollectionController {
    private CollectionService collectionService;
    @Autowired
    private LocaleService localeService;

    @Autowired
    public CollectionController(CollectionService collectionService) {
        this.collectionService = collectionService;
    }

    @ApiMethod(description="Get all collections")
    @GetMapping(value={"/latest/collections", "/v2/collections"}, produces={"application/json"})
    @ApiResponseObject
    public PageResponse<Collection> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortField", required=false, defaultValue="uuid") String sortField, @RequestParam(name="sortDirection", required=false, defaultValue="ASC") Direction sortDirection, @RequestParam(name="nullHandling", required=false, defaultValue="NATIVE") NullHandling nullHandling) {
        OrderImpl order = new OrderImpl(sortDirection, sortField, nullHandling);
        SortingImpl sorting = new SortingImpl(new Order[]{order});
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize, (Sorting)sorting);
        return this.collectionService.find((PageRequest)pageRequest);
    }

    @ApiMethod(description="Get all top collections")
    @GetMapping(value={"/latest/collections/top", "/v2/collections/top"}, produces={"application/json"})
    @ApiResponseObject
    public PageResponse<Collection> findAllTop(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortField", required=false, defaultValue="uuid") String sortField, @RequestParam(name="sortDirection", required=false, defaultValue="ASC") Direction sortDirection, @RequestParam(name="nullHandling", required=false, defaultValue="NATIVE") NullHandling nullHandling) {
        OrderImpl order = new OrderImpl(sortDirection, sortField, nullHandling);
        SortingImpl sorting = new SortingImpl(new Order[]{order});
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize, (Sorting)sorting);
        return this.collectionService.getTopCollections((PageRequest)pageRequest);
    }

    @ApiMethod(description="Get an collection as JSON or XML, depending on extension or <tt>format</tt> request parameter or accept header")
    @GetMapping(value={"/latest/collections/{uuid}", "/v2/collections/{uuid}"}, produces={"application/json", "application/xml"})
    @ApiResponseObject
    public ResponseEntity<Collection> findByUuid(@ApiPathParam(description="UUID of the collection, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @ApiQueryParam(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) throws IdentifiableServiceException {
        Collection collection = pLocale == null ? (Collection)this.collectionService.get(uuid) : (Collection)this.collectionService.get(uuid, pLocale);
        return new ResponseEntity((Object)collection, HttpStatus.OK);
    }

    @ApiMethod(description="Save a newly created collection")
    @PostMapping(value={"/latest/collections", "/v2/collections"}, produces={"application/json"})
    @ApiResponseObject
    public Collection save(@RequestBody Collection collection, BindingResult errors) throws IdentifiableServiceException {
        return (Collection)this.collectionService.save((Identifiable)collection);
    }

    @ApiMethod(description="Save a newly created collection with parent collection")
    @PostMapping(value={"/latest/collections/{parentUuid}/collection", "/v2/collections/{parentUuid}/collection"}, produces={"application/json"})
    @ApiResponseObject
    public Collection saveWithParentCollection(@ApiPathParam(name="parentUuid", description="The uuid of the parent collection") @PathVariable UUID parentUuid, @RequestBody Collection collection) throws IdentifiableServiceException {
        return this.collectionService.saveWithParentCollection(collection, parentUuid);
    }

    @ApiMethod(description="Update an collection")
    @PutMapping(value={"/latest/collections/{uuid}", "/v2/collections/{uuid}"}, produces={"application/json"})
    @ApiResponseObject
    public Collection update(@PathVariable UUID uuid, @RequestBody Collection collection, BindingResult errors) throws IdentifiableServiceException {
        assert (Objects.equals(uuid, collection.getUuid()));
        return (Collection)this.collectionService.update((Identifiable)collection);
    }

    @ApiMethod(description="Get count of collections")
    @GetMapping(value={"/latest/collections/count", "/v2/collections/count"}, produces={"application/json"})
    @ApiResponseObject
    public long count() {
        return this.collectionService.count();
    }

    @ApiMethod(description="Get the breadcrumb for a collection")
    @GetMapping(value={"/latest/collections/{uuid}/breadcrumb", "/v3/collections/{uuid}/breadcrumb"}, produces={"application/json"})
    @ApiResponseObject
    public ResponseEntity<BreadcrumbNavigation> getBreadcrumb(@ApiPathParam(description="UUID of the collection, e.g. <tt>6119d8e9-9c92-4091-8dcb-bc4053385406</tt>") @PathVariable(value="uuid") UUID uuid, @ApiQueryParam(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) {
        BreadcrumbNavigation breadcrumbNavigation = pLocale == null ? this.collectionService.getBreadcrumbNavigation(uuid) : this.collectionService.getBreadcrumbNavigation(uuid, pLocale, this.localeService.getDefaultLocale());
        if (breadcrumbNavigation == null || breadcrumbNavigation.getNavigationItems().isEmpty()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)breadcrumbNavigation, HttpStatus.OK);
    }
}

